# Usage: make -f path/to/Android.sources.bp.mk NAMES=<> >Android.sources.bp
#
# It will read the Makefile.sources in the current directory, and
# write <NAME>_FILES to stdout as an Android.bp cc_defaults module.

.PHONY: all
all:
	@# Do nothing

include Makefile.sources

empty :=
indent := $(empty)    $(empty)

$(info // Autogenerated with Android.sources.bp.mk)
$(foreach NAME,$(NAMES), \
  $(eval lower_name := $(shell echo $(PREFIX)$(NAME) | tr 'A-Z' 'a-z')) \
  $(info ) \
  $(info cc_defaults {) \
  $(info $(indent)name: "$(lower_name)_sources",) \
  $(info $(indent)srcs: [) \
  $(foreach f,$(filter %.c,$($(NAME)_FILES)), \
    $(info $(indent)$(indent)"$(f)",)) \
  $(info $(indent)],) \
  $(info }))
