/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfvalidator;

import java.util.ArrayList;
import java.util.List;
import org.odftoolkit.odfdom.dom.OdfSchemaConstraint;
import org.odftoolkit.odfdom.pkg.OdfPackageConstraint;
import org.odftoolkit.odfdom.pkg.OdfValidationException;
import org.odftoolkit.odfdom.pkg.ValidationConstraint;
import org.odftoolkit.odfvalidator.Logger;
import org.odftoolkit.odfvalidator.OdfVersion;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ODFPackageErrorHandler
implements ErrorHandler {
    List<SAXParseException> m_aExceptionList = new ArrayList<SAXParseException>();

    ODFPackageErrorHandler() {
    }

    @Override
    public void warning(SAXParseException exception) throws SAXException {
        this.m_aExceptionList.add(exception);
    }

    @Override
    public void error(SAXParseException exception) throws SAXException {
        this.m_aExceptionList.add(exception);
    }

    @Override
    public void fatalError(SAXParseException exception) throws SAXException {
        this.m_aExceptionList.add(exception);
        throw exception;
    }

    boolean processErrors(Logger aPkgLogger, Logger aManifestLogger, Logger aMimetypeLogger, OdfVersion aVersion) {
        boolean bRet = false;
        for (SAXParseException e : this.m_aExceptionList) {
            if (e instanceof OdfValidationException) {
                ValidationConstraint aConstraint = ((OdfValidationException)e).getConstraint();
                if (aConstraint instanceof OdfPackageConstraint) {
                    block0 : switch ((OdfPackageConstraint)aConstraint) {
                        case MANIFEST_DOES_NOT_LIST_FILE: {
                            switch (aVersion) {
                                case V1_0: 
                                case V1_1: {
                                    aManifestLogger.logWarning(e.getMessage());
                                    break block0;
                                }
                            }
                            aManifestLogger.logError(e.getMessage());
                            bRet = true;
                            break;
                        }
                        case MIMETYPE_NOT_FIRST_IN_PACKAGE: 
                        case MIMETYPE_NOT_IN_PACKAGE: {
                            switch (aVersion) {
                                case V1_0: 
                                case V1_1: {
                                    aMimetypeLogger.logWarning(e.getMessage());
                                    break block0;
                                }
                            }
                            aMimetypeLogger.logError(e.getMessage());
                            bRet = true;
                            break;
                        }
                        case MANIFEST_NOT_IN_PACKAGE: 
                        case MANIFEST_LISTS_NONEXISTENT_FILE: {
                            aManifestLogger.logError(e.getMessage());
                            bRet = true;
                            break;
                        }
                        case MIMETYPE_IS_COMPRESSED: 
                        case MIMETYPE_HAS_EXTRA_FIELD: 
                        case MIMETYPE_DIFFERS_FROM_PACKAGE: {
                            aMimetypeLogger.logError(e.getMessage());
                            bRet = true;
                            break;
                        }
                        case MANIFEST_LISTS_DIRECTORY: 
                        case MANIFEST_DOES_NOT_LIST_DIRECTORY: {
                            aManifestLogger.logWarning(e.getMessage());
                            break;
                        }
                        default: {
                            aPkgLogger.logError(e);
                            bRet = true;
                            break;
                        }
                    }
                    continue;
                }
                if (!(aConstraint instanceof OdfSchemaConstraint)) continue;
                switch ((OdfSchemaConstraint)aConstraint) {
                    case DOCUMENT_WITHOUT_ODF_MIMETYPE: 
                    case DOCUMENT_WITHOUT_CONTENT_NOR_STYLES_XML: {
                        aPkgLogger.logError(e.getMessage());
                        bRet = true;
                        break;
                    }
                    default: {
                        aPkgLogger.logError(e);
                        bRet = true;
                    }
                }
                continue;
            }
            aPkgLogger.logError(e);
            bRet = true;
        }
        this.m_aExceptionList.clear();
        return bRet;
    }
}

