/*
 * Copyright (c) 2017, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/* @test
 * @bug 7130915 8289689
 * @summary Tests file path with nfc/nfd forms on MacOSX
 * @requires (os.family == "mac")
 * @library /test/lib ..
 * @build jdk.test.lib.Utils
 *        jdk.test.lib.Asserts
 *        jdk.test.lib.JDKToolFinder
 *        jdk.test.lib.JDKToolLauncher
 *        jdk.test.lib.Platform
 *        jdk.test.lib.process.*
 *        TestUtil MacPath
 * @run main MacPathTest
 * @run main/othervm -Djdk.nio.path.useNormalizationFormD=true MacPathTest
 */

import jdk.test.lib.process.ProcessTools;

public class MacPathTest {
    private static final String PROPERTY_NORMALIZE_FILE_PATHS =
        "jdk.nio.path.useNormalizationFormD";
    private static final boolean NORMALIZE_FILE_PATHS =
        Boolean.getBoolean(PROPERTY_NORMALIZE_FILE_PATHS);

    public static void main(String args[]) throws Exception {
        ProcessBuilder pb;
        if (NORMALIZE_FILE_PATHS) {
            String option = "-D" + PROPERTY_NORMALIZE_FILE_PATHS + "=true";
            pb = ProcessTools.createTestJavaProcessBuilder(option, MacPath.class.getName());
        } else {
            pb = ProcessTools.createTestJavaProcessBuilder(MacPath.class.getName());
        }
        pb.environment().put("LC_ALL", "en_US.UTF-8");
        ProcessTools.executeProcess(pb)
                    .outputTo(System.out)
                    .errorTo(System.err)
                    .shouldHaveExitValue(0);
    }
}
