#!/usr/bin/env bash
#
# Check that linear symbol scaling works in meca
# Reference https://forum.generic-mapping-tools.org/t/linear-scaling-of-moment-tensor-symbols-for-psmeca/1978/14

# Test data from Torsten Becker ("gmtselect -R30/40/23/30 on a recent gCMT catalog in meca style")
# We use sort to plot the largest events first
cat << EOF > tmp.txt
33.85	25.86	10	-4.32	4.231	0.088	-0.004	0.913	-2.65	23	33.85	25.86	B070284A
34.01	27.57	22.5	-2.37	0.698	1.67	-0.872	0.667	-0.525	23	34.01	27.57	C201201301704A
34.21	28.32	15	-2.205	-6.679	8.885	3.77	-2.413	-7.871	23	34.21	28.32	B112295E
36.01	25.02	28.7	-3.29	0.819	2.47	0.226	1.36	-0.761	23	36.01	25.02	C201501122139A
37.76	25.2	12	-4.14	1.21	2.94	0.079	-0.443	-1.95	23	37.76	25.2	C200905191654A
37.77	25.16	12	-1.76	0.958	0.8	-0.508	-0.382	-0.958	23	37.77	25.16	C200905191957A
37.79	25.18	12	-2.39	0.768	1.62	-0.582	-0.063	-1.1	23	37.79	25.18	C200905190638A
30.63	29.74	22	-5.532	3.512	2.02	1.133	0.456	-2.443	24	30.63	29.74	B101292B
32.38	23.88	15	-0.333	5.158	-4.825	0.839	2.534	-2.529	24	32.38	23.88	B111481B
34.08	28.36	15	-1.601	-0.172	1.774	0.256	-4.265	-0.744	24	34.08	28.36	B080393N
34.37	29.03	15	-1.009	0.448	0.561	0.243	-0.562	-0.419	24	34.37	29.03	B022196A
34.48	29.31	15	-0.242	-2.082	2.324	0.727	-0.911	-2.959	24	34.48	29.31	B112395C
34.58	28.45	15	0.034	-0.508	0.474	0.737	0.107	-0.586	24	34.58	28.45	C201605160145A
34.62	28.83	28.3	-0.102	-1.69	1.8	0.3	-0.246	-2.04	24	34.62	28.83	C201506271534A
34.64	27.13	12	-0.207	-1.1	1.3	0.106	-0.004	-0.334	24	34.64	27.13	C202006161430A
37.76	25.2	12	-3.99	1.59	2.4	0.354	-0.285	-1.85	24	37.76	25.2	C200905191735A
34.4	28.62	15	-1.325	-0.131	1.457	-0.173	-0.831	-0.683	25	34.4	28.62	C080393G
34.73	29.07	18.4	-1.361	-3.255	4.616	3.887	0.091	-4.493	26	34.73	29.07	M112295A
EOF
gmt begin seis_13
	sort -gr +9 tmp.txt | gmt meca -Sm0.4i+f0+l+s5e25 -R24/45/19/38 -JM16c -B
gmt end show
