# SPDX-License-Identifier: Apache-2.0
# SPDX-FileCopyrightText: Zygmunt Krynicki
# NOTE: This is using qemu-system-x86-64 (with the final dash instead of underscore), on purpose.
QEMU_SYSTEM_X86_64 ?= $(if $(value SNAP_INSTANCE_NAME),$$(if [ -z "$${SNAP_INSTANCE_NAME-}" ]; then echo $(SNAP_INSTANCE_NAME).qemu-system-x86-64; else echo qemu-system-x86_64; fi),$(or $(shell command -v qemu-system-x86_64),$(warning program qemu-system-x86_64 is required)qemu-system-x86_64))
QEMU_SYSTEM_X86_64_MACHINE = q35
QEMU_CPU_X86_64 ?= max
QEMU_SMP_X86_64 = 1
QEMU_DEFAULT_NET_OPTION_X86_64 ?= \
	-netdev user,id=netdev0$(QEMU_DEFAULT_NETDEV_SYS_EXTRA)$${QEMU_NETDEV_USER_EXTRA:-} \
	-device virtio-net-pci,netdev=netdev0,id=net0 \
	-smbios type=41,designation=Virtual-LAN,instance=1,kind=ethernet,pcidev=net0
# Full command line for running QEMU with a given EFI firmware.
QEMU_SYSTEM_X86_64_EFI_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_X86_64) \
	-cpu $(QEMU_CPU_X86_64) \
	-machine $(QEMU_SYSTEM_X86_64_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_X86_64) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_X86_64)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_BOOT_FIRMWARE_OPTION=-drive if=pflash,format=raw,unit=0,file=$(2),readonly=on \
		-drive if=pflash,format=raw,unit=1,file=$(3)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_X86_64)}
# Full command line for running QEMU with legacy BIOS.
QEMU_SYSTEM_X86_64_BIOS_CMDLINE = \
	$(QEMU_ENV_QUIRKS) \
	exec $(QEMU_SYSTEM_X86_64) \
	-cpu $(QEMU_CPU_X86_64) \
	-machine $(QEMU_SYSTEM_X86_64_MACHINE)$${QEMU_ACCEL_MACHINE_PROP=,accel=`$(QEMU_SYSTEM_X86_64) -accel help | tail -n +2 | sort | paste -sd :`} \
	$${QEMU_MEM_OPTION=$(QEMU_DEFAULT_MEM_OPTION)} \
	$${QEMU_SMP_OPTION=-smp $(QEMU_SMP_X86_64)} \
	$${QEMU_DISPLAY_OPTION=$(QEMU_DEFAULT_DISPLAY_OPTION)} \
	$${QEMU_STORAGE_OPTION=-drive file=$(1),if=none,format=qcow2,id=drive0,media=disk,cache=writeback,discard=unmap \
		-device virtio-blk,drive=drive0,bootindex=0} \
	$${QEMU_RNG_OPTION=$(QEMU_DEFAULT_RNG_OPTION)} \
	$${QEMU_NET_OPTION=$(QEMU_DEFAULT_NET_OPTION_X86_64)}
# default location on most Debian/Ubuntu systems, Arch and openSUSE
QEMU_EDK2_CODE_X86_64 ?= \
	/usr/share/OVMF/OVMF_CODE.fd \
	/usr/share/OVMF/OVMF_CODE_4M.fd \
	/usr/share/ovmf/x64/OVMF_CODE.4m.fd \
	/usr/share/qemu/ovmf-x86_64-4m-code.bin
QEMU_EDK2_VARS_X86_64 ?= \
	/usr/share/OVMF/OVMF_VARS.fd \
	/usr/share/OVMF/OVMF_VARS_4M.fd \
	/usr/share/ovmf/x64/OVMF_VARS.4m.fd \
	/usr/share/qemu/ovmf-x86_64-4m-vars.bin

ifneq (,$(value SNAP))
QEMU_EDK2_CODE_X86_64 += $(SNAP)/components/qemu-x86-64/share/qemu/edk2-x86_64-code.fd
QEMU_EDK2_VARS_X86_64 += $(SNAP)/components/qemu-x86-64/share/qemu/edk2-i386-vars.fd
endif

ifneq (,$(value GARDEN_X86_64_PREFIX))
QEMU_EDK2_CODE_X86_64 += $(GARDEN_X86_64_PREFIX)/share/qemu/edk2-x86_64-code.fd
QEMU_EDK2_VARS_X86_64 += $(GARDEN_X86_64_PREFIX)/share/qemu/edk2-i386-vars.fd
endif

efi-code.x86_64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_CODE_X86_64))),$(warning please install x86_64 edk2 firmware - not in $(QEMU_EDK2_CODE_X86_64)))
	cp --preserve=timestamps $< $@

efi-vars.x86_64.img: $(or $(firstword $(wildcard $(QEMU_EDK2_VARS_X86_64))),$(warning please install x86_64 edk2 firmware - not in $(QEMU_EDK2_VARS_X86_64)))
	cp --preserve=timestamps $< $@

# UEFI firmware code and state.
%.x86_64.efi-code.img: | efi-code.x86_64.img
	ln -sf $(firstword $|) $@

%.x86_64.efi-vars.img: efi-vars.x86_64.img
	cp --preserve=timestamps $< $@

.PHONY: clean
clean::
	rm -f efi-code.x86_64.img efi-vars.x86_64.img
	rm -f *.x86_64.qcow2 *.x86_64.efi-code.img *.x86_64.efi-vars.img
