%feature("docstring") OT::Secant
"Secant algorithm solver for 1D non linear equations.

Parameters
----------
absError : positive float, optional
    Absolute error: distance between two successive iterates at the end point.
    Default is :math:`10^{-5}`.
relError : positive float, optional
    Relative error: distance between the two last successive iterates with
    regards to the last iterate. Default is :math:`10^{-5}`.
resError : positive float, optional
    Residual error: difference between the last iterate value and the expected
    value. Default is :math:`10^{-8}`.
maximumFunctionEvaluation : int, optional
    The maximum number of evaluations of the function. Default is :math:`100`.

See also
--------
Solver, Bisection, Brent

Notes
-----
The Secant solver is based on the evaluation of a segment between the two last
iterated points. Secant might fail and not converge."
