# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class OperationDisplay(Model):
    """Operation Display.

    The object that describes the operation.

    :param provider: Resource Provider Name. Friendly name of the resource
     provider.
    :type provider: str
    :param operation: Operation Type. The type of operation. For example:
     read, write, delete.
    :type operation: str
    :param resource: Resource Type. The resource type on which the operation
     is performed.
    :type resource: str
    :param description: Operation description. A description of the operation.
    :type description: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.operation = kwargs.get('operation', None)
        self.resource = kwargs.get('resource', None)
        self.description = kwargs.get('description', None)
