# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import List, Optional, Union

from azure.core.exceptions import HttpResponseError
import msrest.serialization

from ._remote_rendering_rest_client_enums import *


class AssetConversion(msrest.serialization.Model):
    """The properties of the conversion.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the conversion supplied when the conversion was created.
    :type id: str
    :param settings: Required. Conversion settings describe the origin of input files and
     destination of output files.
    :type settings: ~azure.mixedreality.remoterendering._generated.models.AssetConversionSettings
    :ivar output: Information about the output of a successful conversion. Only present when the
     status of the conversion is 'Succeeded'.
    :vartype output: ~azure.mixedreality.remoterendering._generated.models.AssetConversionOutput
    :param error: Required. The error object containing details about the conversion failure.
    :type error: ~azure.mixedreality.remoterendering._generated.models.RemoteRenderingError
    :param status: Required. The status of the conversion. Terminal states are 'Cancelled',
     'Failed', and 'Succeeded'. Possible values include: "NotStarted", "Running", "Cancelled",
     "Failed", "Succeeded".
    :type status: str or
     ~azure.mixedreality.remoterendering._generated.models.AssetConversionStatus
    :param created_on: Required. The time when the conversion was created. Date and time in ISO
     8601 format.
    :type created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'required': True},
        'settings': {'required': True},
        'output': {'readonly': True},
        'error': {'required': True},
        'status': {'required': True},
        'created_on': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'settings': {'key': 'settings', 'type': 'AssetConversionSettings'},
        'output': {'key': 'output', 'type': 'AssetConversionOutput'},
        'error': {'key': 'error', 'type': 'RemoteRenderingError'},
        'status': {'key': 'status', 'type': 'str'},
        'created_on': {'key': 'creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        id: str,
        settings: "AssetConversionSettings",
        error: "RemoteRenderingError",
        status: Union[str, "AssetConversionStatus"],
        created_on: datetime.datetime,
        **kwargs
    ):
        super(AssetConversion, self).__init__(**kwargs)
        self.id = id
        self.settings = settings
        self.output = None
        self.error = error
        self.status = status
        self.created_on = created_on


class AssetConversionInputSettings(msrest.serialization.Model):
    """Conversion input settings describe the origin of conversion input.

    All required parameters must be populated in order to send to Azure.

    :param storage_container_uri: Required. The URI of the Azure blob storage container containing
     the input model.
    :type storage_container_uri: str
    :param storage_container_read_list_sas: An Azure blob storage container shared access signature
     giving read and list access to the storage container. Optional. If not provided, the Azure
     Remote Rendering account needs to be linked with the storage account containing the blob
     container. See https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-
     account#link-storage-accounts for details. For security purposes this field will never be
     filled out in responses bodies.
    :type storage_container_read_list_sas: str
    :param blob_prefix: Only Blobs starting with this prefix will be downloaded to perform the
     conversion. Optional. If not provided, all Blobs from the container will be downloaded.
    :type blob_prefix: str
    :param relative_input_asset_path: Required. The relative path starting at blobPrefix (or at the
     container root if blobPrefix is not provided) to the input model. Must point to a file with a
     supported file format ending. See https://docs.microsoft.com/azure/remote-rendering/how-
     tos/conversion/model-conversion for details.
    :type relative_input_asset_path: str
    """

    _validation = {
        'storage_container_uri': {'required': True},
        'relative_input_asset_path': {'required': True},
    }

    _attribute_map = {
        'storage_container_uri': {'key': 'storageContainerUri', 'type': 'str'},
        'storage_container_read_list_sas': {'key': 'storageContainerReadListSas', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'relative_input_asset_path': {'key': 'relativeInputAssetPath', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_container_uri: str,
        relative_input_asset_path: str,
        storage_container_read_list_sas: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        **kwargs
    ):
        super(AssetConversionInputSettings, self).__init__(**kwargs)
        self.storage_container_uri = storage_container_uri
        self.storage_container_read_list_sas = storage_container_read_list_sas
        self.blob_prefix = blob_prefix
        self.relative_input_asset_path = relative_input_asset_path


class AssetConversionOutput(msrest.serialization.Model):
    """Information about the output of a successful conversion. Only present when the status of the conversion is 'Succeeded'.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar asset_uri: URI of the asset generated by the conversion process.
    :vartype asset_uri: str
    """

    _validation = {
        'asset_uri': {'readonly': True},
    }

    _attribute_map = {
        'asset_uri': {'key': 'outputAssetUri', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AssetConversionOutput, self).__init__(**kwargs)
        self.asset_uri = None


class AssetConversionOutputSettings(msrest.serialization.Model):
    """Conversion output settings describe the destination of conversion output.

    All required parameters must be populated in order to send to Azure.

    :param storage_container_uri: Required. The URI of the Azure blob storage container where the
     result of the conversion should be written to.
    :type storage_container_uri: str
    :param storage_container_write_sas: An Azure blob storage container shared access signature
     giving write access to the storage container. Optional. If not provided, the Azure Remote
     Rendering account needs to be linked with the storage account containing the blob container.
     See https://docs.microsoft.com/azure/remote-rendering/how-tos/create-an-account#link-storage-
     accounts for details. For security purposes this field will never be filled out in responses
     bodies.
    :type storage_container_write_sas: str
    :param blob_prefix: A prefix which gets prepended in front of all files produced by the
     conversion process. Will be treated as a virtual folder. Optional. If not provided, output
     files will be stored at the container root.
    :type blob_prefix: str
    :param output_asset_filename: The file name of the output asset. Must end in '.arrAsset'.
     Optional. If not provided, file name will the same name as the input asset, with '.arrAsset'
     extension.
    :type output_asset_filename: str
    """

    _validation = {
        'storage_container_uri': {'required': True},
    }

    _attribute_map = {
        'storage_container_uri': {'key': 'storageContainerUri', 'type': 'str'},
        'storage_container_write_sas': {'key': 'storageContainerWriteSas', 'type': 'str'},
        'blob_prefix': {'key': 'blobPrefix', 'type': 'str'},
        'output_asset_filename': {'key': 'outputAssetFilename', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_container_uri: str,
        storage_container_write_sas: Optional[str] = None,
        blob_prefix: Optional[str] = None,
        output_asset_filename: Optional[str] = None,
        **kwargs
    ):
        super(AssetConversionOutputSettings, self).__init__(**kwargs)
        self.storage_container_uri = storage_container_uri
        self.storage_container_write_sas = storage_container_write_sas
        self.blob_prefix = blob_prefix
        self.output_asset_filename = output_asset_filename


class AssetConversionSettings(msrest.serialization.Model):
    """Conversion settings describe the origin of input files and destination of output files.

    All required parameters must be populated in order to send to Azure.

    :param input_settings: Required. Conversion input settings describe the origin of conversion
     input.
    :type input_settings:
     ~azure.mixedreality.remoterendering._generated.models.AssetConversionInputSettings
    :param output_settings: Required. Conversion output settings describe the destination of
     conversion output.
    :type output_settings:
     ~azure.mixedreality.remoterendering._generated.models.AssetConversionOutputSettings
    """

    _validation = {
        'input_settings': {'required': True},
        'output_settings': {'required': True},
    }

    _attribute_map = {
        'input_settings': {'key': 'inputLocation', 'type': 'AssetConversionInputSettings'},
        'output_settings': {'key': 'outputLocation', 'type': 'AssetConversionOutputSettings'},
    }

    def __init__(
        self,
        *,
        input_settings: "AssetConversionInputSettings",
        output_settings: "AssetConversionOutputSettings",
        **kwargs
    ):
        super(AssetConversionSettings, self).__init__(**kwargs)
        self.input_settings = input_settings
        self.output_settings = output_settings


class ConversionList(msrest.serialization.Model):
    """List of conversions.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param conversions: Required. The list of conversions.
    :type conversions: list[~azure.mixedreality.remoterendering._generated.models.AssetConversion]
    :ivar next_link: If more conversions are available this field will contain a URL where the next
     batch of conversions can be requested. This URL will need the same authentication as all calls
     to the Azure Remote Rendering API.
    :vartype next_link: str
    """

    _validation = {
        'conversions': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'conversions': {'key': 'conversions', 'type': '[AssetConversion]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        conversions: List["AssetConversion"],
        **kwargs
    ):
        super(ConversionList, self).__init__(**kwargs)
        self.conversions = conversions
        self.next_link = None


class CreateAssetConversionSettings(msrest.serialization.Model):
    """Request to start a conversion.

    All required parameters must be populated in order to send to Azure.

    :param settings: Required. Conversion settings describe the origin of input files and
     destination of output files.
    :type settings: ~azure.mixedreality.remoterendering._generated.models.AssetConversionSettings
    """

    _validation = {
        'settings': {'required': True},
    }

    _attribute_map = {
        'settings': {'key': 'settings', 'type': 'AssetConversionSettings'},
    }

    def __init__(
        self,
        *,
        settings: "AssetConversionSettings",
        **kwargs
    ):
        super(CreateAssetConversionSettings, self).__init__(**kwargs)
        self.settings = settings


class CreateRenderingSessionSettings(msrest.serialization.Model):
    """Settings of the session to be created.

    All required parameters must be populated in order to send to Azure.

    :param lease_time_minutes: Required. The time in minutes the session will run after reaching
     the 'Ready' state. It has to be between 0 and 1440.
    :type lease_time_minutes: int
    :param size: Required. The size of the server used for the rendering session. The size impacts
     the number of polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-
     rendering/reference/vm-sizes for details. Possible values include: "Standard", "Premium".
    :type size: str or ~azure.mixedreality.remoterendering._generated.models.RenderingSessionSize
    """

    _validation = {
        'lease_time_minutes': {'required': True},
        'size': {'required': True},
    }

    _attribute_map = {
        'lease_time_minutes': {'key': 'maxLeaseTimeMinutes', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lease_time_minutes: int,
        size: Union[str, "RenderingSessionSize"],
        **kwargs
    ):
        super(CreateRenderingSessionSettings, self).__init__(**kwargs)
        self.lease_time_minutes = lease_time_minutes
        self.size = size


class ErrorResponse(msrest.serialization.Model):
    """The error response containing details of why the request failed.

    All required parameters must be populated in order to send to Azure.

    :param error: Required. The error object containing details of why the request failed.
    :type error: ~azure.mixedreality.remoterendering._generated.models.RemoteRenderingError
    """

    _validation = {
        'error': {'required': True},
    }

    _attribute_map = {
        'error': {'key': 'error', 'type': 'RemoteRenderingError'},
    }

    def __init__(
        self,
        *,
        error: "RemoteRenderingError",
        **kwargs
    ):
        super(ErrorResponse, self).__init__(**kwargs)
        self.error = error


class RemoteRenderingError(msrest.serialization.Model):
    """The error object containing details of why the request failed.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param code: Required. Error code.
    :type code: str
    :param message: Required. A human-readable representation of the error.
    :type message: str
    :ivar details: An array of details about specific errors that led to this reported error.
    :vartype details:
     list[~azure.mixedreality.remoterendering._generated.models.RemoteRenderingError]
    :ivar target: The target of the particular error (e.g., the name of the property in error).
    :vartype target: str
    :ivar inner_error: An object containing more specific information than the current object about
     the error.
    :vartype inner_error:
     ~azure.mixedreality.remoterendering._generated.models.RemoteRenderingError
    """

    _validation = {
        'code': {'required': True},
        'message': {'required': True},
        'details': {'readonly': True},
        'target': {'readonly': True},
        'inner_error': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'details': {'key': 'details', 'type': '[RemoteRenderingError]'},
        'target': {'key': 'target', 'type': 'str'},
        'inner_error': {'key': 'innerError', 'type': 'RemoteRenderingError'},
    }

    def __init__(
        self,
        *,
        code: str,
        message: str,
        **kwargs
    ):
        super(RemoteRenderingError, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.details = None
        self.target = None
        self.inner_error = None


class RenderingSession(msrest.serialization.Model):
    """The properties of a rendering session.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The ID of the session supplied when the session was created.
    :type id: str
    :ivar arr_inspector_port: The TCP port at which the Azure Remote Rendering Inspector tool is
     hosted.
    :vartype arr_inspector_port: int
    :ivar handshake_port: The TCP port used for the handshake when establishing a connection.
    :vartype handshake_port: int
    :ivar elapsed_time_minutes: Amount of time in minutes the session is or was in the 'Ready'
     state. Time is rounded down to a full minute.
    :vartype elapsed_time_minutes: int
    :ivar hostname: The hostname under which the rendering session is reachable.
    :vartype hostname: str
    :ivar lease_time_minutes: The time in minutes the session will run after reaching the 'Ready'
     state.
    :vartype lease_time_minutes: int
    :param size: Required. The size of the server used for the rendering session. The size impacts
     the number of polygons the server can render. Refer to https://docs.microsoft.com/azure/remote-
     rendering/reference/vm-sizes for details. Possible values include: "Standard", "Premium".
    :type size: str or ~azure.mixedreality.remoterendering._generated.models.RenderingSessionSize
    :param status: Required. The status of the rendering session. Terminal states are 'Error',
     'Expired', and 'Stopped'. Possible values include: "Error", "Expired", "Starting", "Ready",
     "Stopped".
    :type status: str or
     ~azure.mixedreality.remoterendering._generated.models.RenderingSessionStatus
    :ivar teraflops: The computational power of the rendering session GPU measured in teraflops.
    :vartype teraflops: float
    :ivar error: The error object containing details about the rendering session startup failure.
    :vartype error: ~azure.mixedreality.remoterendering._generated.models.RemoteRenderingError
    :ivar created_on: The time when the rendering session was created. Date and time in ISO 8601
     format.
    :vartype created_on: ~datetime.datetime
    """

    _validation = {
        'id': {'required': True},
        'arr_inspector_port': {'readonly': True, 'maximum': 65534, 'minimum': 49152},
        'handshake_port': {'readonly': True, 'maximum': 65534, 'minimum': 49152},
        'elapsed_time_minutes': {'readonly': True},
        'hostname': {'readonly': True},
        'lease_time_minutes': {'readonly': True},
        'size': {'required': True},
        'status': {'required': True},
        'teraflops': {'readonly': True},
        'error': {'readonly': True},
        'created_on': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'arr_inspector_port': {'key': 'arrInspectorPort', 'type': 'int'},
        'handshake_port': {'key': 'handshakePort', 'type': 'int'},
        'elapsed_time_minutes': {'key': 'elapsedTimeMinutes', 'type': 'int'},
        'hostname': {'key': 'hostname', 'type': 'str'},
        'lease_time_minutes': {'key': 'maxLeaseTimeMinutes', 'type': 'int'},
        'size': {'key': 'size', 'type': 'str'},
        'status': {'key': 'status', 'type': 'str'},
        'teraflops': {'key': 'teraflops', 'type': 'float'},
        'error': {'key': 'error', 'type': 'RemoteRenderingError'},
        'created_on': {'key': 'creationTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        id: str,
        size: Union[str, "RenderingSessionSize"],
        status: Union[str, "RenderingSessionStatus"],
        **kwargs
    ):
        super(RenderingSession, self).__init__(**kwargs)
        self.id = id
        self.arr_inspector_port = None
        self.handshake_port = None
        self.elapsed_time_minutes = None
        self.hostname = None
        self.lease_time_minutes = None
        self.size = size
        self.status = status
        self.teraflops = None
        self.error = None
        self.created_on = None


class SessionsList(msrest.serialization.Model):
    """The result of a list sessions request.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :param sessions: Required. The list of rendering sessions. Does not include sessions in
     'Stopped' state.
    :type sessions: list[~azure.mixedreality.remoterendering._generated.models.RenderingSession]
    :ivar next_link: If more rendering sessions are available this field will contain a URL where
     the next batch of sessions can be requested. This URL will need the same authentication as all
     calls to the Azure Remote Rendering API.
    :vartype next_link: str
    """

    _validation = {
        'sessions': {'required': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'sessions': {'key': 'sessions', 'type': '[RenderingSession]'},
        'next_link': {'key': '@nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sessions: List["RenderingSession"],
        **kwargs
    ):
        super(SessionsList, self).__init__(**kwargs)
        self.sessions = sessions
        self.next_link = None


class UpdateSessionSettings(msrest.serialization.Model):
    """Settings used to update the session.

    All required parameters must be populated in order to send to Azure.

    :param lease_time_minutes: Required. Update to the time the session will run after it reached
     the 'Ready' state. It has to be larger than the current value of maxLeaseTimeMinutes and less
     than 1440.
    :type lease_time_minutes: int
    """

    _validation = {
        'lease_time_minutes': {'required': True},
    }

    _attribute_map = {
        'lease_time_minutes': {'key': 'maxLeaseTimeMinutes', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        lease_time_minutes: int,
        **kwargs
    ):
        super(UpdateSessionSettings, self).__init__(**kwargs)
        self.lease_time_minutes = lease_time_minutes
