% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cli.R
\name{cli_text}
\alias{cli_text}
\title{CLI text}
\usage{
cli_text(..., .envir = parent.frame())
}
\arguments{
\item{...}{The text to show, in character vectors. They will be
concatenated into a single string. Newlines are \emph{not} preserved.}

\item{.envir}{Environment to evaluate the glue expressions in.}
}
\description{
Write some text to the screen. This function is most appropriate for
longer paragraphs. See \code{\link[=cli_alert]{cli_alert()}} for shorter status messages.
}
\details{
\subsection{Text wrapping}{

Text is wrapped to the console width, see \code{\link[=console_width]{console_width()}}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text(cli:::lorem_ipsum())
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> Lorem ad ipsum veniam esse nisi deserunt duis. Qui incididunt elit              
#> elit mollit sint nulla consectetur aute commodo do elit laboris minim           
#> et. Laboris ipsum mollit voluptate et non do incididunt eiusmod. Anim           
#> consectetur mollit laborum occaecat eiusmod excepteur. Ullamco non              
#> tempor esse anim tempor magna non.                                              
</pre></div>
}}

}

\subsection{New lines}{

A \code{cli_text()} call always appends a newline character to the end.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text("First line.")
cli_text("Second line.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> First line.                                                                     
#> Second line.                                                                    
</pre></div>
}}

}

\subsection{Styling}{

You can use \link[=inline-markup]{inline markup}, as usual.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text("The \{.fn cli_text\} function in the \{.pkg cli\} package.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> The `cli_text()` function in the <span style="color: #268BD2;">cli</span> package.                                   
</pre></div>
}}

}

\subsection{Interpolation}{

String interpolation via glue works as usual. Interpolated vectors
are collapsed.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{pos <- c(5, 14, 25, 26)
cli_text("We have \{length(pos)\} missing measurements: \{pos\}.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> We have 4 missing measurements: 5, 14, 25, and 26.                              
</pre></div>
}}

}

\subsection{Styling and interpolation}{

Use double braces to combine styling and string interpolation.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{fun <- "cli-text"
pkg <- "cli"
cli_text("The \{.fn \{fun\}\} function in the \{.pkg \{pkg\}\} package.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> The `cli-text()` function in the <span style="color: #268BD2;">cli</span> package.                                   
</pre></div>
}}

}

\subsection{Multiple arguments}{

Arguments are concatenated.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{cli_text(c("This ", "will ", "all "), "be ", "one ", "sentence.")
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> This will all be one sentence.                                                  
</pre></div>
}}

}

\subsection{Containers}{

You can use \code{cli_text()} within cli \link{containers}.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{ul <- cli_ul()
cli_li("First item.")
cli_text("Still the \{.emph first\} item")
cli_li("Second item.")
cli_text("Still the \{.emph second\} item")
cli_end(ul)
}\if{html}{\out{</div>}}\if{html}{\out{
<div class="asciicast" style="color: #172431;font-family: 'Fira Code',Monaco,Consolas,Menlo,'Bitstream Vera Sans Mono','Powerline Symbols',monospace;line-height: 1.300000"><pre>
#> • First item.                                                                   
#> Still the <span style="font-style: italic;">first</span> item                                                            
#> • Second item.                                                                  
#> Still the <span style="font-style: italic;">second</span> item                                                           
</pre></div>
}}

}
}
\seealso{
This function supports \link[=inline-markup]{inline markup}.

Other functions supporting inline markup: 
\code{\link{cli_abort}()},
\code{\link{cli_alert}()},
\code{\link{cli_blockquote}()},
\code{\link{cli_bullets}()},
\code{\link{cli_bullets_raw}()},
\code{\link{cli_dl}()},
\code{\link{cli_h1}()},
\code{\link{cli_li}()},
\code{\link{cli_ol}()},
\code{\link{cli_process_start}()},
\code{\link{cli_progress_along}()},
\code{\link{cli_progress_bar}()},
\code{\link{cli_progress_message}()},
\code{\link{cli_progress_output}()},
\code{\link{cli_progress_step}()},
\code{\link{cli_rule}},
\code{\link{cli_status}()},
\code{\link{cli_status_update}()},
\code{\link{cli_ul}()},
\code{\link{format_error}()},
\code{\link{format_inline}()}
}
\concept{functions supporting inline markup}
