% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trace.R
\name{rlib_trace_spec}
\alias{rlib_trace_spec}
\title{Backtrace specification}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\section{Structure}{


An r-lib backtrace is a data frame that contains the following
columns:
\itemize{
\item \code{call}: List of calls. These may carry \code{srcref} objects.
\item \code{visible}: Logical vector. If \code{FALSE}, the corresponding call
will be hidden from simplified backtraces.
\item \code{parent}: Integer vector of parent references (see
\code{\link[=sys.parents]{sys.parents()}}) as row numbers. 0 is global.
\item \code{namespace}: Character vector of namespaces. \code{NA} for global or
no namespace
\item \code{scope}: Character vector of strings taking values \code{"::"},
\code{":::"}, \code{"global"}, or \code{"local"}.
}

A backtrace data frame may contain extra columns. If you add
additional columns, make sure to prefix their names with the name
of your package or organisation to avoid potential conflicts with
future extensions of this spec, e.g. \code{"mypkg_column"}.
}

\section{Operations}{

\itemize{
\item \strong{Length}. The length of the backtrace is the number of rows of
the underlying data.
\item \strong{Concatenation}. Performed by row-binding two backtraces.  The
\code{parent} column of the RHS is shifted by \code{nrow(LHS)} so that the
last call of the LHS takes place of the global frame of the RHS.
\item \strong{Subsetting}. Performed by slicing the backtrace. After the
data frame is sliced, the \code{parent} column is adjusted to the new
row indices. Any \code{parent} value that no longer exists in the
sliced backtrace is set to 0 (the global frame).
}
}

\keyword{internal}
