% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.download_appimage.R
\name{rk.download_appimage}
\alias{rk.download_appimage}
\title{Install or update RKWard AppImage file}
\usage{
rk.download_appimage(
  dir = dirname(Sys.getenv("APPIMAGE")),
  filename = "rkward-master-linux-gcc-x86_64.AppImage",
  download = TRUE,
  overwrite = FALSE,
  url = "https://cdn.kde.org/ci-builds/education/rkward/master/linux",
  pattern = "rkward-master.*linux-gcc-x86_64\\\\.AppImage",
  method = "auto",
  cacheOK = FALSE,
  timeout = max(400, getOption("timeout")),
  ...
)
}
\arguments{
\item{dir}{File path to the target directory.}

\item{filename}{Character string, filename for the downloaded AppImage.}

\item{download}{Logical, whether to actually download the file or only return the full URL to it in a character string.}

\item{overwrite}{Logical, should an existing file be overwritten?}

\item{url}{Base URL to download the AppImage from.}

\item{pattern}{Regular expression to find the AppImage file name in \code{url}.}

\item{method}{See \code{\link[utils:download.file]{download.file}}.}

\item{cacheOK}{See \code{\link[utils:download.file]{download.file}}.}

\item{timeout}{Number of seconds to try finishing the download.}

\item{...}{Additionsl options for \code{\link[utils:download.file]{download.file}}.}
}
\value{
If \code{download = FALSE} returns the direct URL to the AppImage file.
   Otherwise returns the invisible file path to the installed AppImage if all went well,
   or invisible \code{NULL} if something went wrong.
}
\description{
Tries to download the latest AppImage of RKWard to a specified directory and
makes it executable so it can be used for launching RKWard.
}
\details{
This function uses functions of the \code{XiMpLe} package, allthough for technical
reasons that package could not be declared a proper dependency. This means, if
you use this function for the first time with the current R version and hadn't
installed \code{XiMpLe} yet, you will be prompted to install it first. This
behaviour is similar to using an RKWard plugin dialog with a \code{require()}
call to a currently not installed package.
}
\examples{
\dontrun{
# install current AppImage from master branch to ~/bin
rk.download_appimage(dir="~/bin")

# update the AppImage
rk.download_appimage(dir="~/bin", overwrite=TRUE)
}
}
\author{
Meik Michalke \email{rkward-devel@kde.org}
}
\keyword{misc}
\keyword{utilities}
