use experimental:effects;
use test;

effect NoEscape {
	effect Int eff(Int x);

	Int base;
}

handler NoEscapeHandler(Int) for NoEscape {
	Int derived;

	init(Int start) {
		init { derived = start; }
	}

	handle eff(Int x), k {
		base += x;
		k.call(derived);
	}

	Int get() {
		base + derived;
	}
}

// This should work: it is perfectly fine to pass the effect as a parameter.
void noEscapeFn(NoEscape eff) {
	eff.eff(10);
}

test NoEscapeTest {
	// Should not work:
	// NoEscapeHandler x(10);

	var result = handle (h = NoEscapeHandler(10)) {
		// This should not work (h is a value):
		// var x = &h.eff(Int);

		// This should not work (h has no copy ctor):
		// var y = h;

		// This should work:
		noEscapeFn(h);

		var a = h.get;
		var b = h.base;
		var c = h.derived;

		a + b + c;
	};
	check result == 40;
}
