/**
 * @author Attila Kovacs
 * @version IERS Conventions v1.3.0
 *
 *  Earth orientation model data for variations in _x_<sub>p</sub> _y_<sub>p</sub> and
 *  DUT1 due to ocean tides, with periods less than 2 days.
 */

/**
 * Polar migration due to ocean tides, diurnal terms. From IERS Conventions Chapter 8,
 * Tables 8.2a and 8.2b.
 *
 * REFERENCES:
 * <ol>
 * <li>https://iers-conventions.obspm.fr/content/chapter8/icc8.pdf</li>
 * </ol>
 *
 * @since 1.5
 */
static const novas_eop_terms polar_tidal_terms[69] = { //
        //                                         xp               yp
        //                                    sin     cos      sin      cos
        { {   1,  -1,   0,  -2,  -2,  -2 },    0.0,    0.9,   -0.9,   -0.1 }, //
        { {   1,  -2,   0,  -2,   0,  -1 },    0.1,    0.6,   -0.6,    0.1 }, //
        { {   1,  -2,   0,  -2,   0,  -2 },    0.3,    3.4,   -3.4,    0.3 }, //
        { {   1,   0,   0,  -2,  -2,  -1 },    0.1,    0.8,   -0.8,    0.1 }, //
        { {   1,   0,   0,  -2,  -2,  -2 },    0.5,    4.2,   -4.1,    0.5 }, //
        { {   1,  -1,   0,  -2,   0,  -1 },    1.2,    5.0,   -5.0,    1.2 }, //
        { {   1,  -1,   0,  -2,   0,  -2 },    6.2,   26.3,  -26.3,    6.2 }, //
        { {   1,   1,   0,  -2,  -2,  -1 },    0.2,    0.9,   -0.9,    0.2 }, //
        { {   1,   1,   0,  -2,  -2,  -2 },    1.3,    5.0,   -5.0,    1.3 }, //
        { {   1,   0,   0,  -2,   0,   0 },   -0.3,   -0.8,    0.8,   -0.3 }, //
        { {   1,   0,   0,  -2,   0,  -1 },    9.2,   25.1,  -25.1,    9.2 }, //
        { {   1,   0,   0,  -2,   0,  -2 },   48.8,  132.9, -132.9,   48.8 }, //
        { {   1,  -2,   0,   0,   0,   0 },   -0.3,   -0.9,    0.9,   -0.3 }, //
        { {   1,  -1,   0,  -2,   2,  -2 },   -0.4,   -0.9,    0.9,   -0.4 }, //
        { {   1,   1,   0,  -2,   0,  -1 },   -0.3,   -0.6,    0.6,   -0.3 }, //
        { {   1,   1,   0,  -2,   0,  -2 },   -1.6,   -3.5,    3.5,   -1.6 }, //
        { {   1,  -1,   0,   0,   0,   0 },   -4.5,   -9.6,    9.6,   -4.5 }, //
        { {   1,  -1,   0,   0,   0,  -1 },   -0.9,   -1.9,    1.9,   -0.9 }, //
        { {   1,   1,   0,   0,  -2,   0 },   -0.9,   -1.8,    1.8,   -0.9 }, //
        { {   1,   0,  -1,  -2,   2,  -2 },    1.5,    3.0,   -3.0,    1.5 }, //
        { {   1,   0,   0,  -2,   2,  -1 },   -0.3,   -0.6,    0.6,   -0.3 }, //
        { {   1,   0,   0,  -2,   2,  -2 },   26.1,   51.2,  -51.2,   26.1 }, //
        { {   1,   0,   1,  -2,   2,  -2 },   -0.2,   -0.4,    0.4,   -0.2 }, //
        { {   1,   0,  -1,   0,   0,   0 },   -0.6,   -1.2,    1.2,   -0.6 }, //
        { {   1,   0,   0,   0,   0,   1 },    1.5,    3.0,   -3.0,    1.5 }, //
        { {   1,   0,   0,   0,   0,   0 },  -77.5, -151.7,  151.7,  -77.5 }, //
        { {   1,   0,   0,   0,   0,  -1 },  -10.5,  -20.6,   20.6,  -10.5 }, //
        { {   1,   0,   0,   0,   0,  -2 },    0.2,    0.4,   -0.4,    0.2 }, //
        { {   1,   0,   1,   0,   0,   0 },   -0.6,   -1.2,    1.2,   -0.6 }, //
        { {   1,   0,   0,   2,  -2,   2 },   -1.1,   -2.1,    2.1,   -1.1 }, //
        { {   1,   1,   0,   0,   0,   0 },   -3.5,   -7.3,    7.3,   -3.5 }, //
        { {   1,   1,   0,   0,   0,  -1 },   -0.7,   -1.4,    1.4,   -0.7 }, //
        { {   1,   0,   0,   0,   2,   0 },   -0.4,   -1.1,    1.1,   -0.4 }, //
        { {   1,   2,   0,   0,   0,   0 },   -0.2,   -0.5,    0.5,   -0.2 }, //
        { {   1,   0,   0,   2,   0,   2 },   -1.1,   -3.4,    3.4,   -1.1 }, //
        { {   1,   0,   0,   2,   0,   1 },   -0.7,   -2.2,    2.2,   -0.7 }, //
        { {   1,   0,   0,   2,   0,   0 },   -0.1,   -0.5,    0.5,   -0.1 }, //
        { {   1,   1,   0,   2,   0,   2 },    0.0,   -0.6,    0.6,    0.0 }, //
        { {   1,   1,   0,   2,   0,   1 },    0.0,   -0.4,    0.4,    0.0 }, //
        { {   2,  -3,   0,  -2,   0,  -2 },   -0.5,    0.0,    0.6,    0.2 }, //
        { {   2,  -1,   0,  -2,  -2,  -2 },   -1.3,   -0.2,    1.5,    0.7 }, //
        { {   2,  -2,   0,  -2,   0,  -2 },   -6.1,   -1.6,    3.1,    3.4 }, //
        { {   2,   0,   0,  -2,  -2,  -2 },   -7.6,   -2.0,    3.4,    4.2 }, //
        { {   2,   0,   1,  -2,  -2,  -2 },   -0.5,   -0.1,    0.2,    0.3 }, //
        { {   2,  -1,  -1,  -2,   0,  -2 },    0.5,    0.1,   -0.1,   -0.3 }, //
        { {   2,  -1,   0,  -2,   0,  -1 },    2.1,    0.5,   -0.4,   -1.2 }, //
        { {   2,  -1,   0,  -2,   0,  -2 },  -56.9,  -12.9,   11.1,   32.9 }, //
        { {   2,  -1,   1,  -2,   0,  -2 },   -0.5,   -0.1,    0.1,    0.3 }, //
        { {   2,   1,   0,  -2,  -2,  -2 },  -11.0,   -2.4,    1.9,    6.4 }, //
        { {   2,   1,   1,  -2,  -2,  -2 },   -0.5,   -0.1,    0.1,    0.3 }, //
        { {   2,  -2,   0,  -2,   2,  -2 },    1.0,    0.1,   -0.1,   -0.6 }, //
        { {   2,   0,  -1,  -2,   0,  -2 },    1.1,    0.1,   -0.1,   -0.7 }, //
        { {   2,   0,   0,  -2,   0,  -1 },   12.3,    1.0,   -1.4,   -7.3 }, //
        { {   2,   0,   0,  -2,   0,  -2 }, -330.2,  -27.0,   37.6,  195.9 }, //
        { {   2,   0,   1,  -2,   0,  -2 },   -1.0,   -0.1,    0.1,    0.6 }, //
        { {   2,  -1,   0,  -2,   2,  -2 },    2.5,   -0.3,   -0.4,   -1.5 }, //
        { {   2,   1,   0,  -2,   0,  -2 },    9.4,   -1.4,   -1.9,   -5.6 }, //
        { {   2,  -1,   0,   0,   0,   0 },   -2.4,    0.4,    0.5,    1.4 }, //
        { {   2,  -1,   0,   0,   0,  -1 },   -1.0,    0.2,    0.2,    0.6 }, //
        { {   2,   0,  -1,  -2,   2,  -2 },   -8.5,    3.5,    3.3,    5.1 }, //
        { {   2,   0,   0,  -2,   2,  -2 }, -144.1,   63.6,   59.2,   86.6 }, //
        { {   2,   0,   1,  -2,   2,  -2 },    1.2,   -0.6,   -0.5,   -0.7 }, //
        { {   2,   0,   0,   0,   0,   1 },    0.5,   -0.2,   -0.2,   -0.3 }, //
        { {   2,   0,   0,   0,   0,   0 },  -38.5,   19.1,   17.7,   23.1 }, //
        { {   2,   0,   0,   0,   0,  -1 },  -11.4,    5.8,    5.3,    6.9 }, //
        { {   2,   0,   0,   0,   0,  -2 },   -1.2,    0.6,    0.6,    0.7 }, //
        { {   2,   1,   0,   0,   0,   0 },   -1.8,    1.8,    1.7,    1.0 }, //
        { {   2,   1,   0,   0,   0,  -1 },   -0.8,    0.8,    0.8,    0.5 }, //
        { {   2,   0,   0,   2,   0,   2 },   -0.3,    0.6,    0.7,    0.2 }  //
};

/**
 * UT1 variations due to ocean tides, diurnal terms. From IERS Conventions Chapter 8,
 * Tables 8.3a and 8.3b.
 *
 * REFERENCES:
 * <ol>
 * <li>https://iers-conventions.obspm.fr/content/chapter8/icc8.pdf</li>
 * </ol>
 *
 * @since 1.5
 */
static const novas_eop_terms dut1_tidal_terms[69] = { //
        //                                         UT1             LOD
        //                                    sin     cos      sin     cos
        { {   1,  -1,   0,  -2,  -2,  -2 },   0.40,  -0.08,  -0.40,  -2.10 }, //
        { {   1,  -2,   0,  -2,   0,  -1 },   0.19,  -0.06,  -0.30,  -1.10 }, //
        { {   1,  -2,   0,  -2,   0,  -2 },   1.03,  -0.31,  -1.70,  -5.60 }, //
        { {   1,   0,   0,  -2,  -2,  -1 },   0.22,  -0.07,  -0.40,  -1.20 }, //
        { {   1,   0,   0,  -2,  -2,  -2 },   1.19,  -0.39,  -2.10,  -6.40 }, //
        { {   1,  -1,   0,  -2,   0,  -1 },   0.97,  -0.47,  -2.70,  -5.40 }, //
        { {   1,  -1,   0,  -2,   0,  -2 },   5.12,  -2.50, -14.00, -28.70 }, //
        { {   1,   1,   0,  -2,  -2,  -1 },   0.17,  -0.09,  -0.50,  -1.00 }, //
        { {   1,   1,   0,  -2,  -2,  -2 },   0.91,  -0.47,  -2.70,  -5.10 }, //
        { {   1,   0,   0,  -2,   0,   0 },  -0.09,   0.07,   0.40,   0.50 }, //
        { {   1,   0,   0,  -2,   0,  -1 },   3.03,  -2.28, -13.30, -17.70 }, //
        { {   1,   0,   0,  -2,   0,  -2 },  16.02, -12.07, -70.50, -93.60 }, //
        { {   1,  -2,   0,   0,   0,   0 },  -0.10,   0.08,   0.50,   0.60 }, //
        { {   1,  -1,   0,  -2,   2,  -2 },  -0.08,   0.07,   0.50,   0.50 }, //
        { {   1,   1,   0,  -2,   0,  -1 },  -0.06,   0.05,   0.30,   0.40 }, //
        { {   1,   1,   0,  -2,   0,  -2 },  -0.31,   0.27,   1.70,   1.90 }, //
        { {   1,  -1,   0,   0,   0,   0 },  -0.86,   0.75,   4.60,   5.20 }, //
        { {   1,  -1,   0,   0,   0,  -1 },  -0.17,   0.15,   0.90,   1.00 }, //
        { {   1,   1,   0,   0,  -2,   0 },  -0.16,   0.14,   0.80,   1.00 }, //
        { {   1,   0,  -1,  -2,   2,  -2 },   0.31,  -0.19,  -1.20,  -2.00 }, //
        { {   1,   0,   0,  -2,   2,  -1 },  -0.06,   0.03,   0.20,   0.40 }, //
        { {   1,   0,   0,  -2,   2,  -2 },   5.51,  -3.10, -19.40, -34.50 }, //
        { {   1,   0,   1,  -2,   2,  -2 },  -0.05,   0.02,   0.20,   0.30 }, //
        { {   1,   0,  -1,   0,   0,   0 },  -0.13,   0.07,   0.40,   0.80 }, //
        { {   1,   0,   0,   0,   0,   1 },   0.35,  -0.17,  -1.10,  -2.20 }, //
        { {   1,   0,   0,   0,   0,   0 }, -17.62,   8.55,  53.90, 111.00 }, //
        { {   1,   0,   0,   0,   0,  -1 },  -2.39,   1.16,   7.30,  15.10 }, //
        { {   1,   0,   0,   0,   0,  -2 },   0.05,  -0.03,  -0.20,  -0.30 }, //
        { {   1,   0,   1,   0,   0,   0 },  -0.14,   0.06,   0.40,   0.90 }, //
        { {   1,   0,   0,   2,  -2,   2 },  -0.27,   0.11,   0.70,   1.70 }, //
        { {   1,   1,   0,   0,   0,   0 },  -1.61,   0.19,   1.20,  10.50 }, //
        { {   1,   1,   0,   0,   0,  -1 },  -0.32,   0.04,   0.20,   2.10 }, //
        { {   1,   0,   0,   0,   2,   0 },  -0.41,  -0.01,  -0.00,   2.70 }, //
        { {   1,   2,   0,   0,   0,   0 },  -0.21,  -0.01,  -0.00,   1.40 }, //
        { {   1,   0,   0,   2,   0,   2 },  -1.44,  -0.04,  -0.30,   9.70 }, //
        { {   1,   0,   0,   2,   0,   1 },  -0.92,  -0.02,  -0.20,   6.20 }, //
        { {   1,   0,   0,   2,   0,   0 },  -0.19,   0.00,  -0.00,   1.30 }, //
        { {   1,   1,   0,   2,   0,   2 },  -0.40,  -0.02,  -0.20,   2.80 }, //
        { {   1,   1,   0,   2,   0,   1 },  -0.25,  -0.02,  -0.10,   1.80 },  //
        { {   2,  -3,   0,  -2,   0,  -2 },  -0.09,  -0.01,  -0.10,   1.00 }, //
        { {   2,  -1,   0,  -2,  -2,  -2 },  -0.22,  -0.03,  -0.40,   2.60 }, //
        { {   2,  -2,   0,  -2,   0,  -2 },  -0.64,  -0.18,  -2.10,   7.40 }, //
        { {   2,   0,   0,  -2,  -2,  -2 },  -0.74,  -0.22,  -2.60,   8.70 }, //
        { {   2,   0,   1,  -2,  -2,  -2 },  -0.05,  -0.02,  -0.20,   0.60 }, //
        { {   2,  -1,  -1,  -2,   0,  -2 },   0.03,   0.01,   0.20,  -0.40 }, //
        { {   2,  -1,   0,  -2,   0,  -1 },   0.14,   0.06,   0.70,  -1.70 }, //
        { {   2,  -1,   0,  -2,   0,  -2 },  -3.79,  -1.56, -18.60,  45.20 }, //
        { {   2,  -1,   1,  -2,   0,  -2 },  -0.03,  -0.01,  -0.20,   0.40 }, //
        { {   2,   1,   0,  -2,  -2,  -2 },  -0.70,  -0.30,  -3.60,   8.30 }, //
        { {   2,   1,   1,  -2,  -2,  -2 },  -0.03,  -0.01,  -0.20,   0.40 }, //
        { {   2,  -2,   0,  -2,   2,  -2 },   0.05,   0.02,   0.30,  -0.60 }, //
        { {   2,   0,  -1,  -2,   0,  -2 },   0.06,   0.03,   0.30,  -0.70 }, //
        { {   2,   0,   0,  -2,   0,  -1 },   0.60,   0.27,   3.20,  -7.30 }, //
        { {   2,   0,   0,  -2,   0,  -2 }, -16.19,  -7.25, -86.80, 196.60 }, //
        { {   2,   0,   1,  -2,   0,  -2 },  -0.05,  -0.02,  -0.30,   0.60 }, //
        { {   2,  -1,   0,  -2,   2,  -2 },   0.11,   0.03,   0.40,  -1.40 }, //
        { {   2,   1,   0,  -2,   0,  -2 },   0.42,   0.12,   1.40,  -5.30 }, //
        { {   2,  -1,   0,   0,   0,   0 },  -0.11,  -0.03,  -0.40,   1.30 }, //
        { {   2,  -1,   0,   0,   0,  -1 },  -0.05,  -0.01,  -0.20,   0.60 }, //
        { {   2,   0,  -1,  -2,   2,  -2 },  -0.44,  -0.02,  -0.20,   5.50 }, //
        { {   2,   0,   0,  -2,   2,  -2 },  -7.55,  -0.16,  -2.00,  94.80 }, //
        { {   2,   0,   1,  -2,   2,  -2 },   0.06,   0.00,   0.00,  -0.80 }, //
        { {   2,   0,   0,   0,   0,   1 },   0.03,   0.00,  -0.00,  -0.30 }, //
        { {   2,   0,   0,   0,   0,   0 },  -2.10,   0.04,   0.50,  26.50 }, //
        { {   2,   0,   0,   0,   0,  -1 },  -0.63,   0.01,   0.20,   7.90 }, //
        { {   2,   0,   0,   0,   0,  -2 },  -0.07,   0.00,   0.00,   0.90 }, //
        { {   2,   1,   0,   0,   0,   0 },  -0.15,   0.04,   0.50,   1.90 }, //
        { {   2,   1,   0,   0,   0,  -1 },  -0.06,   0.02,   0.20,   0.80 }, //
        { {   2,   0,   0,   2,   0,   2 },  -0.05,   0.02,   0.20,   0.60 }  //
};
