# Generated by default/object.tt
package Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType;
  use Moose;
  has BranchName => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType object:

  $service_obj->Method(Att1 => { BranchName => $value, ..., BranchName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::RepositoryHeadSourceCodeType object:

  $result = $service_obj->Method(...);
  $result->Att1->BranchName

=head1 DESCRIPTION

A C<SourceCodeType>
(https://docs.aws.amazon.com/codeguru/latest/reviewer-api/API_SourceCodeType)
that specifies the tip of a branch in an associated repository.

=head1 ATTRIBUTES


=head2 B<REQUIRED> BranchName => Str

The name of the branch in an associated repository. The
C<RepositoryHeadSourceCodeType> specifies the tip of this branch.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

