package xop::tsk::logWriter;
use strict; 
use IO::File;
use threads; 
use threads::shared; 

our $sync_e : shared = 0; 
our $sync_l : shared = 0; 

sub new
{
  my ($class, $logFile, $errorLog ) = @_; 
  my ($ifLog, $ifErrorLog) = (1,1); 
  my ($logHandle, $errorLogHandle); 
  unless(defined($logFile))
  {
    $ifLog = 0; 
  }
  else
  {
    $logHandle = new IO::File("> $logFile");
    unless(defined($logHandle))
    {
      $ifLog = 0;
    }
    
  }
  
  unless(defined($errorLog))
  {
    $ifErrorLog = 0; 
  }
  else
  {
    $errorLogHandle = new IO::File("> $errorLog"); 
    unless(defined($errorLogHandle))
    {
      $ifErrorLog = 0;
    }
  }
  
  my $self = 
  {
    -logFile => $logHandle,
    -errorLog => $errorLogHandle,
    -ifLog => $ifLog,
    -ifErrorLog => $ifErrorLog
  }; 
  
  bless $self, $class; 
  return $self; 
}

sub log
{
  lock ( $sync_l); 
  my ($this, $string) = @_; 
  if($this->{-ifLog} == 1)
  {
    my $handle_t = $this->{-logFile};
    print $handle_t $string, "\n";
  }
  else
  {
    print $string, "\n"; 
  }
}

sub error
{
  lock ($sync_e);
  my ($this, $string) = @_; 
  if($this->{-ifErrorLog} == 1)
  {
    my $handle_t = $this->{-errorLog}; 
    print $handle_t $string, "\n"; 
  }
  else
  {
    print $string, "\n"; 
  }
}

sub dispose
{
  my ($this) = @_; 
  if($this->{-ifLog} == 1)
  {
    $this->{-logFile}->close; 
  }    
  
  if($this->{-ifErrorLog} == 1)
  {
    $this->{-errorLog}->close; 
  }
}

1; 
