/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.lemmatizer;

import java.util.ArrayList;
import java.util.regex.Pattern;
import opennlp.tools.lemmatizer.LemmatizerContextGenerator;

public class DefaultLemmatizerContextGenerator
implements LemmatizerContextGenerator {
    private static final int PREFIX_LENGTH = 5;
    private static final int SUFFIX_LENGTH = 7;
    private static Pattern hasCap = Pattern.compile("[A-Z]");
    private static Pattern hasNum = Pattern.compile("[0-9]");

    protected static String[] getPrefixes(String lex) {
        String[] prefs = new String[5];
        for (int li = 1; li < 5; ++li) {
            prefs[li] = lex.substring(0, Math.min(li + 1, lex.length()));
        }
        return prefs;
    }

    protected static String[] getSuffixes(String lex) {
        String[] suffs = new String[7];
        for (int li = 1; li < 7; ++li) {
            suffs[li] = lex.substring(Math.max(lex.length() - li - 1, 0));
        }
        return suffs;
    }

    public String[] getContext(int index, String[] sequence, String[] priorDecisions, Object[] additionalContext) {
        return this.getContext(index, sequence, (String[])additionalContext[0], priorDecisions);
    }

    @Override
    public String[] getContext(int index, String[] toks, String[] tags, String[] preds) {
        String lex = toks[index];
        String p_1 = index < 1 ? "p_1=bos" : "p_1=" + preds[index - 1];
        String w0 = "w0=" + toks[index];
        String t0 = "t0=" + tags[index];
        ArrayList<String> features = new ArrayList<String>();
        features.add(w0);
        features.add(t0);
        features.add(p_1);
        features.add(p_1 + t0);
        features.add(p_1 + w0);
        String[] suffs = DefaultLemmatizerContextGenerator.getSuffixes(lex);
        for (int i = 0; i < suffs.length; ++i) {
            features.add("suf=" + suffs[i]);
        }
        String[] prefs = DefaultLemmatizerContextGenerator.getPrefixes(lex);
        for (int i = 0; i < prefs.length; ++i) {
            features.add("pre=" + prefs[i]);
        }
        if (lex.indexOf(45) != -1) {
            features.add("h");
        }
        if (hasCap.matcher(lex).find()) {
            features.add("c");
        }
        if (hasNum.matcher(lex).find()) {
            features.add("d");
        }
        return features.toArray(new String[features.size()]);
    }
}

