/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ddf.EscherArrayProperty;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherComplexProperty;
import org.apache.poi.ddf.EscherProperties;
import org.apache.poi.ddf.EscherProperty;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherShapePathProperty;
import org.apache.poi.ddf.EscherSimpleProperty;
import org.apache.poi.util.LittleEndian;

public final class EscherPropertyFactory {
    public List<EscherProperty> createProperties(byte[] data, int offset, short numProperties) {
        ArrayList<EscherProperty> results = new ArrayList<EscherProperty>();
        int pos = offset;
        for (int i = 0; i < numProperties; ++i) {
            EscherProperty ep;
            short propId = LittleEndian.getShort(data, pos);
            int propData = LittleEndian.getInt(data, pos + 2);
            short propNumber = (short)(propId & 0x3FFF);
            boolean isComplex = (propId & Short.MIN_VALUE) != 0;
            byte propertyType = EscherProperties.getPropertyType(propNumber);
            switch (propertyType) {
                case 1: {
                    ep = new EscherBoolProperty(propId, propData);
                    break;
                }
                case 2: {
                    ep = new EscherRGBProperty(propId, propData);
                    break;
                }
                case 3: {
                    ep = new EscherShapePathProperty(propId, propData);
                    break;
                }
                default: {
                    ep = !isComplex ? new EscherSimpleProperty(propId, propData) : (propertyType == 5 ? new EscherArrayProperty(propId, new byte[propData]) : new EscherComplexProperty(propId, new byte[propData]));
                }
            }
            results.add(ep);
            pos += 6;
        }
        for (EscherProperty p : results) {
            if (!(p instanceof EscherComplexProperty)) continue;
            if (p instanceof EscherArrayProperty) {
                pos += ((EscherArrayProperty)p).setArrayData(data, pos);
                continue;
            }
            int leftover = data.length - pos;
            byte[] complexData = ((EscherComplexProperty)p).getComplexData();
            if (leftover < complexData.length) {
                throw new IllegalStateException("Could not read complex escher property, length was " + complexData.length + ", but had only " + leftover + " bytes left");
            }
            System.arraycopy(data, pos, complexData, 0, complexData.length);
            pos += complexData.length;
        }
        return results;
    }
}

