#!/usr/local/bin/perl -sw
#
# $Id: Makefile.PL,v 1.11 1998/08/14 18:28:20 timbo Exp $
#
# You may distribute under the terms of either the GNU General Public
# License or the Artistic License, as specified in the Perl README file.
#
BEGIN { require 5.004 }	# 5.004 is required for Win32
use Config;
use ExtUtils::MakeMaker 5.16, qw(&WriteMakefile $Verbose);
use File::Basename;
use Getopt::Long;

use DBI 1.21;		# must be installed first
use DBI::DBD;
use strict;

my %opts = (
	    NAME	=> 'DBD::Mimer',
	    VERSION_FROM => 'Mimer.pm',
	    clean	=> { FILES=> 'Mimer.xsi dbdmimer.h' },
	    dist	=> {
		#DIST_DEFAULT=> 'clean distcheck disttest ci tardist',
		DIST_DEFAULT=> 'clean distcheck tardist',
		PREOP    => '$(MAKE) -f Makefile.old distdir',
		COMPRESS => 'gzip -v9', SUFFIX => 'gz'
		},
	    OBJECT	=> '$(O_FILES)',
	    );
if ($ExtUtils::MakeMaker::VERSION >= 5.43) {
    $opts{AUTHOR} = 'Upright Database Technology, Tim Bunce and Jeff Urlwin';
    $opts{ABSTRACT} = 'Mimer driver for the DBI module.';
    $opts{PREREQ_PM} = { DBI => 1.21 };
    $opts{CAPI} = 'TRUE' if $Config{archname} =~ /-object\b/i;
}

our $opt_g = 0;
our $opt_o = '';
Getopt::Long::GetOptions("g!" => \$opt_g, "o=s" => \$opt_o) or die "Invalid arguments";

print "Overriding DBD::Mimer compile directive with command line option: $opt_g\n" if $opt_g ;
$opts{OPTIMIZE} = '-g -O0' if $opt_g;


print "\nConfiguring DBD::Mimer ...\n
>>>\tRemember to actually *READ* the README file!
   \tAnd re-read it if you have any problems.\n
";

my $dbi_dir      = dbd_dbi_dir();
my $dbi_arch_dir = dbd_dbi_arch_dir();

open(SQLH, ">dbdmimer.h") || die "Can't open dbdmimer.h: $!\n";
print SQLH "/* Do not edit this file. It is automatically written by Makefile.PL.\n";
print SQLH "   Any changes made here will be lost. \n*/\n\n";
print SQLH "#undef WORD /* from perly.y */\n";

if ($^O eq 'MSWin32') {
    my $extrainc = "";
    $extrainc = ";$Config{incpath}\\mfc" if $Config{cc} eq 'bcc32';
    $opts{SKIP} = ['processPL'];
    $opts{DEFINE}  = "";
    $opts{INC}  = "-I$dbi_arch_dir" . $extrainc;
    $opts{LIBS} = ["ODBC32.LIB"];
    $opts{macro}->{EXTRALIB} = 'ODBC32.LIB';
    print SQLH "#include <windows.h>\n";
    print SQLH "#include <sql.h>\n#include <sqltypes.h>\n#include <sqlext.h>\n";
} else {
    print "Overriding Mimer installation directory with command line option: $opt_o\n" if $opt_o ;
    my $mimerhome = $opt_o || $ENV{MIMER_HOME};

    my @libpaths = ("/lib","/usr/lib","/usr/local/lib","$mimerhome/lib");
    @libpaths = ("mimlib9","mimlib8") if $^O eq 'VMS';

    if ("$mimerhome" eq "") {
	print "MIMER_HOME environment not specified.\n";
	$mimerhome = find_libmimer(@libpaths);
	die "Couldn't find Mimer CLI/ODBC library" if ($mimerhome eq "");
    }

    $mimerhome = VMS::Filespec::unixify($mimerhome) if $^O eq 'VMS';

    # per patches from Teun Burgers
    if (!$mimerhome && $ENV{WINDIR} && $^O eq 'cygwin') {
	my $tmp_mimerhome = $ENV{WINDIR};
	$tmp_mimerhome =~ s/^([A-Za-z]):*$/\/\/$1/;
	$tmp_mimerhome =~ s/\\/\//g;
	$mimerhome = $tmp_mimerhome if (-e "$tmp_mimerhome/odbc.ini")
    }

    die "MIMER_HOME environment variable ($mimerhome) does not refer to a directory.\n" unless -d $mimerhome;
    warn "Using Mimer driver in $mimerhome\n";
    $opts{INC}  = "-I. -I$dbi_arch_dir";

    # cygwin patch
    $opts{INC} .= " -I/usr/include/w32api" if $^O eq 'cygwin';

    my $mimerlib = find_libmimerfile($mimerhome);

    if ($^O eq 'VMS') {
	if ($mimerlib eq "mimodbc8.exe" && $ENV{MIMODBC8} eq "") {
	    print "WARNING!  The logical symbol MIMODBC8 is not defined. It must be defined \n";
	    print "or else DBD::Mimer will not work. Define the symbol using the below command:\n";
	    print "\$ define MIMODBC8 $mimerhome:$mimerlib\n";
	}
	if ($mimerlib eq "mimodbc9.exe" && $ENV{MIMODBC9} eq "") {
	    print "WARNING!  There is an error in your Mimer installation. MIMODBC9 is normally\n";
	    print "set when installing Mimer. MIMODBC9 must be defined or else DBD::Mimer will not\n";
	    print "work. Define the symbol using the below command:\n";
	    print "\$ define MIMODBC9 $mimerhome:$mimerlib\n";
	}
	$opts{LIBS} = $mimerhome.":".$mimerlib;
	$opts{CCFLAGS} .= "/warnings=informational=(outtypelen,ptrmismatch,ptrmismatch1,promotmatchw)" if ($Config{cc} =~ /DECC/);
    } else {
	$opts{LIBS} = "-L$mimerhome/lib -ldl -lmimer -lpthread -lm -lc";
    }

    if ($^O eq 'cygwin') {
	print "\nBuilding for Microsoft under Cygwin\n";
	$opts{LIBS} = "-L/usr/lib/w32api -lodbc32";
        print SQLH "#include <windows.h>\n";
        print SQLH "#include <sql.h>\n";
        print SQLH "#include <sqltypes.h>\n";
        print SQLH "#include <sqlext.h>\n";
        print SQLH "#undef WIN32\n";
        $opts{dynamic_lib} = {OTHERLDFLAGS => "-lodbc32"};
    } else {
	print SQLH qq{#include <sqlext.h>\n};
	print SQLH qq{#include <sql.h>\n};
	print SQLH qq{#include <sqltypes.h>\n};
	print SQLH qq{#define DBD_ODBC_NO_DATASOURCES\n};
    }
}
print SQLH qq{\n};
close(SQLH);

print "\n";

WriteMakefile(%opts);

local($^W)=0;
print qq{
The DBD::Mimer tests will use these values for the database connection:
    DBI_DSN=$ENV{DBI_DSN}		e.g. dbi:Mimer:demo
    DBI_USER=$ENV{DBI_USER}
    DBI_PASS=$ENV{DBI_PASS}
};
print "Warning: not all required environment variables are set.\n"
    unless ($ENV{DBI_DSN} && $ENV{DBI_USER} && $ENV{DBI_PASS});
print "Warning: DBI_DSN ($ENV{DBI_DSN}) doesn't start with 'dbi:Mimer:'\n"
    if ($ENV{DBI_DSN} && $ENV{DBI_DSN} !~ m/^dbi:Mimer:/);
print "\n";


sub MY::postamble {
    return dbd_postamble(@_);
}


sub find_libmimer {
    my $lib;
    foreach my $dir (@_) {
	if ($^O eq 'VMS') {
	    $lib = $dir.":mimer.opt";
	} else {
	    $lib = $dir."/libmimer.so";
	}
	print "Looking for $lib...";
	if (-f $lib) {
	    print "success!\n";
	    return $dir;
	} else {
	    print "failed.\n";
	}
    }
    return ("","");
}

sub find_libmimerfile {
    my ($dir) = @_;

    if ($^O eq 'VMS') {
	return "mimodbc9.exe" if (-f "$dir:mimodbc9.exe");
	return "mimodbc8.exe" if (-f "$dir:mimodbc8.exe");
    } else {
	return "libmimer.so" if (-f "$dir/lib/libmimer.so");
    }
    return "";
}

__END__








