use strict;
use warnings;
use Test::More;

use ok 'Hiredis::Raw::Constants', qw(:all);

is REDIS_ERR,           -1,   'REDIS_ERR';
is REDIS_OK,            0,    'REDIS_OK';
is REDIS_ERR_IO,        1,    'REDIS_ERR_IO';
is REDIS_ERR_EOF,       3,    'REDIS_ERR_EOF';
is REDIS_ERR_PROTOCOL,  4,    'REDIS_ERR_PROTOCOL';
is REDIS_ERR_OTHER,     2,    'REDIS_ERR_OTHER';
is REDIS_BLOCK,         0x1,  'REDIS_BLOCK';
is REDIS_CONNECTED,     0x2,  'REDIS_CONNECTED';
is REDIS_DISCONNECTING, 0x4,  'REDIS_DISCONNECTING';
is REDIS_FREEING,       0x8,  'REDIS_FREEING';
is REDIS_IN_CALLBACK,   0x10, 'REDIS_IN_CALLBACK';
is REDIS_SUBSCRIBED,    0x20, 'REDIS_SUBSCRIBED';
is REDIS_REPLY_STRING,  1,    'REDIS_REPLY_STRING';
is REDIS_REPLY_ARRAY,   2,    'REDIS_REPLY_ARRAY';
is REDIS_REPLY_INTEGER, 3,    'REDIS_REPLY_INTEGER';
is REDIS_REPLY_NIL,     4,    'REDIS_REPLY_NIL';
is REDIS_REPLY_STATUS,  5,    'REDIS_REPLY_STATUS';
is REDIS_REPLY_ERROR,   6,    'REDIS_REPLY_ERROR';

done_testing();
