package
	Schema::Result; # Hide from PAUSE. This is just an example.

use strict;
use warnings;

use base 'DBIx::Class::Core';



# Put useful things here which will be available from any Result:: class
__PACKAGE__->load_components(qw/
	InflateColumn::Serializer
	InflateColumn::DateTime
	InflateColumn::Boolean
/);

__PACKAGE__->true_is( qr/^(t|true|y|yes|on|1)$/i );



sub is_created { shift->{ _created } }


1;

=encoding utf8

=head1 NAME

Schema::Result - Example base class for DBIx::Class result classes

=head1 DESCRIPTION

This module is an example base class for result classes in the shipped example
schema.

It loads common components:

- C<InflateColumn::Serializer>
- C<InflateColumn::DateTime>
- C<InflateColumn::Boolean>

and configures truthy values via C<true_is>.

=head1 METHODS

=head2 is_created

  my $bool = $row->is_created;

Returns a boolean indicating that the row was created by L<D/C> in the current
process (it checks an internal C<_created> flag on the object).

=head1 SEE ALSO

L<DBIx::Class::Core>, L<Schema::ResultSet>, L<D>

=cut
