package SLUB::LZA::Rosetta::TA;
use strict;
use warnings;
use App::Cmd::Setup -app;
use Path::Tiny qw( path );
use YAML qw(LoadFile);
use LWP::UserAgent;
use SOAP::Lite;
use Carp qw( croak );
use feature qw(say);
use Regexp::Optimizer;
use IO::Zlib;
use Text::CSV_PP;
use SLUB::LZA::Rosetta::TA::Crypt;


# VERSION

# ABSTRACT: main module for ta-tool

our %config;
our %cache;
our $cache_path;
our $SALT = pack("H16", "There is no security by obscurity!");
BEGIN {
    my $rx_psep = qr{[/\\]};
    my $rx_abs  = qr{[A-Z]:};
    my $rx_sub  = qr{([[:print:]]+)};
    $ENV{'HOME'} =~ m{^(($rx_abs)?($rx_psep$rx_sub)+)$}m;
    # untaint $homestr
    my $homestr = $1;
    my $home = path($homestr);
    if ($home->is_dir() && !$home->is_rootdir) {
        my $config_path = $home->child('.config')->child('ta-tool.rc');
        our $config_file = $config_path;
        if ($config_path->is_file) {
            %config = YAML::LoadFile($config_path);
            if (defined $config{password}) {
                warn "HINT: The password was stored in config file!";
                $config{decrypted_password} = SLUB::LZA::Rosetta::TA::Crypt::decrypt($config{password});
            }
        }
        $cache_path = $home->child('.cache')->child('ta-tool.cache');
        if ($cache_path->is_file and -s $cache_path < 8192 * 1024) { # if size > 8MB, write new at end, see END{}-block
            %cache = YAML::LoadFile($cache_path);
        }
    }

}

END {
    if ($cache_path->parent->is_dir && !$cache_path->parent->parent->is_rootdir && $cache_path->touch()) {
        YAML::DumpFile($cache_path, %cache)
    } else {
        warn "The $cache_path could not be written, because dir ".$cache_path->parent()." is not writeable";
    }
}

1;
