use Test::More;
use Plack::Middleware::ValidateJSON;
use HTTP::Request::Common qw(GET POST);
use Plack::Test;
use Plack::Builder;
use JSON::MaybeXS;

my $app = sub {
    return [
            '200',
            [ 'Content-type' => 'text/plain' ],
            [ 42 ],
    ];
};

my $main_app = builder {
    enable "Plack::Middleware::ValidateJSON";
    mount "/" => builder { $app; };
};

my $test = Plack::Test->create($main_app);
my $url = 'https://www.example.com/';
my $header = ['Content-Type' => 'application/json'];

my $r = HTTP::Request->new('POST', $url, $header, '{"hello":"world"}');

my $res = $test->request($r); 
is $res->code, 200, 'Valid JSON returns a success response code';

$r = HTTP::Request->new('POST', $url, $header, '{"hello":"world}');

$res = $test->request($r);
is $res->code, 422, 'Invalid JSON returns a 422 response code';

done_testing();
