/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.Stack;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.expr.instruct.DivisibleInstruction;
import net.sf.saxon.expr.instruct.DocumentInstr;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.PromotionOffer;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.expr.sort.IntIterator;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardOutputResolver;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.InscopeNamespaceResolver;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultDocument
extends Instruction
implements DivisibleInstruction,
ValidatingInstruction {
    private Expression href;
    private Expression formatExpression;
    private Expression content;
    private Properties globalProperties;
    private Properties localProperties;
    private String baseURI;
    private int validationAction;
    private SchemaType schemaType;
    private IntHashMap<Expression> serializationAttributes;
    private NamespaceResolver nsResolver;
    private Expression dynamicOutputElement;
    private boolean resolveAgainstStaticBase = false;

    public ResultDocument(Properties globalProperties, Properties localProperties, Expression href, Expression formatExpression, String baseURI, int validationAction, SchemaType schemaType, IntHashMap<Expression> serializationAttributes, NamespaceResolver nsResolver) {
        this.globalProperties = globalProperties;
        this.localProperties = localProperties;
        this.href = href;
        this.formatExpression = formatExpression;
        this.baseURI = baseURI;
        this.validationAction = validationAction | 0x10000;
        this.schemaType = schemaType;
        this.serializationAttributes = serializationAttributes;
        this.nsResolver = nsResolver;
        this.adoptChildExpression(href);
        Iterator<Expression> it = serializationAttributes.valueIterator();
        while (it.hasNext()) {
            this.adoptChildExpression(it.next());
        }
    }

    public void setContentExpression(Expression content) {
        this.content = content;
        this.adoptChildExpression(content);
    }

    @Override
    public Expression getContentExpression() {
        return this.content;
    }

    public void setDynamicOutputElement(Expression exp) {
        this.dynamicOutputElement = exp;
    }

    public void setUseStaticBaseUri(boolean staticBase) {
        this.resolveAgainstStaticBase = staticBase;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        this.content = visitor.simplify(this.content);
        this.href = visitor.simplify(this.href);
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.simplify(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.content = visitor.typeCheck(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.typeCheck(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.typeCheck(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.typeCheck(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        try {
            DocumentInstr.checkContentSequence(visitor.getStaticContext(), this.content, this.validationAction, this.schemaType);
        }
        catch (XPathException err) {
            err.maybeSetLocation(this);
            throw err;
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ExpressionVisitor.ContextItemType contextItemType) throws XPathException {
        this.content = visitor.optimize(this.content, contextItemType);
        this.adoptChildExpression(this.content);
        if (this.href != null) {
            this.href = visitor.optimize(this.href, contextItemType);
            this.adoptChildExpression(this.href);
        }
        if (this.formatExpression != null) {
            this.formatExpression = visitor.optimize(this.formatExpression, contextItemType);
            this.adoptChildExpression(this.formatExpression);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = visitor.optimize(value, contextItemType);
            this.adoptChildExpression(value);
            this.serializationAttributes.put(key, value);
        }
        return this;
    }

    @Override
    public int getIntrinsicDependencies() {
        return 0x1000000;
    }

    @Override
    public Expression copy() {
        ResultDocument r = new ResultDocument(this.globalProperties, this.localProperties, this.href == null ? null : this.href.copy(), this.formatExpression == null ? null : this.formatExpression.copy(), this.baseURI, this.validationAction, this.schemaType, this.serializationAttributes, this.nsResolver);
        r.content = this.content.copy();
        r.dynamicOutputElement = this.dynamicOutputElement == null ? null : this.dynamicOutputElement.copy();
        r.resolveAgainstStaticBase = this.resolveAgainstStaticBase;
        return r;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        this.content = this.doPromotion(this.content, offer);
        if (this.href != null) {
            this.href = this.doPromotion(this.href, offer);
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int key = it.next();
            Expression value = this.serializationAttributes.get(key);
            if (value instanceof Literal) continue;
            value = this.doPromotion(value, offer);
            this.serializationAttributes.put(key, value);
        }
    }

    @Override
    public int getInstructionNameCode() {
        return 192;
    }

    @Override
    public ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public SchemaType getSchemaType() {
        return this.schemaType;
    }

    @Override
    public int getValidationAction() {
        return this.validationAction;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        ArrayList<Expression> list = new ArrayList<Expression>(6);
        list.add(this.content);
        if (this.href != null) {
            list.add(this.href);
        }
        if (this.formatExpression != null) {
            list.add(this.formatExpression);
        }
        Iterator<Expression> it = this.serializationAttributes.valueIterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        if (this.dynamicOutputElement != null) {
            list.add(this.dynamicOutputElement);
        }
        return list.iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (this.content == original) {
            this.content = replacement;
            found = true;
        }
        if (this.href == original) {
            this.href = replacement;
            found = true;
        }
        IntIterator it = this.serializationAttributes.keyIterator();
        while (it.hasNext()) {
            int k = it.next();
            if (this.serializationAttributes.get(k) != original) continue;
            this.serializationAttributes.put(k, replacement);
            found = true;
        }
        if (this.dynamicOutputElement == original) {
            this.dynamicOutputElement = replacement;
            found = true;
        }
        return found;
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        this.process(this.content, context);
        return null;
    }

    public void process(Expression content, XPathContext context) throws XPathException {
        Result result;
        OutputURIResolver resolver;
        Controller controller = context.getController();
        assert (controller != null);
        SequenceReceiver saved = context.getReceiver();
        if (context.isTemporaryOutputState()) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while writing a temporary tree");
            err.setErrorCode("XTDE1480");
            err.setLocator(this);
            throw err;
        }
        OutputURIResolver outputURIResolver = resolver = this.href == null ? null : controller.getOutputURIResolver();
        if (this.href == null) {
            String uri = controller.getBaseOutputURI();
            result = uri != null ? new StreamResult(uri) : controller.getPrincipalResult();
        } else {
            try {
                String base = this.resolveAgainstStaticBase ? this.baseURI : controller.getCookedBaseOutputURI();
                assert (this.href != null);
                String hrefValue = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(context))).toString();
                try {
                    result = resolver == null ? null : resolver.resolve(hrefValue, base);
                }
                catch (TransformerException err) {
                    throw XPathException.makeXPathException(err);
                }
                catch (Exception err) {
                    err.printStackTrace();
                    throw new XPathException("Exception thrown by OutputURIResolver", err);
                }
                if (result == null) {
                    resolver = StandardOutputResolver.getInstance();
                    result = resolver.resolve(hrefValue, base);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        this.checkAcceptableUri(context, result);
        this.traceDestination(context, result);
        SerializerFactory sf = context.getConfiguration().getSerializerFactory();
        Properties computedLocalProps = this.gatherOutputProperties(context);
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            try {
                result = sf.prepareNextStylesheet(controller, nextInChain, this.baseURI, result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, computedLocalProps);
        context.changeOutputDestination(receiver, this.validationAction, this.schemaType);
        SequenceReceiver out = context.getReceiver();
        out.open();
        try {
            out.startDocument(0);
            content.process(context);
            out.endDocument();
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
        out.close();
        context.setReceiver(saved);
        if (resolver != null) {
            try {
                resolver.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    @Override
    public void processLeft(Stack<XPathContext> contextStack, Stack<Object> state) throws XPathException {
        Result result;
        OutputURIResolver resolver;
        XPathContext context = contextStack.peek();
        if (context.isTemporaryOutputState()) {
            XPathException err = new XPathException("Cannot execute xsl:result-document while writing a temporary tree");
            err.setErrorCode("XTDE1480");
            err.setLocator(this);
            throw err;
        }
        Controller controller = context.getController();
        assert (controller != null);
        XPathContextMinor c2 = context.newMinorContext();
        OutputURIResolver outputURIResolver = resolver = this.href == null ? null : controller.getOutputURIResolver();
        if (this.href == null) {
            result = controller.getPrincipalResult();
        } else {
            try {
                String base = this.resolveAgainstStaticBase ? this.baseURI : controller.getCookedBaseOutputURI();
                assert (this.href != null);
                assert (resolver != null);
                String hrefValue = ((Object)EscapeURI.iriToUri(this.href.evaluateAsString(context))).toString();
                try {
                    result = resolver.resolve(hrefValue, base);
                }
                catch (Exception err) {
                    throw new XPathException("Exception thrown by OutputURIResolver", err);
                }
                if (result == null) {
                    resolver = StandardOutputResolver.getInstance();
                    result = resolver.resolve(hrefValue, base);
                }
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        this.checkAcceptableUri(context, result);
        this.traceDestination(context, result);
        SerializerFactory sf = c2.getConfiguration().getSerializerFactory();
        Properties computedLocalProps = this.gatherOutputProperties(context);
        String nextInChain = computedLocalProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            try {
                result = sf.prepareNextStylesheet(controller, nextInChain, this.baseURI, result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
        PipelineConfiguration pipe = controller.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, computedLocalProps);
        c2.changeOutputDestination(receiver, this.validationAction, this.schemaType);
        SequenceReceiver out = c2.getReceiver();
        out.open();
        state.push(out);
        state.push(resolver);
        state.push(result);
        contextStack.push(c2);
    }

    @Override
    public void processRight(Stack<XPathContext> contextStack, Stack<Object> state) throws XPathException {
        XPathContext context = contextStack.pop();
        Result result = (Result)state.pop();
        OutputURIResolver resolver = (OutputURIResolver)state.pop();
        SequenceReceiver out = (SequenceReceiver)state.pop();
        try {
            out.endDocument();
        }
        catch (XPathException err) {
            err.setXPathContext(context);
            err.maybeSetLocation(this);
            throw err;
        }
        out.close();
        if (resolver != null) {
            try {
                resolver.close(result);
            }
            catch (TransformerException e) {
                throw XPathException.makeXPathException(e);
            }
        }
    }

    private void traceDestination(XPathContext context, Result result) {
        Configuration config = context.getConfiguration();
        boolean timing = config.isTiming();
        if (timing) {
            String dest = result.getSystemId();
            if (dest == null) {
                dest = result instanceof StreamResult ? "anonymous output stream" : (result instanceof SAXResult ? "SAX2 ContentHandler" : (result instanceof DOMResult ? "DOM tree" : result.getClass().getName()));
            }
            config.getStandardErrorOutput().println("Writing to " + dest);
        }
    }

    private void checkAcceptableUri(XPathContext context, Result result) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        String uri = result.getSystemId();
        if (uri != null) {
            if (controller.getDocumentPool().find(uri) != null) {
                XPathException err = new XPathException("Cannot write to a URI that has already been read: " + result.getSystemId());
                err.setXPathContext(context);
                err.setLocator(this);
                err.setErrorCode("XTRE1500");
                throw err;
            }
            DocumentURI documentKey = new DocumentURI(uri);
            if (!controller.checkUniqueOutputDestination(documentKey)) {
                XPathException err = new XPathException("Cannot write more than one result document to the same URI: " + result.getSystemId());
                err.setXPathContext(context);
                err.setLocator(this);
                err.setErrorCode("XTDE1490");
                throw err;
            }
            controller.addUnavailableOutputDestination(documentKey);
        }
        controller.setThereHasBeenAnExplicitResultDocument();
    }

    private Properties gatherOutputProperties(XPathContext context) throws XPathException {
        Controller controller = context.getController();
        assert (controller != null);
        Configuration config = context.getConfiguration();
        NamePool namePool = config.getNamePool();
        Properties computedGlobalProps = this.globalProperties;
        if (this.formatExpression != null) {
            String[] parts;
            CharSequence format = this.formatExpression.evaluateAsString(context);
            try {
                parts = config.getNameChecker().getQNameParts(format);
            }
            catch (QNameException e) {
                XPathException err = new XPathException("The requested output format " + Err.wrap(format) + " is not a valid QName");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            String uri = this.nsResolver.getURIForPrefix(parts[0], false);
            if (uri == null) {
                XPathException err = new XPathException("The namespace prefix in the format name " + format + " is undeclared");
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
            StructuredQName qName = new StructuredQName(parts[0], uri, parts[1]);
            computedGlobalProps = this.getExecutable().getOutputProperties(qName);
            if (computedGlobalProps == null) {
                XPathException err = new XPathException("There is no xsl:output format named " + format);
                err.setErrorCode("XTDE1460");
                err.setXPathContext(context);
                throw err;
            }
        }
        Properties computedLocalProps = new Properties(computedGlobalProps);
        for (Object keyo : this.localProperties.keySet()) {
            String key = (String)keyo;
            String[] parts = NamePool.parseClarkName(key);
            try {
                ResultDocument.setSerializationProperty(computedLocalProps, parts[0], parts[1], this.localProperties.getProperty(key), this.nsResolver, true, config);
            }
            catch (XPathException e) {
                e.setErrorCode("XTDE0030");
                e.maybeSetLocation(this);
                throw e;
            }
        }
        if (this.serializationAttributes.size() > 0) {
            IntIterator it = this.serializationAttributes.keyIterator();
            while (it.hasNext()) {
                int key = it.next();
                Expression exp = this.serializationAttributes.get(key);
                String value = ((Object)exp.evaluateAsString(context)).toString();
                String lname = namePool.getLocalName(key);
                String uri = namePool.getURI(key);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, uri, lname, value, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    if ("http://saxon.sf.net/".equals(e.getErrorCodeNamespace()) && "SXWN".equals(e.getErrorCodeLocalPart().substring(0, 4))) {
                        try {
                            controller.getErrorListener().warning(e);
                            continue;
                        }
                        catch (TransformerException e2) {
                            throw XPathException.makeXPathException(e2);
                        }
                    }
                    throw e;
                }
            }
        }
        if (this.dynamicOutputElement != null) {
            Item outputArg = this.dynamicOutputElement.evaluateItem(context);
            if (!(outputArg instanceof NodeInfo) || ((NodeInfo)outputArg).getNodeKind() != 1 || ((NodeInfo)outputArg).getFingerprint() != 183) {
                XPathException err = new XPathException("The third argument of saxon:result-document must be an <xsl:output> element");
                err.setLocator(this);
                err.setXPathContext(context);
                throw err;
            }
            Properties dynamicProperties = new Properties();
            ResultDocument.processXslOutputElement((NodeInfo)outputArg, dynamicProperties, context);
            for (Object o : dynamicProperties.keySet()) {
                String key = (String)o;
                StructuredQName name = StructuredQName.fromClarkName(key);
                String value = dynamicProperties.getProperty(key);
                try {
                    ResultDocument.setSerializationProperty(computedLocalProps, name.getURI(), name.getLocalPart(), value, this.nsResolver, false, config);
                }
                catch (XPathException e) {
                    e.setErrorCode("XTDE0030");
                    e.maybeSetLocation(this);
                    e.maybeSetContext(context);
                    throw e;
                }
            }
        }
        return computedLocalProps;
    }

    public static void setSerializationProperty(Properties details, String uri, String lname, String value, NamespaceResolver nsResolver, boolean prevalidated, Configuration config) throws XPathException {
        NameChecker checker = config.getNameChecker();
        if (uri.length() == 0 || "http://saxon.sf.net/".equals(uri)) {
            if (lname.equals("method")) {
                if (value.equals("xml") || value.equals("html") || value.equals("text") || value.equals("xhtml") || prevalidated || value.startsWith("{")) {
                    details.setProperty("method", value);
                } else {
                    try {
                        String[] parts = checker.getQNameParts(value);
                        String prefix = parts[0];
                        if (prefix.length() == 0) {
                            XPathException err = new XPathException("method must be xml, html, xhtml, or text, or a prefixed name");
                            err.setErrorCode("XTSE1570");
                            err.setIsStaticError(true);
                            throw err;
                        }
                        if (nsResolver != null) {
                            String muri = nsResolver.getURIForPrefix(prefix, false);
                            if (muri == null) {
                                XPathException err = new XPathException("Namespace prefix '" + prefix + "' has not been declared");
                                err.setErrorCode("XTSE1570");
                                err.setIsStaticError(true);
                                throw err;
                            }
                            details.setProperty("method", '{' + muri + '}' + parts[1]);
                        }
                        details.setProperty("method", value);
                    }
                    catch (QNameException e) {
                        XPathException err = new XPathException("Invalid method name. " + e.getMessage());
                        err.setErrorCode("XTSE1570");
                        err.setIsStaticError(true);
                        throw err;
                    }
                }
            } else if (lname.equals("use-character-maps")) {
                String existing = details.getProperty("use-character-maps");
                if (existing == null) {
                    existing = "";
                }
                details.setProperty("use-character-maps", existing + value);
            } else if (lname.equals("cdata-section-elements")) {
                ResultDocument.processListOfElementNames(details, "cdata-section-elements", value, nsResolver, prevalidated, checker);
            } else if (lname.equals("suppress-indentation")) {
                ResultDocument.processListOfElementNames(details, "suppress-indentation", value, nsResolver, prevalidated, checker);
            } else if (lname.equals("double-space")) {
                ResultDocument.processListOfElementNames(details, "{http://saxon.sf.net/}double-space", value, nsResolver, prevalidated, checker);
            } else {
                if (lname.equals("next-in-chain")) {
                    XPathException e = new XPathException("saxon:next-in-chain value cannot be specified dynamically");
                    e.setErrorCodeQName(new StructuredQName("saxon", "http://saxon.sf.net/", "SXWN9004"));
                    throw e;
                }
                if (lname.equals("output-version")) {
                    lname = "version";
                }
                String clarkName = lname;
                if (uri.length() != 0) {
                    clarkName = '{' + uri + '}' + lname;
                }
                if (!prevalidated) {
                    try {
                        SaxonOutputKeys.checkOutputProperty(clarkName, value, config);
                    }
                    catch (XPathException err) {
                        err.maybeSetErrorCode("XTDE0030");
                        throw err;
                    }
                }
                details.setProperty(clarkName, value);
            }
        } else {
            details.setProperty('{' + uri + '}' + lname, value);
        }
    }

    private static void processListOfElementNames(Properties details, String key, String value, NamespaceResolver nsResolver, boolean prevalidated, NameChecker checker) throws XPathException {
        String existing = details.getProperty(key);
        if (existing == null) {
            existing = "";
        }
        String s = SaxonOutputKeys.parseListOfElementNames(value, nsResolver, prevalidated, checker, "XTDE0030");
        details.setProperty(key, existing + s);
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("resultDocument");
        if (this.href != null) {
            out.startSubsidiaryElement("href");
            this.href.explain(out);
            out.endSubsidiaryElement();
        }
        out.startSubsidiaryElement("content");
        this.content.explain(out);
        out.endSubsidiaryElement();
        out.endElement();
    }

    public static void processXslOutputElement(NodeInfo element, Properties props, XPathContext c) throws XPathException {
        NodeInfo att;
        AxisIterator iter = element.iterateAxis((byte)2);
        InscopeNamespaceResolver resolver = new InscopeNamespaceResolver(element);
        while ((att = (NodeInfo)iter.next()) != null) {
            String uri = att.getURI();
            String local = att.getLocalPart();
            String val = Whitespace.trim(att.getStringValueCS());
            ResultDocument.setSerializationProperty(props, uri, local, val, resolver, false, c.getConfiguration());
        }
    }
}

