; NOTE: Assertions have been autogenerated by utils/update_analyze_test_checks.py
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv32 -mattr=+v,+f,+d,+zfh,+zvfh < %s | FileCheck %s --check-prefixes=RV32V
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh < %s | FileCheck %s --check-prefixes=RV64V
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+v,+f,+d,+zfh,+zvfh,+experimental-xrivosvisni < %s | FileCheck %s --check-prefixes=VISNI
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv32 -mattr=+zve64x < %s | FileCheck %s --check-prefixes=RV32ZVE64X
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64 -mattr=+zve64x < %s | FileCheck %s --check-prefixes=RV64ZVE64X
; Check that we don't crash querying costs when vectors are not enabled.
; RUN: opt -passes="print<cost-model>" 2>&1 -disable-output -mtriple=riscv64

define void @insertelement_int(i32 %x) {
; RV32V-LABEL: 'insertelement_int'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64V-LABEL: 'insertelement_int'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; VISNI-LABEL: 'insertelement_int'
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'insertelement_int'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 4 for instruction: %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 35 for instruction: %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'insertelement_int'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 6 for instruction: %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 7 for instruction: %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 11 for instruction: %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 19 for instruction: %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2i1_0 = insertelement <2 x i1> undef, i1 undef, i32 0
  %v4i1_0 = insertelement <4 x i1> undef, i1 undef, i32 0
  %v8i1_0 = insertelement <8 x i1> undef, i1 undef, i32 0
  %v16i1_0 = insertelement <16 x i1> undef, i1 undef, i32 0
  %v32i1_0 = insertelement <32 x i1> undef, i1 undef, i32 0

  %nxv2i1_0 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 0
  %nxv4i1_0 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 0
  %nxv8i1_0 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 0
  %nxv16i1_0 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 0
  %nxv32i1_0 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 0

  %v2i8_0 = insertelement <2 x i8> undef, i8 undef, i32 0
  %v4i8_0 = insertelement <4 x i8> undef, i8 undef, i32 0
  %v8i8_0 = insertelement <8 x i8> undef, i8 undef, i32 0
  %v16i8_0 = insertelement <16 x i8> undef, i8 undef, i32 0
  %v32i8_0 = insertelement <32 x i8> undef, i8 undef, i32 0
  %v64i8_0 = insertelement <64 x i8> undef, i8 undef, i32 0
  %v128i8_0 = insertelement <128 x i8> undef, i8 undef, i32 0

  %nxv2i8_0 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 0
  %nxv4i8_0 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 0
  %nxv8i8_0 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 0
  %nxv16i8_0 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 0
  %nxv32i8_0 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 0
  %nxv64i8_0 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 0
  %nxv128i8_0 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 0

  %v2i16_0 = insertelement <2 x i16> undef, i16 undef, i32 0
  %v4i16_0 = insertelement <4 x i16> undef, i16 undef, i32 0
  %v8i16_0 = insertelement <8 x i16> undef, i16 undef, i32 0
  %v16i16_0 = insertelement <16 x i16> undef, i16 undef, i32 0
  %v32i16_0 = insertelement <32 x i16> undef, i16 undef, i32 0
  %v64i16_0 = insertelement <64 x i16> undef, i16 undef, i32 0

  %nxv2i16_0 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 0
  %nxv4i16_0 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 0
  %nxv8i16_0 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 0
  %nxv16i16_0 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 0
  %nxv32i16_0 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 0
  %nxv64i16_0 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 0

  %v2i32_0 = insertelement <2 x i32> undef, i32 undef, i32 0
  %v4i32_0 = insertelement <4 x i32> undef, i32 undef, i32 0
  %v8i32_0 = insertelement <8 x i32> undef, i32 undef, i32 0
  %v16i32_0 = insertelement <16 x i32> undef, i32 undef, i32 0
  %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0

  %nxv2i32_0 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 0
  %nxv4i32_0 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 0
  %nxv8i32_0 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 0
  %nxv16i32_0 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 0
  %nxv32i32_0 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 0

  %v2i64_0 = insertelement <2 x i64> undef, i64 undef, i32 0
  %v4i64_0 = insertelement <4 x i64> undef, i64 undef, i32 0
  %v8i64_0 = insertelement <8 x i64> undef, i64 undef, i32 0
  %v16i64_0 = insertelement <16 x i64> undef, i64 undef, i32 0

  %nxv2i64_0 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 0
  %nxv4i64_0 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 0
  %nxv8i64_0 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 0
  %nxv16i64_0 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 0

  %v2i1_1 = insertelement <2 x i1> undef, i1 undef, i32 1
  %v4i1_1 = insertelement <4 x i1> undef, i1 undef, i32 1
  %v8i1_1 = insertelement <8 x i1> undef, i1 undef, i32 1
  %v16i1_1 = insertelement <16 x i1> undef, i1 undef, i32 1
  %v32i1_1 = insertelement <32 x i1> undef, i1 undef, i32 1

  %nxv2i1_1 = insertelement <vscale x 2 x i1> undef, i1 undef, i32 1
  %nxv4i1_1 = insertelement <vscale x 4 x i1> undef, i1 undef, i32 1
  %nxv8i1_1 = insertelement <vscale x 8 x i1> undef, i1 undef, i32 1
  %nxv16i1_1 = insertelement <vscale x 16 x i1> undef, i1 undef, i32 1
  %nxv32i1_1 = insertelement <vscale x 32 x i1> undef, i1 undef, i32 1

  %v2i8_1 = insertelement <2 x i8> undef, i8 undef, i32 1
  %v4i8_1 = insertelement <4 x i8> undef, i8 undef, i32 1
  %v8i8_1 = insertelement <8 x i8> undef, i8 undef, i32 1
  %v16i8_1 = insertelement <16 x i8> undef, i8 undef, i32 1
  %v32i8_1 = insertelement <32 x i8> undef, i8 undef, i32 1
  %v64i8_1 = insertelement <64 x i8> undef, i8 undef, i32 1
  %v128i8_1 = insertelement <128 x i8> undef, i8 undef, i32 1

  %nxv2i8_1 = insertelement <vscale x 2 x i8> undef, i8 undef, i32 1
  %nxv4i8_1 = insertelement <vscale x 4 x i8> undef, i8 undef, i32 1
  %nxv8i8_1 = insertelement <vscale x 8 x i8> undef, i8 undef, i32 1
  %nxv16i8_1 = insertelement <vscale x 16 x i8> undef, i8 undef, i32 1
  %nxv32i8_1 = insertelement <vscale x 32 x i8> undef, i8 undef, i32 1
  %nxv64i8_1 = insertelement <vscale x 64 x i8> undef, i8 undef, i32 1
  %nxv128i8_1 = insertelement <vscale x 128 x i8> undef, i8 undef, i32 1

  %v2i16_1 = insertelement <2 x i16> undef, i16 undef, i32 1
  %v4i16_1 = insertelement <4 x i16> undef, i16 undef, i32 1
  %v8i16_1 = insertelement <8 x i16> undef, i16 undef, i32 1
  %v16i16_1 = insertelement <16 x i16> undef, i16 undef, i32 1
  %v32i16_1 = insertelement <32 x i16> undef, i16 undef, i32 1
  %v64i16_1 = insertelement <64 x i16> undef, i16 undef, i32 1

  %nxv2i16_1 = insertelement <vscale x 2 x i16> undef, i16 undef, i32 1
  %nxv4i16_1 = insertelement <vscale x 4 x i16> undef, i16 undef, i32 1
  %nxv8i16_1 = insertelement <vscale x 8 x i16> undef, i16 undef, i32 1
  %nxv16i16_1 = insertelement <vscale x 16 x i16> undef, i16 undef, i32 1
  %nxv32i16_1 = insertelement <vscale x 32 x i16> undef, i16 undef, i32 1
  %nxv64i16_1 = insertelement <vscale x 64 x i16> undef, i16 undef, i32 1

  %v2i32_1 = insertelement <2 x i32> undef, i32 undef, i32 1
  %v4i32_1 = insertelement <4 x i32> undef, i32 undef, i32 1
  %v8i32_1 = insertelement <8 x i32> undef, i32 undef, i32 1
  %v16i32_1 = insertelement <16 x i32> undef, i32 undef, i32 1
  %v32i32_1 = insertelement <32 x i32> undef, i32 undef, i32 1

  %nxv2i32_1 = insertelement <vscale x 2 x i32> undef, i32 undef, i32 1
  %nxv4i32_1 = insertelement <vscale x 4 x i32> undef, i32 undef, i32 1
  %nxv8i32_1 = insertelement <vscale x 8 x i32> undef, i32 undef, i32 1
  %nxv16i32_1 = insertelement <vscale x 16 x i32> undef, i32 undef, i32 1
  %nxv32i32_1 = insertelement <vscale x 32 x i32> undef, i32 undef, i32 1

  %v2i64_1 = insertelement <2 x i64> undef, i64 undef, i32 1
  %v4i64_1 = insertelement <4 x i64> undef, i64 undef, i32 1
  %v8i64_1 = insertelement <8 x i64> undef, i64 undef, i32 1
  %v16i64_1 = insertelement <16 x i64> undef, i64 undef, i32 1

  %nxv2i64_1 = insertelement <vscale x 2 x i64> undef, i64 undef, i32 1
  %nxv4i64_1 = insertelement <vscale x 4 x i64> undef, i64 undef, i32 1
  %nxv8i64_1 = insertelement <vscale x 8 x i64> undef, i64 undef, i32 1
  %nxv16i64_1 = insertelement <vscale x 16 x i64> undef, i64 undef, i32 1

  %v2i1_x = insertelement <2 x i1> undef, i1 undef, i32 %x
  %v4i1_x = insertelement <4 x i1> undef, i1 undef, i32 %x
  %v8i1_x = insertelement <8 x i1> undef, i1 undef, i32 %x
  %v16i1_x = insertelement <16 x i1> undef, i1 undef, i32 %x
  %v32i1_x = insertelement <32 x i1> undef, i1 undef, i32 %x

  %nxv2i1_x = insertelement <vscale x 2 x i1> undef, i1 undef, i32 %x
  %nxv4i1_x = insertelement <vscale x 4 x i1> undef, i1 undef, i32 %x
  %nxv8i1_x = insertelement <vscale x 8 x i1> undef, i1 undef, i32 %x
  %nxv16i1_x = insertelement <vscale x 16 x i1> undef, i1 undef, i32 %x
  %nxv32i1_x = insertelement <vscale x 32 x i1> undef, i1 undef, i32 %x

  %v2i8_x = insertelement <2 x i8> undef, i8 undef, i32 %x
  %v4i8_x = insertelement <4 x i8> undef, i8 undef, i32 %x
  %v8i8_x = insertelement <8 x i8> undef, i8 undef, i32 %x
  %v16i8_x = insertelement <16 x i8> undef, i8 undef, i32 %x
  %v32i8_x = insertelement <32 x i8> undef, i8 undef, i32 %x
  %v64i8_x = insertelement <64 x i8> undef, i8 undef, i32 %x
  %v128i8_x = insertelement <128 x i8> undef, i8 undef, i32 %x

  %nxv2i8_x = insertelement <vscale x 2 x i8> undef, i8 undef, i32 %x
  %nxv4i8_x = insertelement <vscale x 4 x i8> undef, i8 undef, i32 %x
  %nxv8i8_x = insertelement <vscale x 8 x i8> undef, i8 undef, i32 %x
  %nxv16i8_x = insertelement <vscale x 16 x i8> undef, i8 undef, i32 %x
  %nxv32i8_x = insertelement <vscale x 32 x i8> undef, i8 undef, i32 %x
  %nxv64i8_x = insertelement <vscale x 64 x i8> undef, i8 undef, i32 %x
  %nxv128i8_x = insertelement <vscale x 128 x i8> undef, i8 undef, i32 %x

  %v2i16_x = insertelement <2 x i16> undef, i16 undef, i32 %x
  %v4i16_x = insertelement <4 x i16> undef, i16 undef, i32 %x
  %v8i16_x = insertelement <8 x i16> undef, i16 undef, i32 %x
  %v16i16_x = insertelement <16 x i16> undef, i16 undef, i32 %x
  %v32i16_x = insertelement <32 x i16> undef, i16 undef, i32 %x
  %v64i16_x = insertelement <64 x i16> undef, i16 undef, i32 %x

  %nxv2i16_x = insertelement <vscale x 2 x i16> undef, i16 undef, i32 %x
  %nxv4i16_x = insertelement <vscale x 4 x i16> undef, i16 undef, i32 %x
  %nxv8i16_x = insertelement <vscale x 8 x i16> undef, i16 undef, i32 %x
  %nxv16i16_x = insertelement <vscale x 16 x i16> undef, i16 undef, i32 %x
  %nxv32i16_x = insertelement <vscale x 32 x i16> undef, i16 undef, i32 %x
  %nxv64i16_x = insertelement <vscale x 64 x i16> undef, i16 undef, i32 %x

  %v2i32_x = insertelement <2 x i32> undef, i32 undef, i32 %x
  %v4i32_x = insertelement <4 x i32> undef, i32 undef, i32 %x
  %v8i32_x = insertelement <8 x i32> undef, i32 undef, i32 %x
  %v16i32_x = insertelement <16 x i32> undef, i32 undef, i32 %x
  %v32i32_x = insertelement <32 x i32> undef, i32 undef, i32 %x

  %nxv2i32_x = insertelement <vscale x 2 x i32> undef, i32 undef, i32 %x
  %nxv4i32_x = insertelement <vscale x 4 x i32> undef, i32 undef, i32 %x
  %nxv8i32_x = insertelement <vscale x 8 x i32> undef, i32 undef, i32 %x
  %nxv16i32_x = insertelement <vscale x 16 x i32> undef, i32 undef, i32 %x
  %nxv32i32_x = insertelement <vscale x 32 x i32> undef, i32 undef, i32 %x

  %v2i64_x = insertelement <2 x i64> undef, i64 undef, i32 %x
  %v4i64_x = insertelement <4 x i64> undef, i64 undef, i32 %x
  %v8i64_x = insertelement <8 x i64> undef, i64 undef, i32 %x
  %v16i64_x = insertelement <16 x i64> undef, i64 undef, i32 %x

  %nxv2i64_x = insertelement <vscale x 2 x i64> undef, i64 undef, i32 %x
  %nxv4i64_x = insertelement <vscale x 4 x i64> undef, i64 undef, i32 %x
  %nxv8i64_x = insertelement <vscale x 8 x i64> undef, i64 undef, i32 %x
  %nxv16i64_x = insertelement <vscale x 16 x i64> undef, i64 undef, i32 %x

  ret void
}

; Cover high lmul extracts and types which require splitting
define void @insertelement_int_lmul(i32 %x) {
; RV32V-LABEL: 'insertelement_int_lmul'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64V-LABEL: 'insertelement_int_lmul'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; VISNI-LABEL: 'insertelement_int_lmul'
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'insertelement_int_lmul'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'insertelement_int_lmul'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v128i8_31 = insertelement <128 x i8> undef, i8 undef, i32 31
  %v128i8_63 = insertelement <128 x i8> undef, i8 undef, i32 63
  %v128i8_127 = insertelement <128 x i8> undef, i8 undef, i32 127
  %v256i8_127 = insertelement <256 x i8> undef, i8 undef, i32 127
  %v256i8_255 = insertelement <256 x i8> undef, i8 undef, i32 255

  %v32i32_3 = insertelement <32 x i32> undef, i32 undef, i32 3
  %v32i32_7 = insertelement <32 x i32> undef, i32 undef, i32 7
  %v32i32_15 = insertelement <32 x i32> undef, i32 undef, i32 15
  %v32i32_31 = insertelement <32 x i32> undef, i32 undef, i32 31
  %v64i32_63 = insertelement <64 x i32> undef, i32 undef, i32 63


  %v128i8 = insertelement <128 x i8> undef, i8 undef, i32 %x
  %v256i8 = insertelement <256 x i8> undef, i8 undef, i32 %x

  %v32i32 = insertelement <32 x i32> undef, i32 undef, i32 %x
  %v64i32 = insertelement <64 x i32> undef, i32 undef, i32 %x

  ret void
}

define void @insertelement_fp(i32 %x) {
; RV32V-LABEL: 'insertelement_fp'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64V-LABEL: 'insertelement_fp'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; VISNI-LABEL: 'insertelement_fp'
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'insertelement_fp'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 65 for instruction: %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 129 for instruction: %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 65 for instruction: %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 10 for instruction: %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 18 for instruction: %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 34 for instruction: %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 66 for instruction: %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'insertelement_fp'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 65 for instruction: %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 129 for instruction: %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 65 for instruction: %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 5 for instruction: %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 9 for instruction: %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 17 for instruction: %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 33 for instruction: %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Invalid cost for instruction: %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v2f16_0 = insertelement <2 x half> undef, half undef, i32 0
  %v4f16_0 = insertelement <4 x half> undef, half undef, i32 0
  %v8f16_0 = insertelement <8 x half> undef, half undef, i32 0
  %v16f16_0 = insertelement <16 x half> undef, half undef, i32 0
  %v32f16_0 = insertelement <32 x half> undef, half undef, i32 0
  %v64f16_0 = insertelement <64 x half> undef, half undef, i32 0

  %nxv2f16_0 = insertelement <vscale x 2 x half> undef, half undef, i32 0
  %nxv4f16_0 = insertelement <vscale x 4 x half> undef, half undef, i32 0
  %nxv8f16_0 = insertelement <vscale x 8 x half> undef, half undef, i32 0
  %nxv16f16_0 = insertelement <vscale x 16 x half> undef, half undef, i32 0
  %nxv32f16_0 = insertelement <vscale x 32 x half> undef, half undef, i32 0
  %nxv64f16_0 = insertelement <vscale x 64 x half> undef, half undef, i32 0

  %v2f32_0 = insertelement <2 x float> undef, float undef, i32 0
  %v4f32_0 = insertelement <4 x float> undef, float undef, i32 0
  %v8f32_0 = insertelement <8 x float> undef, float undef, i32 0
  %v16f32_0 = insertelement <16 x float> undef, float undef, i32 0
  %v32f32_0 = insertelement <32 x float> undef, float undef, i32 0

  %nxv2f32_0 = insertelement <vscale x 2 x float> undef, float undef, i32 0
  %nxv4f32_0 = insertelement <vscale x 4 x float> undef, float undef, i32 0
  %nxv8f32_0 = insertelement <vscale x 8 x float> undef, float undef, i32 0
  %nxv16f32_0 = insertelement <vscale x 16 x float> undef, float undef, i32 0
  %nxv32f32_0 = insertelement <vscale x 32 x float> undef, float undef, i32 0

  %v2f64_0 = insertelement <2 x double> undef, double undef, i32 0
  %v4f64_0 = insertelement <4 x double> undef, double undef, i32 0
  %v8f64_0 = insertelement <8 x double> undef, double undef, i32 0
  %v16f64_0 = insertelement <16 x double> undef, double undef, i32 0

  %nxv2f64_0 = insertelement <vscale x 2 x double> undef, double undef, i32 0
  %nxv4f64_0 = insertelement <vscale x 4 x double> undef, double undef, i32 0
  %nxv8f64_0 = insertelement <vscale x 8 x double> undef, double undef, i32 0
  %nxv16f64_0 = insertelement <vscale x 16 x double> undef, double undef, i32 0

  %v2f16_1 = insertelement <2 x half> undef, half undef, i32 1
  %v4f16_1 = insertelement <4 x half> undef, half undef, i32 1
  %v8f16_1 = insertelement <8 x half> undef, half undef, i32 1
  %v16f16_1 = insertelement <16 x half> undef, half undef, i32 1
  %v32f16_1 = insertelement <32 x half> undef, half undef, i32 1
  %v64f16_1 = insertelement <64 x half> undef, half undef, i32 1

  %nxv2f16_1 = insertelement <vscale x 2 x half> undef, half undef, i32 1
  %nxv4f16_1 = insertelement <vscale x 4 x half> undef, half undef, i32 1
  %nxv8f16_1 = insertelement <vscale x 8 x half> undef, half undef, i32 1
  %nxv16f16_1 = insertelement <vscale x 16 x half> undef, half undef, i32 1
  %nxv32f16_1 = insertelement <vscale x 32 x half> undef, half undef, i32 1
  %nxv64f16_1 = insertelement <vscale x 64 x half> undef, half undef, i32 1

  %v2f32_1 = insertelement <2 x float> undef, float undef, i32 1
  %v4f32_1 = insertelement <4 x float> undef, float undef, i32 1
  %v8f32_1 = insertelement <8 x float> undef, float undef, i32 1
  %v16f32_1 = insertelement <16 x float> undef, float undef, i32 1
  %v32f32_1 = insertelement <32 x float> undef, float undef, i32 1

  %nxv2f32_1 = insertelement <vscale x 2 x float> undef, float undef, i32 1
  %nxv4f32_1 = insertelement <vscale x 4 x float> undef, float undef, i32 1
  %nxv8f32_1 = insertelement <vscale x 8 x float> undef, float undef, i32 1
  %nxv16f32_1 = insertelement <vscale x 16 x float> undef, float undef, i32 1
  %nxv32f32_1 = insertelement <vscale x 32 x float> undef, float undef, i32 1

  %v2f64_1 = insertelement <2 x double> undef, double undef, i32 1
  %v4f64_1 = insertelement <4 x double> undef, double undef, i32 1
  %v8f64_1 = insertelement <8 x double> undef, double undef, i32 1
  %v16f64_1 = insertelement <16 x double> undef, double undef, i32 1

  %nxv2f64_1 = insertelement <vscale x 2 x double> undef, double undef, i32 1
  %nxv4f64_1 = insertelement <vscale x 4 x double> undef, double undef, i32 1
  %nxv8f64_1 = insertelement <vscale x 8 x double> undef, double undef, i32 1
  %nxv16f64_1 = insertelement <vscale x 16 x double> undef, double undef, i32 1

  %v2f16_x = insertelement <2 x half> undef, half undef, i32 %x
  %v4f16_x = insertelement <4 x half> undef, half undef, i32 %x
  %v8f16_x = insertelement <8 x half> undef, half undef, i32 %x
  %v16f16_x = insertelement <16 x half> undef, half undef, i32 %x
  %v32f16_x = insertelement <32 x half> undef, half undef, i32 %x
  %v64f16_x = insertelement <64 x half> undef, half undef, i32 %x

  %nxv2f16_x = insertelement <vscale x 2 x half> undef, half undef, i32 %x
  %nxv4f16_x = insertelement <vscale x 4 x half> undef, half undef, i32 %x
  %nxv8f16_x = insertelement <vscale x 8 x half> undef, half undef, i32 %x
  %nxv16f16_x = insertelement <vscale x 16 x half> undef, half undef, i32 %x
  %nxv32f16_x = insertelement <vscale x 32 x half> undef, half undef, i32 %x
  %nxv64f16_x = insertelement <vscale x 64 x half> undef, half undef, i32 %x

  %v2f32_x = insertelement <2 x float> undef, float undef, i32 %x
  %v4f32_x = insertelement <4 x float> undef, float undef, i32 %x
  %v8f32_x = insertelement <8 x float> undef, float undef, i32 %x
  %v16f32_x = insertelement <16 x float> undef, float undef, i32 %x
  %v32f32_x = insertelement <32 x float> undef, float undef, i32 %x

  %nxv2f32_x = insertelement <vscale x 2 x float> undef, float undef, i32 %x
  %nxv4f32_x = insertelement <vscale x 4 x float> undef, float undef, i32 %x
  %nxv8f32_x = insertelement <vscale x 8 x float> undef, float undef, i32 %x
  %nxv16f32_x = insertelement <vscale x 16 x float> undef, float undef, i32 %x
  %nxv32f32_x = insertelement <vscale x 32 x float> undef, float undef, i32 %x

  %v2f64_x = insertelement <2 x double> undef, double undef, i32 %x
  %v4f64_x = insertelement <4 x double> undef, double undef, i32 %x
  %v8f64_x = insertelement <8 x double> undef, double undef, i32 %x
  %v16f64_x = insertelement <16 x double> undef, double undef, i32 %x

  %nxv2f64_x = insertelement <vscale x 2 x double> undef, double undef, i32 %x
  %nxv4f64_x = insertelement <vscale x 4 x double> undef, double undef, i32 %x
  %nxv8f64_x = insertelement <vscale x 8 x double> undef, double undef, i32 %x
  %nxv16f64_x = insertelement <vscale x 16 x double> undef, double undef, i32 %x

  ret void
}


define void @insertelement_int_nonpoweroftwo(i32 %x) {
; RV32V-LABEL: 'insertelement_int_nonpoweroftwo'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x
; RV32V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64V-LABEL: 'insertelement_int_nonpoweroftwo'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x
; RV64V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; VISNI-LABEL: 'insertelement_int_nonpoweroftwo'
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x
; VISNI-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'insertelement_int_nonpoweroftwo'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'insertelement_int_nonpoweroftwo'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 3 for instruction: %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v3i8 = insertelement <3 x i8> undef, i8 undef, i32 %x
  %v7i8 = insertelement <7 x i8> undef, i8 undef, i32 %x
  %v15i8 = insertelement <15 x i8> undef, i8 undef, i32 %x

  %v3i32_0 = insertelement <3 x i32> undef, i32 undef, i32 0
  %v3i32 = insertelement <3 x i32> undef, i32 undef, i32 %x
  %v7i32 = insertelement <7 x i32> undef, i32 undef, i32 %x
  %v15i32 = insertelement <15 x i32> undef, i32 undef, i32 %x

  ret void
}

define void @insertelement_vls(i32 %x) vscale_range(2,2) {
; RV32V-LABEL: 'insertelement_vls'
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
; RV32V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
; RV32V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12
; RV32V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64V-LABEL: 'insertelement_vls'
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
; RV64V-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
; RV64V-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12
; RV64V-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; VISNI-LABEL: 'insertelement_vls'
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
; VISNI-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12
; VISNI-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV32ZVE64X-LABEL: 'insertelement_vls'
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12
; RV32ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
; RV64ZVE64X-LABEL: 'insertelement_vls'
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 2 for instruction: %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 1 for instruction: %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12
; RV64ZVE64X-NEXT:  Cost Model: Found an estimated cost of 0 for instruction: ret void
;
  %v32i32_0 = insertelement <32 x i32> undef, i32 undef, i32 0
  %v32i32_4 = insertelement <32 x i32> undef, i32 undef, i32 4
  %v32i32_5 = insertelement <32 x i32> undef, i32 undef, i32 5
  %v32i32_8 = insertelement <32 x i32> undef, i32 undef, i32 8
  %v32i32_9 = insertelement <32 x i32> undef, i32 undef, i32 9
  %v32i32_11 = insertelement <32 x i32> undef, i32 undef, i32 11
  %v32i32_12 = insertelement <32 x i32> undef, i32 undef, i32 12

  ret void
}
