; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=i686-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX512-32
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512fp16 -mattr=+avx512vl -O3 | FileCheck %s --check-prefixes=AVX512-64

define <16 x i16> @test_v16f16_oeq_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_oeq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_oeq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ogt_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ogt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgt_oqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ogt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_oge_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_oge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpge_oqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_oge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_olt_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_olt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmplt_oqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_olt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmplt_oqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ole_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ole_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmple_oqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ole_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmple_oqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_one_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_one_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_oqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_one_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_oqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ord_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ord_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpordph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ord_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpordph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ueq_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ueq_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_uqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ueq_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_uqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ugt_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ugt_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnle_uqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ugt_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_uge_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_uge_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnlt_uqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_uge_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ult_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ult_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnge_uqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ult_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnle_uqph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ule_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ule_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngt_uqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ule_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnlt_uqph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_une_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_une_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneqph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_une_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneqph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_uno_q(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_uno_q:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunordph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_uno_q:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunordph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_oeq_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_oeq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_osph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_oeq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_osph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"oeq",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ogt_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ogt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgtph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ogt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ogt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_oge_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_oge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpgeph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_oge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"oge",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_olt_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_olt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpltph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_olt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpltph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"olt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ole_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ole_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpleph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ole_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpleph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ole",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_one_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_one_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_osph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_one_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_osph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"one",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ord_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ord_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpord_sph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ord_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpord_sph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ord",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ueq_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ueq_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpeq_usph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ueq_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpeq_usph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ueq",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ugt_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ugt_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnleph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ugt_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ugt",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_uge_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_uge_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpnltph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_uge_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"uge",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ult_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ult_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngeph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ult_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnleph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ult",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_ule_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_ule_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpngtph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_ule_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpnltph %ymm2, %ymm3, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"ule",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_une_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_une_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpneq_usph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_une_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpneq_usph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"une",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

define <16 x i16> @test_v16f16_uno_s(<16 x i16> %a, <16 x i16> %b, <16 x half> %f1, <16 x half> %f2) #0 {
; AVX512-32-LABEL: test_v16f16_uno_s:
; AVX512-32:       # %bb.0:
; AVX512-32-NEXT:    pushl %ebp
; AVX512-32-NEXT:    movl %esp, %ebp
; AVX512-32-NEXT:    andl $-32, %esp
; AVX512-32-NEXT:    subl $32, %esp
; AVX512-32-NEXT:    vcmpunord_sph 8(%ebp), %ymm2, %k1
; AVX512-32-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-32-NEXT:    movl %ebp, %esp
; AVX512-32-NEXT:    popl %ebp
; AVX512-32-NEXT:    retl
;
; AVX512-64-LABEL: test_v16f16_uno_s:
; AVX512-64:       # %bb.0:
; AVX512-64-NEXT:    vcmpunord_sph %ymm3, %ymm2, %k1
; AVX512-64-NEXT:    vpblendmw %ymm0, %ymm1, %ymm0 {%k1}
; AVX512-64-NEXT:    retq
  %cond = call <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(
                                               <16 x half> %f1, <16 x half> %f2, metadata !"uno",
                                               metadata !"fpexcept.strict") #0
  %res = select <16 x i1> %cond, <16 x i16> %a, <16 x i16> %b
  ret <16 x i16> %res
}

attributes #0 = { strictfp nounwind }

declare <16 x i1> @llvm.experimental.constrained.fcmp.v16f16(<16 x half>, <16 x half>, metadata, metadata)
declare <16 x i1> @llvm.experimental.constrained.fcmps.v16f16(<16 x half>, <16 x half>, metadata, metadata)
