; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt < %s -passes=slp-vectorizer -S | FileCheck %s

target datalayout = "e-m:e-i8:8:32-i16:16:32-i64:64-i128:128-n32:64-S128"
target triple = "aarch64-unknown-linux-gnu"

define <2 x float> @insertelement-fixed-vector() {
; CHECK-LABEL: @insertelement-fixed-vector(
; CHECK-NEXT:    [[TMP1:%.*]] = call fast <2 x float> @llvm.fabs.v2f32(<2 x float> undef)
; CHECK-NEXT:    ret <2 x float> [[TMP1]]
;
  %f0 = tail call fast float @llvm.fabs.f32(float undef)
  %f1 = tail call fast float @llvm.fabs.f32(float undef)
  %i0 = insertelement <2 x float> undef, float %f0, i32 0
  %i1 = insertelement <2 x float> %i0, float %f1, i32 1
  ret <2 x float> %i1
}

; TODO: llvm.fabs could be optimized in vector form. It's legal to extract
; elements from fixed-length vector and insert into scalable vector.
define <vscale x 2 x float> @insertelement-scalable-vector() {
; CHECK-LABEL: @insertelement-scalable-vector(
; CHECK-NEXT:    [[F0:%.*]] = tail call fast float @llvm.fabs.f32(float undef)
; CHECK-NEXT:    [[F1:%.*]] = tail call fast float @llvm.fabs.f32(float undef)
; CHECK-NEXT:    [[I0:%.*]] = insertelement <vscale x 2 x float> undef, float [[F0]], i32 0
; CHECK-NEXT:    [[I1:%.*]] = insertelement <vscale x 2 x float> [[I0]], float [[F1]], i32 1
; CHECK-NEXT:    ret <vscale x 2 x float> [[I1]]
;
  %f0 = tail call fast float @llvm.fabs.f32(float undef)
  %f1 = tail call fast float @llvm.fabs.f32(float undef)
  %i0 = insertelement <vscale x 2 x float> undef, float %f0, i32 0
  %i1 = insertelement <vscale x 2 x float> %i0, float %f1, i32 1
  ret <vscale x 2 x float> %i1
}

; Function Attrs: nounwind readnone speculatable willreturn
declare float @llvm.fabs.f32(float)


define <4 x float> @insertelement_poison_lanes(ptr %0) {
; CHECK-LABEL: @insertelement_poison_lanes(
; CHECK-NEXT:    [[INS_1:%.*]] = insertelement <4 x float> zeroinitializer, float poison, i64 0
; CHECK-NEXT:    [[INS_2:%.*]] = insertelement <4 x float> [[INS_1]], float 0.000000e+00, i64 0
; CHECK-NEXT:    [[GEP_1:%.*]] = getelementptr double, ptr [[TMP0:%.*]], i64 1
; CHECK-NEXT:    store <2 x double> <double 0.000000e+00, double 1.000000e+00>, ptr [[GEP_1]], align 8
; CHECK-NEXT:    ret <4 x float> [[INS_2]]
;
  %trunc.1 = fptrunc double 0.000000e+00 to float
  %trunc.2 = fptrunc double 1.000000e+00 to float
  %ins.1 = insertelement <4 x float> zeroinitializer, float poison, i64 0
  %ins.2 = insertelement <4 x float> %ins.1, float %trunc.1, i64 0
  %ext.1 = fpext float %trunc.1 to double
  %gep.1  = getelementptr double, ptr %0, i64 1
  store double %ext.1, ptr %gep.1, align 8
  %ext.2 = fpext float %trunc.2 to double
  %gep.2 = getelementptr double, ptr %0, i64 2
  store double %ext.2, ptr %gep.2, align 8
  ret <4 x float> %ins.2
}
