; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc --mtriple=loongarch32 -mattr=-32s,+d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32R
; RUN: llc --mtriple=loongarch32 -mattr=+32s,+d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA32S
; RUN: llc --mtriple=loongarch64 -mattr=+d --verify-machineinstrs < %s | FileCheck %s --check-prefix=LA64

define i32 @relax_b18(i32 signext %a, i32 signext %b) {
; LA32R-LABEL: relax_b18:
; LA32R:       # %bb.0:
; LA32R-NEXT:    beq $a0, $a1, .LBB0_1
; LA32R-NEXT:    b .LBB0_2
; LA32R-NEXT:  .LBB0_1: # %iftrue
; LA32R-NEXT:    ori $a0, $zero, 1
; LA32R-NEXT:    #APP
; LA32R-NEXT:    .space 1048576
; LA32R-NEXT:    #NO_APP
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB0_2: # %iffalse
; LA32R-NEXT:    move $a0, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: relax_b18:
; LA32S:       # %bb.0:
; LA32S-NEXT:    beq $a0, $a1, .LBB0_1
; LA32S-NEXT:    b .LBB0_2
; LA32S-NEXT:  .LBB0_1: # %iftrue
; LA32S-NEXT:    ori $a0, $zero, 1
; LA32S-NEXT:    #APP
; LA32S-NEXT:    .space 1048576
; LA32S-NEXT:    #NO_APP
; LA32S-NEXT:    ret
; LA32S-NEXT:  .LBB0_2: # %iffalse
; LA32S-NEXT:    move $a0, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: relax_b18:
; LA64:       # %bb.0:
; LA64-NEXT:    beq $a0, $a1, .LBB0_1
; LA64-NEXT:    b .LBB0_2
; LA64-NEXT:  .LBB0_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 1048576
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB0_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
  %cond = icmp eq i32 %a, %b
  br i1 %cond, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 1048576", ""()
  ret i32 1

iffalse:
  ret i32 0
}

define i32 @relax_b23(i1 %a) {
; LA32R-LABEL: relax_b23:
; LA32R:       # %bb.0:
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    bne $a0, $zero, .LBB1_1
; LA32R-NEXT:    b .LBB1_2
; LA32R-NEXT:  .LBB1_1: # %iftrue
; LA32R-NEXT:    ori $a0, $zero, 1
; LA32R-NEXT:    #APP
; LA32R-NEXT:    .space 16777216
; LA32R-NEXT:    #NO_APP
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB1_2: # %iffalse
; LA32R-NEXT:    move $a0, $zero
; LA32R-NEXT:    ret
;
; LA32S-LABEL: relax_b23:
; LA32S:       # %bb.0:
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    bnez $a0, .LBB1_1
; LA32S-NEXT:    b .LBB1_2
; LA32S-NEXT:  .LBB1_1: # %iftrue
; LA32S-NEXT:    ori $a0, $zero, 1
; LA32S-NEXT:    #APP
; LA32S-NEXT:    .space 16777216
; LA32S-NEXT:    #NO_APP
; LA32S-NEXT:    ret
; LA32S-NEXT:  .LBB1_2: # %iffalse
; LA32S-NEXT:    move $a0, $zero
; LA32S-NEXT:    ret
;
; LA64-LABEL: relax_b23:
; LA64:       # %bb.0:
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    bnez $a0, .LBB1_1
; LA64-NEXT:    b .LBB1_2
; LA64-NEXT:  .LBB1_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 16777216
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB1_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    ret
  br i1 %a, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 16777216", ""()
  ret i32 1

iffalse:
  ret i32 0
}

define i32 @relax_b28(i1 %a) {
; LA32R-LABEL: relax_b28:
; LA32R:       # %bb.0:
; LA32R-NEXT:    addi.w $sp, $sp, -16
; LA32R-NEXT:    .cfi_def_cfa_offset 16
; LA32R-NEXT:    andi $a0, $a0, 1
; LA32R-NEXT:    bne $a0, $zero, .LBB2_1
; LA32R-NEXT:  # %bb.3:
; LA32R-NEXT:    pcalau12i $a0, %pc_hi20(.LBB2_2)
; LA32R-NEXT:    addi.w $a0, $a0, %pc_lo12(.LBB2_2)
; LA32R-NEXT:    jr $a0
; LA32R-NEXT:  .LBB2_1: # %iftrue
; LA32R-NEXT:    ori $a0, $zero, 1
; LA32R-NEXT:    #APP
; LA32R-NEXT:    .space 536870912
; LA32R-NEXT:    #NO_APP
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
; LA32R-NEXT:  .LBB2_2: # %iffalse
; LA32R-NEXT:    move $a0, $zero
; LA32R-NEXT:    addi.w $sp, $sp, 16
; LA32R-NEXT:    ret
;
; LA32S-LABEL: relax_b28:
; LA32S:       # %bb.0:
; LA32S-NEXT:    addi.w $sp, $sp, -16
; LA32S-NEXT:    .cfi_def_cfa_offset 16
; LA32S-NEXT:    andi $a0, $a0, 1
; LA32S-NEXT:    bnez $a0, .LBB2_1
; LA32S-NEXT:  # %bb.3:
; LA32S-NEXT:    pcalau12i $a0, %pc_hi20(.LBB2_2)
; LA32S-NEXT:    addi.w $a0, $a0, %pc_lo12(.LBB2_2)
; LA32S-NEXT:    jr $a0
; LA32S-NEXT:  .LBB2_1: # %iftrue
; LA32S-NEXT:    ori $a0, $zero, 1
; LA32S-NEXT:    #APP
; LA32S-NEXT:    .space 536870912
; LA32S-NEXT:    #NO_APP
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
; LA32S-NEXT:  .LBB2_2: # %iffalse
; LA32S-NEXT:    move $a0, $zero
; LA32S-NEXT:    addi.w $sp, $sp, 16
; LA32S-NEXT:    ret
;
; LA64-LABEL: relax_b28:
; LA64:       # %bb.0:
; LA64-NEXT:    addi.d $sp, $sp, -16
; LA64-NEXT:    .cfi_def_cfa_offset 16
; LA64-NEXT:    andi $a0, $a0, 1
; LA64-NEXT:    bnez $a0, .LBB2_1
; LA64-NEXT:  # %bb.3:
; LA64-NEXT:    pcalau12i $a0, %pc_hi20(.LBB2_2)
; LA64-NEXT:    addi.d $a0, $a0, %pc_lo12(.LBB2_2)
; LA64-NEXT:    jr $a0
; LA64-NEXT:  .LBB2_1: # %iftrue
; LA64-NEXT:    ori $a0, $zero, 1
; LA64-NEXT:    #APP
; LA64-NEXT:    .space 536870912
; LA64-NEXT:    #NO_APP
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
; LA64-NEXT:  .LBB2_2: # %iffalse
; LA64-NEXT:    move $a0, $zero
; LA64-NEXT:    addi.d $sp, $sp, 16
; LA64-NEXT:    ret
  br i1 %a, label %iftrue, label %iffalse

iftrue:
  call void asm sideeffect ".space 536870912", ""()
  ret i32 1

iffalse:
  ret i32 0
}
