; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-promote-alloca -disable-promote-alloca-to-lds=1 < %s | FileCheck --check-prefix=BASE --check-prefix=DEFAULT %s
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-promote-alloca -disable-promote-alloca-to-lds=1 -amdgpu-promote-alloca-to-vector-max-regs=24 < %s | FileCheck --check-prefix=BASE %s --check-prefix=MAX24
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -passes=amdgpu-promote-alloca -disable-promote-alloca-to-lds=1 -amdgpu-promote-alloca-to-vector-max-regs=32 < %s | FileCheck --check-prefix=BASE %s --check-prefix=MAX32

define amdgpu_kernel void @i32_24_elements(ptr %out) #0 {
; DEFAULT-LABEL: define amdgpu_kernel void @i32_24_elements(
; DEFAULT-SAME: ptr [[OUT:%.*]]) #[[ATTR0:[0-9]+]] {
; DEFAULT-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; DEFAULT-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; DEFAULT-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; DEFAULT-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; DEFAULT-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; DEFAULT-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; DEFAULT-NEXT:    [[ALLOCA:%.*]] = alloca [24 x i32], align 16, addrspace(5)
; DEFAULT-NEXT:    call void @llvm.memset.p5.i32(ptr addrspace(5) [[ALLOCA]], i8 0, i32 96, i1 false)
; DEFAULT-NEXT:    [[GEP_0:%.*]] = getelementptr inbounds [24 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 0
; DEFAULT-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds [24 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 20
; DEFAULT-NEXT:    store i32 42, ptr addrspace(5) [[GEP_0]], align 4
; DEFAULT-NEXT:    store i32 43, ptr addrspace(5) [[GEP_1]], align 4
; DEFAULT-NEXT:    [[GEP:%.*]] = getelementptr inbounds [24 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 [[SEL2]]
; DEFAULT-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(5) [[GEP]], align 4
; DEFAULT-NEXT:    store i32 [[LOAD]], ptr [[OUT]], align 4
; DEFAULT-NEXT:    ret void
;
; MAX24-LABEL: define amdgpu_kernel void @i32_24_elements(
; MAX24-SAME: ptr [[OUT:%.*]]) #[[ATTR0:[0-9]+]] {
; MAX24-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX24-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX24-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX24-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX24-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX24-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX24-NEXT:    [[ALLOCA:%.*]] = freeze <24 x i32> poison
; MAX24-NEXT:    [[TMP1:%.*]] = extractelement <24 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0, i32 0, i32 0>, i32 [[SEL2]]
; MAX24-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; MAX24-NEXT:    ret void
;
; MAX32-LABEL: define amdgpu_kernel void @i32_24_elements(
; MAX32-SAME: ptr [[OUT:%.*]]) #[[ATTR0:[0-9]+]] {
; MAX32-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX32-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX32-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX32-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX32-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX32-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX32-NEXT:    [[ALLOCA:%.*]] = freeze <24 x i32> poison
; MAX32-NEXT:    [[TMP1:%.*]] = extractelement <24 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0, i32 0, i32 0>, i32 [[SEL2]]
; MAX32-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; MAX32-NEXT:    ret void
;
  %x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %y = tail call i32 @llvm.amdgcn.workitem.id.y()
  %c1 = icmp uge i32 %x, 3
  %c2 = icmp uge i32 %y, 3
  %sel1 = select i1 %c1, i32 1, i32 2
  %sel2 = select i1 %c2, i32 0, i32 %sel1
  %alloca = alloca [24 x i32], align 16, addrspace(5)
  call void @llvm.memset.p5.i32(ptr addrspace(5) %alloca, i8 0, i32 96, i1 false)
  %gep.0 = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 0
  %gep.1 = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 20
  store i32 42, ptr addrspace(5) %gep.0
  store i32 43, ptr addrspace(5) %gep.1
  %gep = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 %sel2
  %load = load i32, ptr addrspace(5) %gep
  store i32 %load, ptr %out
  ret void
}

define amdgpu_kernel void @i32_24_elements_attrib(ptr %out) #1 {
; BASE-LABEL: define amdgpu_kernel void @i32_24_elements_attrib(
; BASE-SAME: ptr [[OUT:%.*]]) #[[ATTR1:[0-9]+]] {
; BASE-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; BASE-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; BASE-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; BASE-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; BASE-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; BASE-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; BASE-NEXT:    [[ALLOCA:%.*]] = freeze <24 x i32> poison
; BASE-NEXT:    [[TMP1:%.*]] = extractelement <24 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0, i32 0, i32 0>, i32 [[SEL2]]
; BASE-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; BASE-NEXT:    ret void
;
  %x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %y = tail call i32 @llvm.amdgcn.workitem.id.y()
  %c1 = icmp uge i32 %x, 3
  %c2 = icmp uge i32 %y, 3
  %sel1 = select i1 %c1, i32 1, i32 2
  %sel2 = select i1 %c2, i32 0, i32 %sel1
  %alloca = alloca [24 x i32], align 16, addrspace(5)
  call void @llvm.memset.p5.i32(ptr addrspace(5) %alloca, i8 0, i32 96, i1 false)
  %gep.0 = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 0
  %gep.1 = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 20
  store i32 42, ptr addrspace(5) %gep.0
  store i32 43, ptr addrspace(5) %gep.1
  %gep = getelementptr inbounds [24 x i32], ptr addrspace(5) %alloca, i32 0, i32 %sel2
  %load = load i32, ptr addrspace(5) %gep
  store i32 %load, ptr %out
  ret void
}

define amdgpu_kernel void @i32_32_elements(ptr %out) #0 {
; DEFAULT-LABEL: define amdgpu_kernel void @i32_32_elements(
; DEFAULT-SAME: ptr [[OUT:%.*]]) #[[ATTR0]] {
; DEFAULT-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; DEFAULT-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; DEFAULT-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; DEFAULT-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; DEFAULT-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; DEFAULT-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; DEFAULT-NEXT:    [[ALLOCA:%.*]] = alloca [32 x i32], align 16, addrspace(5)
; DEFAULT-NEXT:    call void @llvm.memset.p5.i32(ptr addrspace(5) [[ALLOCA]], i8 0, i32 128, i1 false)
; DEFAULT-NEXT:    [[GEP_0:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 0
; DEFAULT-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 30
; DEFAULT-NEXT:    store i32 42, ptr addrspace(5) [[GEP_0]], align 4
; DEFAULT-NEXT:    store i32 43, ptr addrspace(5) [[GEP_1]], align 4
; DEFAULT-NEXT:    [[GEP:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 [[SEL2]]
; DEFAULT-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(5) [[GEP]], align 4
; DEFAULT-NEXT:    store i32 [[LOAD]], ptr [[OUT]], align 4
; DEFAULT-NEXT:    ret void
;
; MAX24-LABEL: define amdgpu_kernel void @i32_32_elements(
; MAX24-SAME: ptr [[OUT:%.*]]) #[[ATTR0]] {
; MAX24-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX24-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX24-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX24-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX24-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX24-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX24-NEXT:    [[ALLOCA:%.*]] = alloca [32 x i32], align 16, addrspace(5)
; MAX24-NEXT:    call void @llvm.memset.p5.i32(ptr addrspace(5) [[ALLOCA]], i8 0, i32 128, i1 false)
; MAX24-NEXT:    [[GEP_0:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 0
; MAX24-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 30
; MAX24-NEXT:    store i32 42, ptr addrspace(5) [[GEP_0]], align 4
; MAX24-NEXT:    store i32 43, ptr addrspace(5) [[GEP_1]], align 4
; MAX24-NEXT:    [[GEP:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 [[SEL2]]
; MAX24-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(5) [[GEP]], align 4
; MAX24-NEXT:    store i32 [[LOAD]], ptr [[OUT]], align 4
; MAX24-NEXT:    ret void
;
; MAX32-LABEL: define amdgpu_kernel void @i32_32_elements(
; MAX32-SAME: ptr [[OUT:%.*]]) #[[ATTR0]] {
; MAX32-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX32-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX32-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX32-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX32-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX32-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX32-NEXT:    [[ALLOCA:%.*]] = freeze <32 x i32> poison
; MAX32-NEXT:    [[TMP1:%.*]] = extractelement <32 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0>, i32 [[SEL2]]
; MAX32-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; MAX32-NEXT:    ret void
;
  %x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %y = tail call i32 @llvm.amdgcn.workitem.id.y()
  %c1 = icmp uge i32 %x, 3
  %c2 = icmp uge i32 %y, 3
  %sel1 = select i1 %c1, i32 1, i32 2
  %sel2 = select i1 %c2, i32 0, i32 %sel1
  %alloca = alloca [32 x i32], align 16, addrspace(5)
  call void @llvm.memset.p5.i32(ptr addrspace(5) %alloca, i8 0, i32 128, i1 false)
  %gep.0 = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 0
  %gep.1 = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 30
  store i32 42, ptr addrspace(5) %gep.0
  store i32 43, ptr addrspace(5) %gep.1
  %gep = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 %sel2
  %load = load i32, ptr addrspace(5) %gep
  store i32 %load, ptr %out
  ret void
}

define amdgpu_kernel void @i32_32_elements_attrib(ptr %out) #2 {
; DEFAULT-LABEL: define amdgpu_kernel void @i32_32_elements_attrib(
; DEFAULT-SAME: ptr [[OUT:%.*]]) #[[ATTR2:[0-9]+]] {
; DEFAULT-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; DEFAULT-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; DEFAULT-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; DEFAULT-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; DEFAULT-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; DEFAULT-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; DEFAULT-NEXT:    [[ALLOCA:%.*]] = freeze <32 x i32> poison
; DEFAULT-NEXT:    [[TMP1:%.*]] = extractelement <32 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0>, i32 [[SEL2]]
; DEFAULT-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; DEFAULT-NEXT:    ret void
;
; MAX24-LABEL: define amdgpu_kernel void @i32_32_elements_attrib(
; MAX24-SAME: ptr [[OUT:%.*]]) #[[ATTR2:[0-9]+]] {
; MAX24-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX24-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX24-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX24-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX24-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX24-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX24-NEXT:    [[ALLOCA:%.*]] = alloca [32 x i32], align 16, addrspace(5)
; MAX24-NEXT:    call void @llvm.memset.p5.i32(ptr addrspace(5) [[ALLOCA]], i8 0, i32 128, i1 false)
; MAX24-NEXT:    [[GEP_0:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 0
; MAX24-NEXT:    [[GEP_1:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 30
; MAX24-NEXT:    store i32 42, ptr addrspace(5) [[GEP_0]], align 4
; MAX24-NEXT:    store i32 43, ptr addrspace(5) [[GEP_1]], align 4
; MAX24-NEXT:    [[GEP:%.*]] = getelementptr inbounds [32 x i32], ptr addrspace(5) [[ALLOCA]], i32 0, i32 [[SEL2]]
; MAX24-NEXT:    [[LOAD:%.*]] = load i32, ptr addrspace(5) [[GEP]], align 4
; MAX24-NEXT:    store i32 [[LOAD]], ptr [[OUT]], align 4
; MAX24-NEXT:    ret void
;
; MAX32-LABEL: define amdgpu_kernel void @i32_32_elements_attrib(
; MAX32-SAME: ptr [[OUT:%.*]]) #[[ATTR2:[0-9]+]] {
; MAX32-NEXT:    [[X:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.x()
; MAX32-NEXT:    [[Y:%.*]] = tail call i32 @llvm.amdgcn.workitem.id.y()
; MAX32-NEXT:    [[C1:%.*]] = icmp uge i32 [[X]], 3
; MAX32-NEXT:    [[C2:%.*]] = icmp uge i32 [[Y]], 3
; MAX32-NEXT:    [[SEL1:%.*]] = select i1 [[C1]], i32 1, i32 2
; MAX32-NEXT:    [[SEL2:%.*]] = select i1 [[C2]], i32 0, i32 [[SEL1]]
; MAX32-NEXT:    [[ALLOCA:%.*]] = freeze <32 x i32> poison
; MAX32-NEXT:    [[TMP1:%.*]] = extractelement <32 x i32> <i32 42, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 0, i32 43, i32 0>, i32 [[SEL2]]
; MAX32-NEXT:    store i32 [[TMP1]], ptr [[OUT]], align 4
; MAX32-NEXT:    ret void
;
  %x = tail call i32 @llvm.amdgcn.workitem.id.x()
  %y = tail call i32 @llvm.amdgcn.workitem.id.y()
  %c1 = icmp uge i32 %x, 3
  %c2 = icmp uge i32 %y, 3
  %sel1 = select i1 %c1, i32 1, i32 2
  %sel2 = select i1 %c2, i32 0, i32 %sel1
  %alloca = alloca [32 x i32], align 16, addrspace(5)
  call void @llvm.memset.p5.i32(ptr addrspace(5) %alloca, i8 0, i32 128, i1 false)
  %gep.0 = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 0
  %gep.1 = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 30
  store i32 42, ptr addrspace(5) %gep.0
  store i32 43, ptr addrspace(5) %gep.1
  %gep = getelementptr inbounds [32 x i32], ptr addrspace(5) %alloca, i32 0, i32 %sel2
  %load = load i32, ptr addrspace(5) %gep
  store i32 %load, ptr %out
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
declare i32 @llvm.amdgcn.workitem.id.y()
declare void @llvm.memset.p5.i32(ptr addrspace(5) nocapture writeonly, i8, i32, i1 immarg)

attributes #0 = { nounwind "amdgpu-flat-work-group-size"="64,64" "amdgpu-waves-per-eu"="1,3" }
attributes #1 = { nounwind "amdgpu-flat-work-group-size"="64,64" "amdgpu-waves-per-eu"="1,3" "amdgpu-promote-alloca-to-vector-max-regs"="24" }
attributes #2 = { nounwind "amdgpu-flat-work-group-size"="64,64" "amdgpu-waves-per-eu"="1,3" "amdgpu-promote-alloca-to-vector-max-regs"="32" }
