; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -passes=instcombine -S | FileCheck %s

define i1 @test-same-operands-sub-add-nsw-icmp-sgt(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-same-operands-sub-add-nsw-icmp-sgt(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp slt i8 [[B]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nsw i8 %a, %b
  %cmp = icmp sgt i8 %sub, %add
  ret i1 %cmp
}

define i1 @test-same-operands-sub-add-nsw-icmp-slt(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-same-operands-sub-add-nsw-icmp-slt(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[B]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nsw i8 %a, %b
  %cmp = icmp slt i8 %sub, %add
  ret i1 %cmp
}

define i1 @test-same-operands-sub-add-nsw-icmp-sle(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-same-operands-sub-add-nsw-icmp-sle(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[B]], -1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nsw i8 %a, %b
  %cmp = icmp sle i8 %sub, %add
  ret i1 %cmp
}

define i1 @test-same-operands-sub-add-nsw-nuw-icmp-eq(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-same-operands-sub-add-nsw-nuw-icmp-eq(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[B]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nuw i8 %a, %b
  %cmp = icmp eq i8 %sub, %add
  ret i1 %cmp
}

define i1 @test-same-operands-sub-add-nsw-icmp-eq(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-same-operands-sub-add-nsw-icmp-eq(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i8 [[B]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nsw i8 %a, %b
  %cmp = icmp eq i8 %sub, %add
  ret i1 %cmp
}

define i1 @test-add-sub-nsw-icmp-sgt(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-add-sub-nsw-icmp-sgt(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[CMP:%.*]] = icmp sgt i8 [[B]], 0
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nsw i8 %a, %b
  %add = add nsw i8 %a, %b
  %cmp = icmp sgt i8 %add, %sub
  ret i1 %cmp
}

define i1 @test-add-sub-nuw-icmp-uge(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-add-sub-nuw-icmp-uge(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %sub = sub nuw i8 %a, %b
  %add = add nuw i8 %a, %b
  %cmp = icmp uge i8 %add, %sub
  ret i1 %cmp
}

; Check not folded
define i1 @test-add-sub-nuw-icmp-sge(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-add-sub-nuw-icmp-sge(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    [[SUB:%.*]] = sub nuw i8 [[A]], [[B]]
; CHECK-NEXT:    [[ADD:%.*]] = add nuw i8 [[A]], [[B]]
; CHECK-NEXT:    [[CMP:%.*]] = icmp sge i8 [[ADD]], [[SUB]]
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %sub = sub nuw i8 %a, %b
  %add = add nuw i8 %a, %b
  %cmp = icmp sge i8 %add, %sub
  ret i1 %cmp
}

define i1 @test-add-swap-sub-nuw-icmp-uge(i8 %a, i8 %b) {
; CHECK-LABEL: define i1 @test-add-swap-sub-nuw-icmp-uge(
; CHECK-SAME: i8 [[A:%.*]], i8 [[B:%.*]]) {
; CHECK-NEXT:    ret i1 true
;
  %sub = sub nuw i8 %a, %b
  %add = add nuw i8 %b, %a
  %cmp = icmp uge i8 %add, %sub
  ret i1 %cmp
}
