.\" Project   : tin
.\" Module    : mmdf.5
.\" Author    : U. Janssen
.\" Created   : 2002-02-18
.\" Updated   :
.\" Notes     : needs a lot of work
.\"
.TH mmdf 5 "February 18th, 2002" "Unix" "User Manuals"
.\"
.SH NAME
MMDF \- Multi\-channel Memorandum Distribution Facility mailbox format
.\"
.SH DESCRIPTION
This document describes the
.B MMDF
mailbox format used by some MTAs and MUAs (i.e.
.BR scomail (1))
to store mail messages locally.
.PP
An
.B MMDF
mailbox is a text file containing an arbitrary number of e-mail messages.
Each message consists of a postmark, followed by an e-mail message formatted
according to \fBRFC822\fP / \fBRFC2822\fP, followed by a postmark. The file
format is line-oriented. Lines are separated by line feed characters (ASCII
10). A postmark line consists of the four characters "^A^A^A^A" (Control-A;
ASCII 1).
.TP
Example of a \fBMMDF\fP mailbox holding two mails:
.RS
.nf
.sp
^A^A^A^A
.br
From: example@example.com
.br
To: example@example.org
.br
Subject: test
.br
.sp
.br
>From what I learned about the MMDF-format:
.br
.br
^A^A^A^A
.br
^A^A^A^A
.br
From: example@example.com
.br
To: example@example.org
.br
Subject: test 2
.br
.sp
.br
bar
.br
^A^A^A^A
.fi
.RE
.PP
In contrast to most other single file mailbox formats like
MBOXO and MBOXRD (see
.BR mbox (5))
there is no need to quote/dequote "From "\-lines in
.B MMDF
mailboxes as such lines have no special meaning in this format.
.PP
If the modification-time (usually determined via
.BR stat (2))
of a nonempty mailbox file is greater than the access-time
the file has new mail. Many MUAs place a Status: header in
each message to indicate which messages have already been
read.
.\"
.SH LOCKING
Since
.B MMDF
files are frequently accessed by multiple programs in parallel,
.B MMDF
files should generally not be accessed without locking.
.PP
Three different locking mechanisms (and combinations thereof) are in
general use:
.IP "\(bu"
.BR fcntl (2)
locking is mostly used on recent, POSIX-compliant systems. Use of
this locking method is, in particular, advisable if
.B MMDF
files are accessed through the Network File System (NFS), since it
seems the only way to reliably invalidate NFS clients' caches.
.IP "\(bu"
.BR flock (2)
locking is mostly used on BSD-based systems.
.IP "\(bu"
Dotlocking is used on all kinds of systems. In order to lock an
.B MMDF
file named \fIfolder\fR, an application first creates a temporary file
with a unique name in the directory in which the
\fIfolder\fR resides. The application then tries to use the
.BR link (2)
system call to create a hard link named \fIfolder.lock\fR
to the temporary file. The success of the
.BR link (2)
system call should be additionally verified using
.BR stat (2)
calls. If the link has succeeded, the mail folder is considered
dotlocked. The temporary file can then safely be unlinked.
.IP ""
In order to release the lock, an application just unlinks the
\fIfolder.lock\fR file.
.PP
If multiple methods are combined, implementors should make sure to
use the non-blocking variants of the
.BR fcntl (2)
and
.BR flock (2)
system calls in order to avoid deadlocks.
.PP
If multiple methods are combined, an
.B MMDF
file must not be considered to have been successfully locked before
all individual locks were obtained. When one of the individual
locking methods fails, an application should release all locks it
acquired successfully, and restart the entire locking procedure from
the beginning, after a suitable delay.
.PP
The locking mechanism used on a particular system is a matter of
local policy, and should be consistently used by all applications
installed on the system which access
.B MMDF
files. Failure to do so may result in loss of e-mail data, and in
corrupted
.B MMDF
files.
.\"
.\" .SH FILES
.\" /usr/spool/mmdf/lock/home
.\" $HOME/Mail/
.\"
.\" .SH SECURITY
.\"
.SH "CONFORMING TO"
.B MMDF
is not part of any currently supported standard.
.\"
.SH HISTORY
.B MMDF
was developed at the University of Delaware by Dave Crocker.
.\"
.SH "SEE ALSO"
.BR scomail (1),
.BR fcntl (2),
.BR flock (2),
.BR link (2),
.BR stat (2),
.BR mbox (5),
.BR RFC822 ,
.BR RFC2822

.SH AUTHOR
Urs Janssen <urs@tin.org>
