/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.connection;

import java.util.Collection;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.InterfaceListCopier;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.preferences.TypeManagementPreferencesHelper;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;

public class CreateStructChange
extends Change {
    private final URI structURI;
    private final Collection<VarDeclaration> vars;

    public CreateStructChange(URI structURI, Collection<VarDeclaration> vars) {
        this.structURI = Objects.requireNonNull(structURI);
        this.vars = Objects.requireNonNull(vars);
    }

    public String getName() {
        return this.structURI.trimFileExtension().lastSegment() + Messages.CreateStructChange_Name;
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return null;
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        Path path = new Path(this.structURI.toPlatformString(true));
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeLibrary(file.getProject()).createTypeEntry(file);
        StructuredType type = DataFactory.eINSTANCE.createStructuredType();
        InterfaceListCopier.copyVarList((Collection)type.getMemberVariables(), this.vars, (boolean)true);
        TypeManagementPreferencesHelper.setupVersionInfo((LibraryElement)type, file.getProject());
        String datatypeName = TypeEntry.getTypeNameFromFile((IFile)file);
        type.setName(datatypeName);
        entry.save((LibraryElement)type);
        return new DeleteResourceChange((IPath)path, false);
    }

    public TypeEntry getModifiedElement() {
        return TypeLibraryManager.INSTANCE.getTypeEntryForURI(this.structURI);
    }
}

