/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.formatting2;

import com.google.common.base.Preconditions;
import java.lang.runtime.SwitchBootstraps;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.ITextReplacer;
import org.eclipse.xtext.formatting2.ITextReplacerContext;
import org.eclipse.xtext.formatting2.internal.TextReplacerContext;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegion;
import org.eclipse.xtext.formatting2.regionaccess.IHiddenRegionPart;
import org.eclipse.xtext.formatting2.regionaccess.ITextRegionAccess;
import org.eclipse.xtext.formatting2.regionaccess.ITextReplacement;
import org.eclipse.xtext.formatting2.regionaccess.ITextSegment;
import org.eclipse.xtext.util.ITextRegion;

public class STCoreTextReplacerContext
extends TextReplacerContext {
    private boolean nextReplacerIsChild;

    public STCoreTextReplacerContext(IFormattableDocument document) {
        this(document, null, 0, null);
    }

    protected STCoreTextReplacerContext(IFormattableDocument document, ITextReplacerContext previous, int indentation, ITextReplacer replacer) {
        super(document, previous, indentation, replacer);
    }

    public int getLeadingCharsInLineCount() {
        ITextRegionAccess access = this.getDocument().getRequest().getTextRegionAccess();
        int lastOffset = this.getReplacer().getRegion().getOffset();
        STCoreTextReplacerContext current = this;
        int count = 0;
        while (current != null) {
            int offset;
            for (ITextReplacement rep : current.getLocalReplacementsReverse()) {
                int endOffset = rep.getEndOffset();
                if (endOffset > lastOffset) continue;
                String between = access.textForOffset(endOffset, lastOffset - endOffset);
                int idx = between.lastIndexOf(10);
                if (idx >= 0) {
                    return count + this.logicalLength(between.substring(idx + 1));
                }
                count += this.logicalLength(between);
                String text = rep.getReplacementText();
                int idx2 = text.lastIndexOf(10);
                if (idx2 >= 0) {
                    return count + this.logicalLength(text.substring(idx2 + 1));
                }
                count += this.logicalLength(text);
                lastOffset = rep.getOffset();
            }
            ITextReplacer replacer = current.getReplacer();
            if (replacer != null && (offset = replacer.getRegion().getOffset()) < lastOffset) {
                String text = access.textForOffset(offset, lastOffset - offset);
                int idx = text.lastIndexOf(10);
                if (idx >= 0) {
                    return count + this.logicalLength(text.substring(idx + 1));
                }
                count += this.logicalLength(text);
                lastOffset = offset;
            }
            current = current.getPreviousContext();
        }
        String rest = access.textForOffset(0, lastOffset);
        int idx = rest.lastIndexOf(10);
        if (idx >= 0) {
            return count + this.logicalLength(rest.substring(idx + 1));
        }
        return count += lastOffset;
    }

    protected boolean isInUndefinedRegion(ITextReplacement replacement) {
        ITextSegment iTextSegment = this.getReplacer().getRegion();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IHiddenRegionPart.class, IHiddenRegion.class}, (Object)iTextSegment, 0)) {
            case 0 -> {
                IHiddenRegionPart hiddenRegionPart = (IHiddenRegionPart)iTextSegment;
                yield hiddenRegionPart.getHiddenRegion().isUndefined();
            }
            case 1 -> {
                IHiddenRegion hiddenRegion = (IHiddenRegion)iTextSegment;
                yield hiddenRegion.isUndefined();
            }
            default -> false;
        };
    }

    public ITextReplacerContext withDocument(IFormattableDocument document) {
        if (document == this.getDocument()) {
            return this;
        }
        STCoreTextReplacerContext context = new STCoreTextReplacerContext(document, (ITextReplacerContext)this, this.getIndentation(), null);
        if (this.nextReplacerIsChild) {
            context.setNextReplacerIsChild();
        }
        return context;
    }

    public ITextReplacerContext withIndentation(int indentation) {
        if (indentation == this.getIndentation()) {
            return this;
        }
        return new STCoreTextReplacerContext(this.getDocument(), (ITextReplacerContext)this, indentation, null);
    }

    public ITextReplacerContext withReplacer(ITextReplacer replacer) {
        if (replacer == this.getReplacer()) {
            return this;
        }
        STCoreTextReplacerContext current = this;
        while (current != null) {
            ITextReplacer lastReplacer = current.getReplacer();
            if (lastReplacer != null) {
                if (this.nextReplacerIsChild) {
                    Preconditions.checkArgument((boolean)lastReplacer.getRegion().contains((ITextRegion)replacer.getRegion()));
                    break;
                }
                Preconditions.checkArgument((lastReplacer.getRegion().getEndOffset() <= replacer.getRegion().getOffset() ? 1 : 0) != 0);
                break;
            }
            current = current.getPreviousContext();
        }
        return new STCoreTextReplacerContext(this.getDocument(), (ITextReplacerContext)this, this.getIndentation(), replacer);
    }

    public void setNextReplacerIsChild() {
        super.setNextReplacerIsChild();
        this.nextReplacerIsChild = true;
    }
}

