/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.annotations.MappingAnnotations;
import org.eclipse.fordiac.ide.model.commands.change.MapToCommand;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.BlockFBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.CommunicationChannel;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.MappingTarget;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.typelibrary.ErrorTypeEntry;
import org.eclipse.fordiac.ide.model.ui.editors.HandlerHelper;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class MapHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompoundCommand mapCommands;
        IEditorPart editor = HandlerUtil.getActiveEditor((ExecutionEvent)event);
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        List fbelements = HandlerHelper.getSelectedFBNElements((ISelection)selection);
        AutomationSystem system = MapHandler.getSystem(editor);
        if (system != null && !fbelements.isEmpty() && !(mapCommands = MapHandler.openDialog(editor.getSite().getShell(), system, fbelements)).isEmpty()) {
            HandlerHelper.getCommandStack((IEditorPart)editor).execute((Command)mapCommands);
        }
        return null;
    }

    private static CompoundCommand openDialog(Shell shell, AutomationSystem system, List<FBNetworkElement> fbelements) {
        Object firstResult;
        CompoundCommand mapCommands = new CompoundCommand();
        ElementTreeSelectionDialog dialog = MapHandler.createDialog(shell, system, MapHandler.containsCommunicationMapping(fbelements));
        if (dialog.open() == 0 && (firstResult = dialog.getFirstResult()) instanceof MappingTarget) {
            MappingTarget mapTarget = (MappingTarget)firstResult;
            fbelements.forEach(fb -> {
                Command cmd = MapToCommand.createMapToCommand((FBNetworkElement)fb, (MappingTarget)mapTarget);
                if (cmd.canExecute()) {
                    mapCommands.add(cmd);
                }
            });
        }
        return mapCommands;
    }

    private static ElementTreeSelectionDialog createDialog(Shell shell, final AutomationSystem system, boolean mapCommunication) {
        final ITreeContentProvider treeProvider = MapHandler.createTreeContentProvider(mapCommunication);
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(shell, (ILabelProvider)MapHandler.createTreeLabelProvider(), treeProvider){

            public int open() {
                Object[] elements = treeProvider.getElements((Object)system);
                if (elements.length == 1) {
                    this.setResult(Arrays.asList(elements));
                    return 0;
                }
                return super.open();
            }
        };
        dialog.setInput((Object)system);
        dialog.setTitle(Messages.MapToDialog_Title);
        dialog.setMessage(Messages.MapToDialog_Message);
        dialog.setHelpAvailable(false);
        dialog.setAllowMultiple(false);
        return dialog;
    }

    private static LabelProvider createTreeLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof MappingTarget) {
                    MappingTarget mapTarget = (MappingTarget)element;
                    return MappingAnnotations.getHierarchicalName((MappingTarget)mapTarget);
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                return FordiacImage.ICON_RESOURCE.getImage();
            }
        };
    }

    private static ITreeContentProvider createTreeContentProvider(final boolean mapCommunication) {
        return new ITreeContentProvider(){

            public boolean hasChildren(Object element) {
                return false;
            }

            public Object getParent(Object element) {
                if (element instanceof EObject) {
                    EObject eObj = (EObject)element;
                    return eObj.eContainer();
                }
                return null;
            }

            public Object[] getElements(Object inputElement) {
                return this.getChildren(inputElement);
            }

            public Object[] getChildren(Object parentElement) {
                if (parentElement instanceof EObject) {
                    EObject eObj = (EObject)parentElement;
                    if (mapCommunication) {
                        return MappingAnnotations.getContainedCommunicationMappingTargets((EObject)eObj).toArray();
                    }
                    return MappingAnnotations.getContainedMappingTargets((EObject)((EObject)parentElement)).toArray();
                }
                return new Object[0];
            }
        };
    }

    public void setEnabled(Object evaluationContext) {
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (editor != null) {
            FBNetwork network = (FBNetwork)editor.getAdapter(FBNetwork.class);
            this.setBaseEnabled(MapHandler.isValidSelection(evaluationContext) && MappingAnnotations.isMapable((FBNetwork)network) && MapHandler.hasDevices(network));
        } else {
            this.setBaseEnabled(false);
        }
    }

    private static boolean isValidSelection(Object evaluationContext) {
        block6: {
            List selected;
            block5: {
                ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
                selected = HandlerHelper.getSelectedFBNElements((ISelection)selection);
                if (selected.isEmpty()) {
                    return false;
                }
                if (MapHandler.containsCommunicationMapping(selected)) break block5;
                if (MapHandler.allFbsAreMapable(selected)) break block6;
            }
            if (!selected.stream().allMatch(CommunicationChannel.class::isInstance)) {
                return false;
            }
        }
        return true;
    }

    private static boolean containsCommunicationMapping(List<FBNetworkElement> selected) {
        return selected.stream().anyMatch(CommunicationChannel.class::isInstance);
    }

    private static boolean allFbsAreMapable(List<FBNetworkElement> fbs) {
        for (FBNetworkElement fb : fbs) {
            BlockFBNetworkElement bfb;
            if (!(fb.getOuterFBNetworkElement() instanceof SubApp) && fb instanceof BlockFBNetworkElement && (bfb = (BlockFBNetworkElement)fb).getInterface().getErrorMarker().isEmpty() && !(fb.getTypeEntry() instanceof ErrorTypeEntry)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasDevices(FBNetwork network) {
        AutomationSystem system = network.getAutomationSystem();
        return system != null && !system.getSystemConfiguration().getDevices().isEmpty();
    }

    public static boolean isMapable(FBNetwork network) {
        return network != null && !network.isSubApplicationNetwork() && !network.isCFBTypeNetwork() && !(network.eContainer() instanceof Resource);
    }

    private static AutomationSystem getSystem(IEditorPart editor) {
        FBNetwork fbNetwork = HandlerHelper.getFBNetwork((IEditorPart)editor);
        return fbNetwork.getAutomationSystem();
    }
}

