/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.marker.resolution;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.model.errormarker.FordiacErrorMarker;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public abstract class AbstractCommandMarkerResolution<T extends EObject>
extends WorkbenchMarkerResolution {
    private final IMarker marker;
    private final Class<T> elementClass;
    private final Map<IResource, LibraryElementInfo> infos = new HashMap<IResource, LibraryElementInfo>();

    protected AbstractCommandMarkerResolution(IMarker marker, Class<T> elementClass) {
        this.marker = Objects.requireNonNull(marker);
        this.elementClass = Objects.requireNonNull(elementClass);
    }

    public final void run(IMarker marker) {
        if (!marker.exists()) {
            return;
        }
        this.run(new IMarker[]{marker}, (IProgressMonitor)new NullProgressMonitor());
    }

    public final void run(final IMarker[] markers, IProgressMonitor monitor) {
        if (markers.length == 0) {
            return;
        }
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    AbstractCommandMarkerResolution.this.runInWorkspace(markers, monitor);
                }
            }.run(monitor);
        }
        catch (InvocationTargetException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof CoreException) {
                CoreException ce = (CoreException)throwable;
                ErrorDialog.openError(null, null, null, (IStatus)ce.getStatus());
            } else {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void runInWorkspace(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(this.getLabel(), 100);
        if (!this.prepare(markers, monitor.slice(10)) || monitor.isCanceled()) {
            return;
        }
        this.createCommands(markers, monitor.slice(20));
        this.commit(monitor.slice(70));
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return (IMarker[])Stream.of(markers).filter(other -> "org.eclipse.fordiac.ide.model.libraryElement".equals(FordiacErrorMarker.getSource((IMarker)other)) && this.isApplicable((IMarker)other)).toArray(IMarker[]::new);
    }

    protected boolean isApplicable(IMarker other) {
        return FordiacErrorMarker.getCode((IMarker)this.marker) == FordiacErrorMarker.getCode((IMarker)other) && Arrays.equals(FordiacErrorMarker.getData((IMarker)other), FordiacErrorMarker.getData((IMarker)this.marker));
    }

    protected abstract boolean prepare(IMarker[] var1, IProgressMonitor var2) throws CoreException;

    protected void createCommands(IMarker[] markers, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.AbstractCommandMarkerResolution_PerformTask, markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            IMarker marker = iMarkerArray[n2];
            this.createCommand(marker, monitor.slice(1));
            ++n2;
        }
    }

    private void createCommand(IMarker marker, IProgressMonitor monitor) throws CoreException {
        LibraryElementInfo info = this.getOrCreateInfo(marker.getResource());
        T element = this.getElement(marker, info.libraryElement());
        if (element == null) {
            throw AbstractCommandMarkerResolution.createExceptionForMarker(Messages.AbstractCommandMarkerResolution_NoSuchElement, marker);
        }
        Command command = this.createCommand(element, monitor);
        if (command == null) {
            throw AbstractCommandMarkerResolution.createExceptionForMarker(Messages.AbstractCommandMarkerResolution_CannotCreateCommand, marker);
        }
        if (!command.canExecute()) {
            throw AbstractCommandMarkerResolution.createExceptionForMarker(Messages.AbstractCommandMarkerResolution_CannotExecuteCommand, marker);
        }
        info.commands().add(command);
    }

    private static CoreException createExceptionForMarker(String pattern, IMarker marker) {
        return new CoreException(Status.error((String)MessageFormat.format(pattern, marker.getAttribute("location", ""), marker.getResource().getFullPath())));
    }

    protected abstract Command createCommand(T var1, IProgressMonitor var2) throws CoreException;

    protected void commit(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(Messages.AbstractCommandMarkerResolution_CommitTask, this.infos.size());
        for (LibraryElementInfo info : this.infos.values()) {
            AbstractCommandMarkerResolution.commit(info, monitor.slice(1));
        }
    }

    private static void commit(LibraryElementInfo info, IProgressMonitor monitor) throws CoreException {
        info.commandStack().ifPresentOrElse(commandStack -> commandStack.execute((Command)info.commands()), () -> ((CompoundCommand)info.commands()).execute());
        if (info.needsSave()) {
            info.libraryElement().getTypeEntry().save(info.libraryElement(), monitor);
            info.commandStack().ifPresent(CommandStack::markSaveLocation);
        }
    }

    protected boolean needsSave(IEditorPart editor) {
        return !editor.isDirty();
    }

    public IMarker getMarker() {
        return this.marker;
    }

    public final Class<T> getElementClass() {
        return this.elementClass;
    }

    public TypeLibrary getTypeLibrary() {
        return TypeLibraryManager.INSTANCE.getTypeLibrary(this.marker.getResource().getProject());
    }

    private LibraryElementInfo getOrCreateInfo(IResource resource) {
        return this.infos.computeIfAbsent(resource, this::createInfo);
    }

    private LibraryElementInfo createInfo(IResource resource) {
        LibraryElement libraryElement;
        Optional<IEditorPart> editor = AbstractCommandMarkerResolution.findEditor(resource);
        Optional<CommandStack> commandStack = editor.map(AbstractCommandMarkerResolution::getCommandStack);
        if (editor.isPresent() && commandStack.isPresent()) {
            libraryElement = (LibraryElement)Adapters.adapt((Object)editor.get(), LibraryElement.class);
        } else if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            TypeEntry typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            if (typeEntry == null) {
                return null;
            }
            libraryElement = typeEntry.copyType();
        } else {
            return null;
        }
        return new LibraryElementInfo(libraryElement, new CompoundCommand(), commandStack, commandStack.isEmpty() || editor.filter(this::needsSave).isPresent());
    }

    private static Optional<IEditorPart> findEditor(IResource resource) {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            FileEditorInput editorInput = new FileEditorInput(file);
            return Stream.of(PlatformUI.getWorkbench().getWorkbenchWindows()).flatMap(window -> Stream.of(window.getPages())).map(arg_0 -> AbstractCommandMarkerResolution.lambda$9((IEditorInput)editorInput, arg_0)).filter(Objects::nonNull).findAny();
        }
        return Optional.empty();
    }

    private static CommandStack getCommandStack(IEditorPart editor) {
        return (CommandStack)Adapters.adapt((Object)editor, CommandStack.class);
    }

    private final T getElement(IMarker marker, LibraryElement libraryElement) {
        EObject element = FordiacErrorMarker.getTargetRelative((IMarker)marker, (LibraryElement)libraryElement);
        if (this.elementClass.isInstance(element)) {
            return (T)((EObject)this.elementClass.cast(element));
        }
        return null;
    }

    private static /* synthetic */ IEditorPart lambda$9(IEditorInput iEditorInput, IWorkbenchPage page) {
        return page.findEditor(iEditorInput);
    }

    private record LibraryElementInfo(LibraryElement libraryElement, CompoundCommand commands, Optional<CommandStack> commandStack, boolean needsSave) {
    }
}

