/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.value;

import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.NoSuchElementException;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.value.TimeOfDayValueConverter;
import org.eclipse.fordiac.ide.model.value.ValueConverter;

public final class DateAndTimeValueConverter
implements ValueConverter<LocalDateTime> {
    public static final DateAndTimeValueConverter INSTANCE = new DateAndTimeValueConverter();
    static final DateTimeFormatter DATE_AND_TIME = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral('-').append(TimeOfDayValueConverter.TIME_OF_DAY_FORMATTER).toFormatter();
    private static final Pattern SCANNER_PATTERN = Pattern.compile("\\G\\d[_\\d]++-\\d[_\\d]++-\\d[_\\d]++-\\d[_\\d]++:\\d[_\\d]++:\\d[_\\d]++(?:\\.\\d[_\\d]++)?");

    private DateAndTimeValueConverter() {
    }

    @Override
    public String toString(LocalDateTime value) {
        return value.format(DATE_AND_TIME);
    }

    @Override
    public LocalDateTime toValue(String string) {
        if (string.indexOf("__") != -1) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_CONSECUTIVE_UNDERSCORES_ERROR_MESSAGE, string));
        }
        try {
            return LocalDateTime.parse(string.replace("_", ""), DATE_AND_TIME);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.VALIDATOR_INVALID_DATE_AND_TIME_FORMAT, string), e);
        }
    }

    @Override
    public LocalDateTime toValue(Scanner scanner) throws IllegalArgumentException, NoSuchElementException, IllegalStateException {
        return (LocalDateTime)this.toValue(scanner, SCANNER_PATTERN);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

