/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.stcore.impl;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STString;

final class STStringAnnotations {
    private static final byte UTF_16_BOM_LOW = -1;
    private static final byte UTF_16_BOM_HIGH = -2;
    private static final byte[] UTF_16_BOM = new byte[]{-2, -1};
    private static final String UTF_16_BOM_BASE64 = Base64.getEncoder().encodeToString(UTF_16_BOM);

    static STString createSTString(String it) {
        byte[] data = Base64.getDecoder().decode(it);
        boolean wide = STStringAnnotations.isWide(data);
        Charset charset = wide ? StandardCharsets.UTF_16 : StandardCharsets.UTF_8;
        String value = new String(data, charset);
        return new STString(value, wide);
    }

    private static boolean isWide(byte[] data) {
        return data.length >= 2 && (data[0] == -2 && data[1] == -1 || data[0] == -1 && data[1] == -2);
    }

    static String convertSTString(STString it) {
        Charset charset = it.isWide() ? StandardCharsets.UTF_16 : StandardCharsets.UTF_8;
        byte[] data = it.toString().getBytes(charset);
        if (data.length == 0 && it.isWide()) {
            return UTF_16_BOM_BASE64;
        }
        return Base64.getEncoder().encodeToString(data);
    }

    private STStringAnnotations() {
        throw new UnsupportedOperationException();
    }
}

