/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typeeditor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.fordiac.ide.typeeditor.ITypeEditorPage;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class AbstractTypeEditorPage
extends EditorPart
implements ITypeEditorPage,
CommandStackEventListener {
    private CommandStack commandStack;
    private ActionRegistry actionRegistry;
    private final List<String> selectionActions = new ArrayList<String>();
    private final List<String> stackActions = new ArrayList<String>();
    private final List<String> propertyActions = new ArrayList<String>();

    private void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        UndoAction action = new UndoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
        action = new RedoAction((IEditorPart)this);
        registry.registerAction((IAction)action);
        this.getStackActions().add(action.getId());
    }

    public void dispose() {
        this.getCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        this.removeSelectionListener();
        this.getActionRegistry().dispose();
        super.dispose();
    }

    private void removeSelectionListener() {
        IWorkbenchPartSite site = this.getSite();
        if (site == null) {
            return;
        }
        IWorkbenchWindow workbenchWindow = site.getWorkbenchWindow();
        if (workbenchWindow == null) {
            return;
        }
        ISelectionService selectionService = workbenchWindow.getSelectionService();
        if (selectionService == null) {
            return;
        }
        selectionService.removeSelectionListener((ISelectionListener)this);
    }

    private ActionRegistry getActionRegistry() {
        if (this.actionRegistry == null) {
            this.actionRegistry = new ActionRegistry();
        }
        return this.actionRegistry;
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == CommandStack.class) {
            return key.cast(this.getCommandStack());
        }
        if (key == ActionRegistry.class) {
            return key.cast(this.getActionRegistry());
        }
        return (T)super.getAdapter(key);
    }

    protected CommandStack getCommandStack() {
        return this.commandStack;
    }

    private List<String> getStackActions() {
        return this.stackActions;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        site.getWorkbenchWindow().getSelectionService().addSelectionListener((ISelectionListener)this);
        this.setupCommandStack();
        this.initializeActionRegistry();
        this.setActionHandlers(site);
    }

    private void initializeActionRegistry() {
        this.createActions();
        this.updateActions(this.propertyActions);
        this.updateActions(this.stackActions);
    }

    public boolean isDirty() {
        return this.getCommandStack().isDirty();
    }

    /*
     * WARNING - void declaration
     */
    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        void multiPageEditorSite;
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (!(iWorkbenchPartSite instanceof MultiPageEditorSite)) {
            return;
        }
        MultiPageEditorSite multiPageEditorSite2 = (MultiPageEditorSite)iWorkbenchPartSite;
        IWorkbenchPage page = multiPageEditorSite.getPage();
        if (page == null) {
            this.removeSelectionListener();
            return;
        }
        if (multiPageEditorSite.getMultiPageEditor().equals(page.getActiveEditor())) {
            this.updateActions(this.selectionActions);
        }
    }

    private void setActionHandlers(IEditorSite site) {
        ActionRegistry registry = this.getActionRegistry();
        IActionBars bars = site.getActionBars();
        String id = ActionFactory.UNDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.REDO.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        id = ActionFactory.DELETE.getId();
        bars.setGlobalActionHandler(id, registry.getAction((Object)id));
        bars.updateActionBars();
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
    }

    private void setupCommandStack() {
        IWorkbenchPartSite iWorkbenchPartSite = this.getSite();
        if (iWorkbenchPartSite instanceof MultiPageEditorSite) {
            MultiPageEditorSite multiPageEditorSite = (MultiPageEditorSite)iWorkbenchPartSite;
            this.commandStack = (CommandStack)multiPageEditorSite.getMultiPageEditor().getAdapter(CommandStack.class);
            this.commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        if (event.isPostChangeEvent()) {
            this.updateActions(this.stackActions);
        }
    }

    private void updateActions(List<String> actionIds) {
        ActionRegistry registry = this.getActionRegistry();
        actionIds.forEach(id -> {
            IAction action = registry.getAction(id);
            if (action instanceof UpdateAction) {
                UpdateAction updateAction = (UpdateAction)action;
                updateAction.update();
            }
        });
    }
}

