/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.handlers;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.draw2d.IFigure;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractBlockFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.FBNetworkRootEditPart;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.RootEditPart;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

public class MarkPredecessorHandler
extends AbstractHandler
implements IElementUpdater {
    private static final String MARKER_COLOR = "org.eclipse.fordiac.ide.ui.PredecessorMarkerColor";
    private static Map<URI, AbstractBlockFBNElementEditPart> predecessorMap = new HashMap<URI, AbstractBlockFBNElementEditPart>();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        AbstractBlockFBNElementEditPart ep = MarkPredecessorHandler.getValidSelectedFBNElement((ISelection)selection);
        if (ep != null) {
            FBNetworkRootEditPart root = (FBNetworkRootEditPart)ep.getRoot();
            if (MarkPredecessorHandler.isActivePredecessor(ep)) {
                MarkPredecessorHandler.removePredecessor(root);
            } else {
                MarkPredecessorHandler.setPredecessor(root, ep);
            }
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        IEditorPart currentActiveEditor = EditorUtils.getCurrentActiveEditor();
        if (currentActiveEditor != null) {
            FBNetworkRootEditPart root;
            GraphicalViewer viewer = (GraphicalViewer)currentActiveEditor.getAdapter(GraphicalViewer.class);
            if (viewer == null || viewer.getSelectedEditParts().isEmpty()) {
                return;
            }
            EditPart editPart = (EditPart)viewer.getSelectedEditParts().getFirst();
            RootEditPart rootEditPart = editPart.getRoot();
            if (rootEditPart instanceof FBNetworkRootEditPart && MarkPredecessorHandler.getPredecessor(root = (FBNetworkRootEditPart)rootEditPart) != null && ((Object)((Object)MarkPredecessorHandler.getPredecessor(root))).equals(editPart)) {
                element.setText(Messages.FBMarker_RemovePredecessorMarker);
            }
        }
    }

    public void setEnabled(Object evaluationContext) {
        IEditorPart editor = (IEditorPart)HandlerUtil.getVariable((Object)evaluationContext, (String)"activeEditor");
        if (editor != null) {
            ISelection selection = (ISelection)HandlerUtil.getVariable((Object)evaluationContext, (String)"selection");
            this.setBaseEnabled(MarkPredecessorHandler.getValidSelectedFBNElement(selection) != null);
        } else {
            this.setBaseEnabled(false);
        }
    }

    private static AbstractBlockFBNElementEditPart getValidSelectedFBNElement(ISelection selection) {
        AbstractBlockFBNElementEditPart ep;
        IStructuredSelection structSel;
        Object object;
        if (selection instanceof IStructuredSelection && (object = (structSel = (IStructuredSelection)selection).getFirstElement()) instanceof AbstractBlockFBNElementEditPart && (ep = (AbstractBlockFBNElementEditPart)((Object)object)).getRoot() instanceof FBNetworkRootEditPart) {
            return ep;
        }
        return null;
    }

    public static void setPredecessor(FBNetworkRootEditPart root, AbstractBlockFBNElementEditPart predecessorEP) {
        AbstractBlockFBNElementEditPart previousEntry = predecessorMap.put(EcoreUtil.getURI((EObject)((EObject)root.getAdapter(FBNetwork.class))), predecessorEP);
        if (previousEntry != null) {
            GraphicalAnnotationStyles.removeAnnotationBorders((IFigure)previousEntry.getFigure());
        }
        if (predecessorEP != null) {
            GraphicalAnnotationStyles.setAnnotationFeedbackBorder((IFigure)predecessorEP.getFigure(), (Color)JFaceResources.getColorRegistry().get(MARKER_COLOR));
            MarkPredecessorHandler.setStatusLineMessage(MessageFormat.format(Messages.FBMarker_ActivePredecessor, predecessorEP.getModel().getQualifiedName()));
        }
    }

    public static void removePredecessor(FBNetworkRootEditPart root) {
        MarkPredecessorHandler.setPredecessor(root, null);
        MarkPredecessorHandler.setStatusLineMessage("");
    }

    public static AbstractBlockFBNElementEditPart getPredecessor(FBNetworkRootEditPart root) {
        return predecessorMap.get(EcoreUtil.getURI((EObject)((EObject)root.getAdapter(FBNetwork.class))));
    }

    public static boolean hasPredecessorMarker(INamedElement element) {
        if (element instanceof FBNetworkElement) {
            FBNetworkElement fb = (FBNetworkElement)element;
            for (Map.Entry<URI, AbstractBlockFBNElementEditPart> entry : predecessorMap.entrySet()) {
                if (entry.getValue() == null || !entry.getValue().getModel().equals(fb)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isActivePredecessor(AbstractBlockFBNElementEditPart ep) {
        RootEditPart rootEditPart = ep.getRoot();
        if (rootEditPart instanceof FBNetworkRootEditPart) {
            FBNetworkRootEditPart root = (FBNetworkRootEditPart)rootEditPart;
            return MarkPredecessorHandler.getPredecessor(root) != null && ((Object)((Object)MarkPredecessorHandler.getPredecessor(root))).equals((Object)ep);
        }
        return false;
    }

    private static void setStatusLineMessage(String message) {
        IStatusLineManager manager = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorSite().getActionBars().getStatusLineManager();
        manager.setMessage(message);
        manager.update(false);
    }
}

