/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FlowLayout;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayeredPane;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.fordiac.ide.fbtypeeditor.servicesequence.ServiceConstants;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.fordiac.ide.util.ColorManager;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;

public final class ServiceFigure
extends FreeformLayeredPane {
    private static final int MIDDLE_LINE_WIDTH = 2;
    public static final String LABEL_FONT = "labelFont";
    private Label leftLabel;
    private Label rightLabel;
    private Layer serviceSequenceContainer;
    private static FontRegistry fontRegistry = null;

    public ServiceFigure() {
        this.setLayoutManager((LayoutManager)new StackLayout());
        this.setForegroundColor(ColorConstants.blue);
        this.createBaseLayer();
        this.createInterfaceLayer();
        this.createServiceSequenceLayer();
    }

    public static FontRegistry getFontRegistry() {
        if (fontRegistry == null) {
            fontRegistry = ServiceFigure.createFontRegistry();
        }
        return fontRegistry;
    }

    private static FontRegistry createFontRegistry() {
        FontRegistry newfontRegistry = new FontRegistry();
        newfontRegistry.put(LABEL_FONT, new FontData[]{new FontData("Arial", 10, 0)});
        return newfontRegistry;
    }

    private void createBaseLayer() {
        FreeformLayer baseLayer = new FreeformLayer();
        baseLayer.setBorder((Border)new MarginBorder(0, 10, 0, 10));
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        baseLayer.setLayoutManager((LayoutManager)layout);
        Figure leftFigure = new Figure();
        AdvancedLineBorder leftMiddleLine = new AdvancedLineBorder(16);
        leftMiddleLine.setWidth(4);
        leftFigure.setBorder((Border)leftMiddleLine);
        baseLayer.add((IFigure)leftFigure);
        AdvancedLineBorder middleLines = leftMiddleLine;
        middleLines.setWidth(2);
        middleLines.setColor(ColorManager.getColor((RGB)ServiceConstants.TEXT_BLUE));
        Figure middleFigure = new Figure();
        middleFigure.setBorder((Border)middleLines);
        middleFigure.setBackgroundColor(ColorManager.getColor((RGB)ServiceConstants.LIGHTER_GRAY));
        middleFigure.setOpaque(true);
        baseLayer.add((IFigure)middleFigure);
        Figure rightFigure = new Figure();
        baseLayer.add((IFigure)rightFigure);
        GridLayout rightLayout = new GridLayout();
        rightFigure.setLayoutManager((LayoutManager)rightLayout);
        rightLayout.horizontalSpacing = 0;
        rightLayout.marginWidth = 0;
        rightLayout.marginHeight = 0;
        rightLayout.verticalSpacing = 0;
        baseLayer.add((IFigure)rightFigure);
        GridData middleGridData = new GridData(0, 4, false, true);
        middleGridData.widthHint = ServiceConstants.getMiddleSectionWidth();
        layout.setConstraint((IFigure)middleFigure, (Object)middleGridData);
        GridData leftGridData = new GridData(4, 4, true, true);
        leftGridData.widthHint = ServiceConstants.getRightLeftSectionWidth();
        GridData rightGridData = new GridData(4, 4, true, true);
        rightGridData.widthHint = ServiceConstants.getRightLeftSectionWidth();
        layout.setConstraint((IFigure)leftFigure, (Object)leftGridData);
        layout.setConstraint((IFigure)rightFigure, (Object)rightGridData);
        this.add((IFigure)baseLayer);
    }

    private void createInterfaceLayer() {
        FreeformLayer interfaceLayer = new FreeformLayer();
        interfaceLayer.setBorder((Border)new MarginBorder(5, 0, 0, 0));
        GridLayout layout = new GridLayout(2, true);
        interfaceLayer.setForegroundColor(ColorManager.getColor((RGB)ServiceConstants.TEXT_BLUE));
        layout.horizontalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        interfaceLayer.setLayoutManager((LayoutManager)layout);
        this.leftLabel = ServiceFigure.createLabel(true);
        GridData leftLabelData = new GridData(131072, 0, true, false);
        interfaceLayer.getLayoutManager().setConstraint((IFigure)this.leftLabel, (Object)leftLabelData);
        interfaceLayer.add((IFigure)this.leftLabel);
        this.rightLabel = ServiceFigure.createLabel(false);
        GridData rightLabelData = new GridData(16384, 0, true, false);
        interfaceLayer.getLayoutManager().setConstraint((IFigure)this.rightLabel, (Object)rightLabelData);
        interfaceLayer.add((IFigure)this.rightLabel);
        this.add((IFigure)interfaceLayer);
    }

    private static Label createLabel(boolean isLeftInterface) {
        int centerMargin = 100;
        int topMargin = 5;
        int borderMargin = 30;
        Label label = new Label();
        label.setFont(ServiceFigure.getFontRegistry().get(LABEL_FONT));
        if (isLeftInterface) {
            label.setLabelAlignment(4);
            label.setBorder((Border)new MarginBorder(5, 30, 0, 100));
        } else {
            label.setLabelAlignment(1);
            label.setBorder((Border)new MarginBorder(5, 100, 0, 30));
        }
        return label;
    }

    private void createServiceSequenceLayer() {
        this.serviceSequenceContainer = new FreeformLayer();
        this.serviceSequenceContainer.setBorder((Border)new MarginBorder(20, 10, 5, 10));
        FlowLayout layout = new FlowLayout();
        this.serviceSequenceContainer.setLayoutManager((LayoutManager)layout);
        this.add((IFigure)this.serviceSequenceContainer);
    }

    public Label getLeftLabel() {
        return this.leftLabel;
    }

    public Label getRightLabel() {
        return this.rightLabel;
    }

    public Layer getServiceSequenceContainer() {
        return this.serviceSequenceContainer;
    }

    public void setLeftLabelText(String name, String comment) {
        this.leftLabel.setText(name != null ? name : "");
        this.leftLabel.setIcon(FordiacImage.ICON_LEFT_INPUT_PRIMITIVE.getImage());
        this.leftLabel.setTextPlacement(8);
        if (comment != null && !comment.isEmpty()) {
            this.leftLabel.setToolTip((IFigure)new Label(comment));
        }
    }

    public void setRightLabelText(String name, String comment) {
        this.rightLabel.setText(name != null ? name : "");
        this.rightLabel.setIcon(FordiacImage.ICON_RIGHT_OUTPUT_PRIMITIVE.getImage());
        this.rightLabel.setTextPlacement(16);
        if (comment != null && !comment.isEmpty()) {
            this.rightLabel.setToolTip((IFigure)new Label(comment));
        }
    }
}

