/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.comments;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.elk.core.comments.IDataProvider;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.util.ElkGraphUtil;

public class ElkGraphDataProvider
implements IDataProvider<ElkNode, ElkNode> {
    private final ElkNode graph;

    public ElkGraphDataProvider(ElkNode graph) {
        Objects.requireNonNull(graph, "Comment attachment must be run on a graph.");
        this.graph = graph;
    }

    @Override
    public Collection<ElkNode> provideComments() {
        return this.graph.getChildren().stream().filter(node -> (Boolean)node.getProperty(CoreOptions.COMMENT_BOX)).collect(Collectors.toList());
    }

    @Override
    public Collection<ElkNode> provideTargets() {
        return this.graph.getChildren().stream().filter(node -> (Boolean)node.getProperty(CoreOptions.COMMENT_BOX) == false).collect(Collectors.toList());
    }

    @Override
    public Collection<IDataProvider<ElkNode, ElkNode>> provideSubHierarchies() {
        return this.graph.getChildren().stream().filter(node -> !node.getChildren().isEmpty()).map(node -> new ElkGraphDataProvider((ElkNode)node)).collect(Collectors.toList());
    }

    @Override
    public void attach(ElkNode comment, ElkNode target) {
        ElkGraphUtil.createSimpleEdge((ElkConnectableShape)comment, (ElkConnectableShape)target);
    }
}

