/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.dataimport;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.dataimport.CommonElementImporter;
import org.eclipse.fordiac.ide.model.dataimport.InterfaceListImporter;
import org.eclipse.fordiac.ide.model.dataimport.TypeImporter;
import org.eclipse.fordiac.ide.model.dataimport.exceptions.TypeImportException;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.OutputPrimitive;
import org.eclipse.fordiac.ide.model.libraryElement.Primitive;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceInterface;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceSequence;
import org.eclipse.fordiac.ide.model.libraryElement.ServiceTransaction;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;

public abstract class BlockTypeImporter
extends TypeImporter {
    private InterfaceListImporter interfaceListImporter;

    protected BlockTypeImporter(IFile file) {
        super(file);
    }

    protected BlockTypeImporter(InputStream inputStream, TypeLibrary typeLibrary) {
        super(inputStream, typeLibrary);
    }

    protected BlockTypeImporter(CommonElementImporter importer) {
        super(importer);
    }

    public FBType loadInterface() throws IOException, XMLStreamException, TypeImportException {
        this.setElement(this.createRootModelElement());
        Throwable throwable = null;
        Object var2_3 = null;
        try (CommonElementImporter.ImporterStreams streams = this.createInputStreams(this.getInputStream());){
            this.proceedToStartElementNamed(this.getStartElementName());
            this.readNameCommentAttributes(this.getElement());
            while (this.getReader().hasNext()) {
                int event = this.getReader().next();
                if (1 != event) continue;
                String localName = this.getReader().getLocalName();
                if ("CompilerInfo".equals(localName)) {
                    this.getElement().setCompilerInfo(this.parseCompilerInfo());
                    continue;
                }
                if (!this.getInterfaceListElementName().equals(localName)) continue;
                this.getElement().setInterfaceList(this.getInterfaceListImporter().parseInterfaceList(this.getInterfaceListElementName()));
                break;
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (this.getElement().getCompilerInfo() == null) {
            this.getElement().setCompilerInfo(LibraryElementFactory.eINSTANCE.createCompilerInfo());
        }
        return this.getElement();
    }

    protected String getInterfaceListElementName() {
        return "InterfaceList";
    }

    protected void parseService(FBType type) throws TypeImportException, XMLStreamException {
        String rightInterface = this.getAttributeValue("RightInterface");
        if (rightInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_RIGHTINTERFACE_EXCEPTION);
        }
        ServiceInterface rightInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        rightInter.setName(rightInterface);
        type.getService().setRightInterface(rightInter);
        String leftInterface = this.getAttributeValue("LeftInterface");
        if (leftInterface == null) {
            throw new TypeImportException(Messages.FBTImporter_SERVICE_INTERFACE_LEFTINTERFACE_EXCEPTION);
        }
        ServiceInterface leftInter = LibraryElementFactory.eINSTANCE.createServiceInterface();
        leftInter.setName(leftInterface);
        type.getService().setLeftInterface(leftInter);
        String comment = this.getAttributeValue("Comment");
        if (comment != null) {
            type.getService().setComment(comment);
        }
        this.processChildren("Service", name -> {
            if ("ServiceSequence".equals(name)) {
                this.parseServiceSequence(type);
                return true;
            }
            return false;
        });
    }

    private void parseServiceSequence(FBType type) throws TypeImportException, XMLStreamException {
        ServiceSequence serviceSequence = LibraryElementFactory.eINSTANCE.createServiceSequence();
        this.readNameCommentAttributes(serviceSequence);
        this.processChildren("ServiceSequence", name -> {
            if ("ServiceTransaction".equals(name)) {
                this.parseServiceTransaction(serviceSequence, type);
                return true;
            }
            if ("Attribute".equals(name)) {
                this.parseGenericAttributeNode(serviceSequence);
                this.proceedToEndElementNamed(name);
                return true;
            }
            return false;
        });
        BlockTypeImporter.processServiceAttributes(serviceSequence);
        type.getService().getServiceSequence().add((Object)serviceSequence);
    }

    private static void processServiceAttributes(ServiceSequence serviceSequence) {
        EList attrs = serviceSequence.getAttributes();
        ArrayList<Attribute> processed = new ArrayList<Attribute>();
        for (Attribute attr : attrs) {
            if (attr.getName().equals("StartState")) {
                serviceSequence.setStartState(attr.getValue());
                processed.add(attr);
                continue;
            }
            if (!attr.getName().equals("ServiceSequenceType")) continue;
            serviceSequence.setServiceSequenceType(attr.getValue());
            processed.add(attr);
        }
        attrs.removeAll(processed);
    }

    private void parseServiceTransaction(ServiceSequence serviceSequence, FBType type) throws TypeImportException, XMLStreamException {
        ServiceTransaction serviceTransaction = LibraryElementFactory.eINSTANCE.createServiceTransaction();
        this.processChildren("ServiceTransaction", name -> {
            switch (name) {
                case "InputPrimitive": {
                    this.parseInputPrimitive(serviceTransaction, type);
                    break;
                }
                case "OutputPrimitive": {
                    this.parseOutputPrimitive(serviceTransaction, type);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        });
        serviceSequence.getServiceTransaction().add((Object)serviceTransaction);
    }

    private void parseOutputPrimitive(ServiceTransaction serviceTransaction, FBType type) throws TypeImportException, XMLStreamException {
        OutputPrimitive outputPrimitive = LibraryElementFactory.eINSTANCE.createOutputPrimitive();
        this.parsePrimitive(type, outputPrimitive);
        this.proceedToEndElementNamed("OutputPrimitive");
        serviceTransaction.getOutputPrimitive().add((Object)outputPrimitive);
    }

    private void parsePrimitive(FBType type, Primitive outputPrimitive) throws TypeImportException {
        String interFace = this.getAttributeValue("Interface");
        if (interFace == null) {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EXCEPTION);
        }
        if (interFace.equals(type.getService().getLeftInterface().getName())) {
            outputPrimitive.setInterface(type.getService().getLeftInterface());
        } else if (interFace.equals(type.getService().getRightInterface().getName())) {
            outputPrimitive.setInterface(type.getService().getRightInterface());
        }
        String event = this.getAttributeValue(this.getEventElement());
        if (event == null) {
            throw new TypeImportException(Messages.FBTImporter_OUTPUT_PRIMITIVE_EVENT_EXCEPTION);
        }
        outputPrimitive.setEvent(event);
        String parameters = this.getAttributeValue("Parameters");
        if (parameters != null) {
            outputPrimitive.setParameters(parameters);
        }
    }

    private void parseInputPrimitive(ServiceTransaction serviceTransaction, FBType type) throws TypeImportException, XMLStreamException {
        InputPrimitive inputPrimitive = LibraryElementFactory.eINSTANCE.createInputPrimitive();
        this.parsePrimitive(type, inputPrimitive);
        this.proceedToEndElementNamed("InputPrimitive");
        serviceTransaction.setInputPrimitive(inputPrimitive);
    }

    protected final InterfaceListImporter getInterfaceListImporter() {
        if (this.interfaceListImporter == null) {
            this.interfaceListImporter = this.createInterfaceListImporter();
        }
        return this.interfaceListImporter;
    }

    protected InterfaceListImporter createInterfaceListImporter() {
        return new InterfaceListImporter(this);
    }

    protected String getEventElement() {
        return "Event";
    }

    @Override
    public FBType getElement() {
        return (FBType)super.getElement();
    }
}

