/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.scoping;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.inject.Singleton;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.eval.function.Comment;
import org.eclipse.fordiac.ide.model.eval.function.Functions;
import org.eclipse.fordiac.ide.model.eval.function.OnlySupportedBy;
import org.eclipse.fordiac.ide.model.eval.function.ReturnValueComment;
import org.eclipse.fordiac.ide.model.eval.function.StandardFunctions;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.impl.CallableAnnotations;
import org.eclipse.fordiac.ide.structuredtextcore.resource.STCoreResourceDescriptionStrategy;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCoreFactory;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.util.STCoreRegionString;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.EObjectDescription;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.Scopes;

@Singleton
public class STStandardFunctionProvider {
    public static final URI STANDARD_FUNCTIONS_URI = URI.createURI((String)"__st_standard_functions.stfunc");
    private final Resource functionResource;
    private final Class<? extends Functions> functions;
    private final Map<Method, STStandardFunction> standardFunctions;
    private final List<IEObjectDescription> standardFunctionDescriptions;
    private final LoadingCache<StandardFunctionLookupKey, Optional<STStandardFunction>> standardFunctionLookup;
    private final LoadingCache<StandardFunctionLookupKey, Optional<IEObjectDescription>> standardFunctionDescriptionLookup;

    public STStandardFunctionProvider() {
        this(StandardFunctions.class);
    }

    public STStandardFunctionProvider(Class<? extends Functions> functions) {
        this.functions = functions;
        this.functionResource = new ResourceImpl();
        this.functionResource.setURI(STANDARD_FUNCTIONS_URI);
        this.standardFunctions = Functions.getMethods(functions).stream().collect(Collectors.toMap(Function.identity(), this::createStandardFunction));
        this.standardFunctionDescriptions = StreamSupport.stream(Scopes.scopedElementsFor(this.standardFunctions.values()).spliterator(), false).toList();
        this.standardFunctionLookup = CacheBuilder.newBuilder().maximumSize((long)this.standardFunctions.size() * 10L).build(CacheLoader.from(this::findInternal));
        this.standardFunctionDescriptionLookup = CacheBuilder.newBuilder().maximumSize((long)this.standardFunctions.size() * 10L).build(CacheLoader.from(this::findDescriptionInternal));
    }

    public Iterable<STStandardFunction> get() {
        return this.standardFunctions.values();
    }

    public Optional<STStandardFunction> find(String name, List<DataType> argumentTypes) {
        try {
            return (Optional)this.standardFunctionLookup.get((Object)new StandardFunctionLookupKey(name, argumentTypes));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    protected Optional<STStandardFunction> findInternal(StandardFunctionLookupKey key) {
        try {
            return Optional.of(this.standardFunctions.get(Functions.findMethodFromDataTypes(this.functions, (String)key.getName(), key.getArgumentTypes())));
        }
        catch (IllegalStateException | NoSuchMethodException e) {
            return Functions.findMethods(this.functions, (String)key.getName()).stream().map(this.standardFunctions::get).findFirst();
        }
    }

    public List<IEObjectDescription> getDescriptions() {
        return this.standardFunctionDescriptions;
    }

    public Optional<IEObjectDescription> findDescription(String name, List<DataType> argumentTypes) {
        try {
            return (Optional)this.standardFunctionDescriptionLookup.get((Object)new StandardFunctionLookupKey(name, argumentTypes));
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    protected Optional<IEObjectDescription> findDescriptionInternal(StandardFunctionLookupKey key) {
        try {
            return ((Optional)this.standardFunctionLookup.get((Object)key)).map(STStandardFunctionProvider::createStandardFunctionDescription);
        }
        catch (ExecutionException e) {
            return Optional.empty();
        }
    }

    protected STStandardFunction createStandardFunction(Method method) {
        STStandardFunction result = STCoreFactory.eINSTANCE.createSTStandardFunction();
        result.setJavaMethod(method);
        result.setName(method.getName());
        result.setComment(STStandardFunctionProvider.extractComment(method));
        result.setReturnValueComment(STStandardFunctionProvider.extractReturnValueComment(method));
        result.setReturnType(method.getReturnType() != Void.TYPE ? ValueOperations.dataType(method.getReturnType()) : null);
        result.getInputParameters().addAll((Collection)STCoreUtil.computeInputParameters((ICallable)result, Collections.emptyList()));
        result.getOutputParameters().addAll((Collection)STCoreUtil.computeOutputParameters((ICallable)result, Collections.emptyList()));
        result.setVarargs(method.isVarArgs());
        result.setSignature(CallableAnnotations.getSignature((ICallable)result));
        Stream.of((OnlySupportedBy[])method.getAnnotationsByType(OnlySupportedBy.class)).map(OnlySupportedBy::value).flatMap(stringArray -> Stream.of(stringArray)).forEachOrdered(arg_0 -> result.getOnlySupportedBy().add(arg_0));
        this.functionResource.getContents().add((Object)result);
        return result;
    }

    protected static String extractComment(Method method) {
        if (method.isAnnotationPresent(Comment.class)) {
            return method.getAnnotation(Comment.class).value();
        }
        return "";
    }

    protected static String extractReturnValueComment(Method method) {
        if (method.isAnnotationPresent(ReturnValueComment.class)) {
            return method.getAnnotation(ReturnValueComment.class).value();
        }
        return "";
    }

    protected static IEObjectDescription createStandardFunctionDescription(STStandardFunction standardFunction) {
        STCoreRegionString regionString = STCoreResourceDescriptionStrategy.getCallableParameterProposal((ICallable)standardFunction);
        return new EObjectDescription(QualifiedName.create((String)standardFunction.getName()), (EObject)standardFunction, Map.of(STCoreResourceDescriptionStrategy.DISPLAY_STRING, standardFunction.getSignature(), STCoreResourceDescriptionStrategy.PARAMETER_PROPOSAL, regionString.toString(), STCoreResourceDescriptionStrategy.PARAMETER_PROPOSAL_REGIONS, regionString.getRegions().toString()));
    }

    protected static class StandardFunctionLookupKey {
        private final String name;
        private final List<DataType> argumentTypes;
        private final List<String> argumentTypeNames;
        private final int hashCode;

        public StandardFunctionLookupKey(String name, List<DataType> argumentTypes) {
            this.name = name;
            this.argumentTypes = ImmutableList.copyOf(argumentTypes);
            this.argumentTypeNames = argumentTypes.stream().map(PackageNameHelper::getFullTypeName).toList();
            this.hashCode = Objects.hash(name, this.argumentTypeNames);
        }

        public String getName() {
            return this.name;
        }

        public List<DataType> getArgumentTypes() {
            return this.argumentTypes;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            StandardFunctionLookupKey other = (StandardFunctionLookupKey)obj;
            return Objects.equals(this.name, other.name) && Objects.equals(this.argumentTypeNames, other.argumentTypeNames);
        }
    }
}

