/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.validation.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.validation.handlers.ValidationHelper;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class ValidationHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        INamedElement selectedElement = ValidationHandler.getSelectedElement((StructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        ValidationHelper.validate(selectedElement);
        return null;
    }

    private static INamedElement getSelectedElement(StructuredSelection currentSelection) {
        INamedElement ne;
        Object obj = currentSelection.getFirstElement();
        if (obj instanceof IFile) {
            IFile file = (IFile)obj;
            return ValidationHandler.checkSelectedFile(file);
        }
        return obj instanceof INamedElement ? (ne = (INamedElement)obj) : null;
    }

    private static INamedElement checkSelectedFile(IFile file) {
        FBType fBType;
        TypeEntry entry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
        if (entry instanceof FBTypeEntry) {
            FBTypeEntry typeEntry = (FBTypeEntry)entry;
            fBType = typeEntry.getType();
        } else {
            fBType = null;
        }
        return fBType;
    }
}

