/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.nattable.formula.function;

import java.math.BigDecimal;
import java.util.List;
import org.eclipse.nebula.widgets.nattable.Messages;
import org.eclipse.nebula.widgets.nattable.formula.function.AbstractMathFunction;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionException;
import org.eclipse.nebula.widgets.nattable.formula.function.FunctionValue;

public class ModFunction
extends AbstractMathFunction {
    public ModFunction() {
    }

    public ModFunction(List<FunctionValue> values) {
        super(values);
        if (values.size() > 2) {
            throw new FunctionException("#N/A", Messages.getString("FormulaParser.error.wrongNumberOfArguments", 2, values.size()));
        }
    }

    @Override
    public BigDecimal getValue() {
        if (this.values.size() != 2) {
            throw new FunctionException("#N/A", Messages.getString("FormulaParser.error.wrongNumberOfArguments", 2, this.values.size()));
        }
        BigDecimal number = this.convertValue(((FunctionValue)this.values.get(0)).getValue());
        BigDecimal divisor = this.convertValue(((FunctionValue)this.values.get(1)).getValue());
        if (BigDecimal.ZERO.equals(divisor)) {
            throw new FunctionException("#DIV/0!", Messages.getString("FormulaParser.error.divisionByZero"));
        }
        return number.remainder(divisor);
    }

    public String toString() {
        if (this.isEmpty()) {
            return "%";
        }
        if (this.values.size() == 1) {
            return String.valueOf(this.values.get(0)) + " %";
        }
        return String.valueOf(this.values.get(0)) + " % " + String.valueOf(this.values.get(1));
    }
}

