/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm4e.languageconfiguration.internal.preferences;

import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.tm4e.core.internal.utils.NullSafetyHelper;
import org.eclipse.tm4e.languageconfiguration.LanguageConfigurationPlugin;
import org.eclipse.tm4e.languageconfiguration.internal.LanguageConfigurationMessages;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationDefinition;
import org.eclipse.tm4e.languageconfiguration.internal.registry.ILanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.registry.LanguageConfigurationRegistryManager;
import org.eclipse.tm4e.languageconfiguration.internal.widgets.LanguageConfigurationPreferencesWidget;
import org.eclipse.tm4e.languageconfiguration.internal.wizards.LanguageConfigurationImportWizard;
import org.eclipse.tm4e.ui.internal.preferences.AbstractPreferencePage;
import org.eclipse.tm4e.ui.internal.widgets.TableWidget;
import org.eclipse.tm4e.ui.internal.widgets.TableWithControlsWidget;
import org.osgi.service.prefs.BackingStoreException;

public final class LanguageConfigurationPreferencePage
extends AbstractPreferencePage {
    static final String PAGE_ID = "org.eclipse.tm4e.languageconfiguration.preferences.LanguageConfigurationPreferencePage";
    private ILanguageConfigurationRegistryManager.EditSession manager = LanguageConfigurationRegistryManager.getInstance().newEditSession();
    private TableWidget<ILanguageConfigurationDefinition> langCfgsTable = (TableWidget)NullSafetyHelper.lazyNonNull();

    public LanguageConfigurationPreferencePage() {
        super(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_title, LanguageConfigurationMessages.LanguageConfigurationPreferencePage_description);
    }

    protected Control createContents(@NonNullByDefault(value={}) Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)GridLayoutFactory.fillDefaults().create());
        this.createLanguageConfigsTable(control);
        LanguageConfigurationPreferencesWidget infoWidget = new LanguageConfigurationPreferencesWidget(control, 0);
        infoWidget.setLayoutData(GridDataFactory.fillDefaults().create());
        Dialog.applyDialogFont((Control)control);
        this.langCfgsTable.onSelectionChanged(selectedDefinitions -> infoWidget.refresh(selectedDefinitions.isEmpty() ? null : (ILanguageConfigurationDefinition)selectedDefinitions.get(0), this.manager));
        this.langCfgsTable.setInput((Object)this.manager);
        return control;
    }

    private void createLanguageConfigsTable(Composite parent) {
        TableWithControlsWidget<ILanguageConfigurationDefinition> tableWithControls = new TableWithControlsWidget<ILanguageConfigurationDefinition>(parent, LanguageConfigurationMessages.LanguageConfigurationPreferencePage_description2, true){

            protected TableWidget<ILanguageConfigurationDefinition> createTable(Composite parent) {
                return new TableWidget<ILanguageConfigurationDefinition>(parent, false){

                    protected void createColumns() {
                        this.createAutoResizeColumn(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_column_contentTypeName, new int[]{1});
                        this.createAutoResizeColumn(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_column_contentTypeId, new int[]{2});
                        this.createAutoResizeColumn(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_column_source, new int[]{1});
                    }

                    protected @Nullable String getColumnText(ILanguageConfigurationDefinition def, int columnIndex) {
                        return switch (columnIndex) {
                            case 0 -> def.getContentType().getName();
                            case 1 -> def.getContentType().getId();
                            case 2 -> (String)(def.getPluginId() == null ? "" : def.getPluginId() + " > ") + def.getPath();
                            default -> null;
                        };
                    }

                    protected Object[] getElements(@Nullable Object input) {
                        if (input instanceof ILanguageConfigurationRegistryManager) {
                            ILanguageConfigurationRegistryManager manager = (ILanguageConfigurationRegistryManager)input;
                            return manager.getDefinitions();
                        }
                        return super.getElements(input);
                    }
                };
            }

            protected void createButtons() {
                this.createButton(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_button_add, () -> {
                    LanguageConfigurationImportWizard wizard = new LanguageConfigurationImportWizard(LanguageConfigurationPreferencePage.this.manager, false);
                    WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
                    if (dialog.open() == 0) {
                        ILanguageConfigurationDefinition newLangCfgDef = wizard.getCreatedDefinition();
                        this.table.refresh();
                        this.table.setSelection(true, (Object[])new ILanguageConfigurationDefinition[]{newLangCfgDef});
                    }
                });
                Button removeBtn = this.createButton(LanguageConfigurationMessages.LanguageConfigurationPreferencePage_button_remove, () -> {
                    ILanguageConfigurationDefinition langCfgDef = (ILanguageConfigurationDefinition)this.table.getFirstSelectedElement();
                    if (langCfgDef != null && langCfgDef.getPluginId() == null) {
                        LanguageConfigurationPreferencePage.this.manager.unregisterLanguageConfigurationDefinition(langCfgDef);
                        this.table.refresh();
                    }
                });
                this.table.onSelectionChanged(sel -> removeBtn.setEnabled(!sel.isEmpty() && ((ILanguageConfigurationDefinition)sel.get(0)).getPluginId() == null));
            }
        };
        tableWithControls.setLayoutData((Object)GridDataFactory.fillDefaults().align(4, 4).grab(true, true).hint(360, this.convertHeightInCharsToPixels(10)).create());
        this.langCfgsTable = tableWithControls.getTable();
    }

    protected void performDefaults() {
        this.manager = LanguageConfigurationRegistryManager.getInstance().newEditSession();
        this.langCfgsTable.setInput((Object)this.manager);
    }

    public boolean performOk() {
        try {
            this.manager.save();
        }
        catch (BackingStoreException ex) {
            LanguageConfigurationPlugin.logError((Exception)((Object)ex));
            return false;
        }
        return super.performOk();
    }
}

