/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser.builder;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.ImageAttributes;
import org.eclipse.mylyn.wikitext.parser.LinkAttributes;
import org.eclipse.mylyn.wikitext.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.parser.QuoteAttributes;
import org.eclipse.mylyn.wikitext.parser.TableAttributes;
import org.eclipse.mylyn.wikitext.parser.TableCellAttributes;
import org.eclipse.mylyn.wikitext.parser.TableRowAttributes;
import org.eclipse.mylyn.wikitext.parser.builder.AbstractXmlDocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlDocumentHandler;
import org.eclipse.mylyn.wikitext.parser.builder.HtmlEntities;
import org.eclipse.mylyn.wikitext.parser.builder.Messages;
import org.eclipse.mylyn.wikitext.parser.builder.UriProcessor;
import org.eclipse.mylyn.wikitext.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.util.FormattingXMLStreamWriter;
import org.eclipse.mylyn.wikitext.util.Preconditions;
import org.eclipse.mylyn.wikitext.util.XmlStreamWriter;

public class HtmlDocumentBuilder
extends AbstractXmlDocumentBuilder {
    private static final Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("[a-zA-Z]{3,8}://?.*");
    private static final Map<DocumentBuilder.SpanType, String> defaultSpanTypeToElementName = Map.ofEntries(Map.entry(DocumentBuilder.SpanType.LINK, "a"), Map.entry(DocumentBuilder.SpanType.BOLD, "b"), Map.entry(DocumentBuilder.SpanType.CITATION, "cite"), Map.entry(DocumentBuilder.SpanType.ITALIC, "i"), Map.entry(DocumentBuilder.SpanType.EMPHASIS, "em"), Map.entry(DocumentBuilder.SpanType.STRONG, "strong"), Map.entry(DocumentBuilder.SpanType.DELETED, "del"), Map.entry(DocumentBuilder.SpanType.INSERTED, "ins"), Map.entry(DocumentBuilder.SpanType.QUOTE, "q"), Map.entry(DocumentBuilder.SpanType.UNDERLINED, "u"), Map.entry(DocumentBuilder.SpanType.SUPERSCRIPT, "sup"), Map.entry(DocumentBuilder.SpanType.SUBSCRIPT, "sub"), Map.entry(DocumentBuilder.SpanType.SPAN, "span"), Map.entry(DocumentBuilder.SpanType.CODE, "code"), Map.entry(DocumentBuilder.SpanType.MONOSPACE, "tt"), Map.entry(DocumentBuilder.SpanType.MARK, "mark"));
    private static final Map<DocumentBuilder.BlockType, ElementInfo> blockTypeToElementInfo = Map.ofEntries(Map.entry(DocumentBuilder.BlockType.BULLETED_LIST, new ElementInfo("ul")), Map.entry(DocumentBuilder.BlockType.CODE, new ElementInfo("pre", null, null, new ElementInfo("code"))), Map.entry(DocumentBuilder.BlockType.DIV, new ElementInfo("div")), Map.entry(DocumentBuilder.BlockType.FOOTNOTE, new ElementInfo("footnote")), Map.entry(DocumentBuilder.BlockType.LIST_ITEM, new ElementInfo("li")), Map.entry(DocumentBuilder.BlockType.NUMERIC_LIST, new ElementInfo("ol")), Map.entry(DocumentBuilder.BlockType.DEFINITION_LIST, new ElementInfo("dl")), Map.entry(DocumentBuilder.BlockType.DEFINITION_TERM, new ElementInfo("dt")), Map.entry(DocumentBuilder.BlockType.DEFINITION_ITEM, new ElementInfo("dd")), Map.entry(DocumentBuilder.BlockType.PARAGRAPH, new ElementInfo("p")), Map.entry(DocumentBuilder.BlockType.PREFORMATTED, new ElementInfo("pre")), Map.entry(DocumentBuilder.BlockType.QUOTE, new ElementInfo("blockquote")), Map.entry(DocumentBuilder.BlockType.TABLE, new ElementInfo("table")), Map.entry(DocumentBuilder.BlockType.TABLE_CELL_HEADER, new ElementInfo("th")), Map.entry(DocumentBuilder.BlockType.TABLE_CELL_NORMAL, new ElementInfo("td")), Map.entry(DocumentBuilder.BlockType.TABLE_ROW, new ElementInfo("tr")), Map.entry(DocumentBuilder.BlockType.TIP, new ElementInfo("div", "tip", "border: 1px solid #090;background-color: #dfd;margin: 20px;padding: 0px 6px 0px 6px;")), Map.entry(DocumentBuilder.BlockType.WARNING, new ElementInfo("div", "warning", "border: 1px solid #c00;background-color: #fcc;margin: 20px;padding: 0px 6px 0px 6px;")), Map.entry(DocumentBuilder.BlockType.INFORMATION, new ElementInfo("div", "info", "border: 1px solid #3c78b5;background-color: #D8E4F1;margin: 20px;padding: 0px 6px 0px 6px;")), Map.entry(DocumentBuilder.BlockType.NOTE, new ElementInfo("div", "note", "border: 1px solid #F0C000;background-color: #FFFFCE;margin: 20px;padding: 0px 6px 0px 6px;")), Map.entry(DocumentBuilder.BlockType.PANEL, new ElementInfo("div", "panel", "border: 1px solid #ccc;background-color: #FFFFCE;margin: 10px;padding: 0px 6px 0px 6px;")));
    private Map<DocumentBuilder.SpanType, String> spanTypeToElementName = Map.copyOf(defaultSpanTypeToElementName);
    private String htmlNsUri = "http://www.w3.org/1999/xhtml";
    private String htmlDtd = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private boolean xhtmlStrict = false;
    private boolean emitAsDocument = true;
    private boolean emitDtd = false;
    private String encoding = "utf-8";
    private String title;
    private String defaultAbsoluteLinkTarget;
    private List<Stylesheet> stylesheets = null;
    private boolean useInlineStyles = true;
    private boolean suppressBuiltInStyles = false;
    private String linkRel;
    private String prependImagePrefix;
    private boolean filterEntityReferences = false;
    private String copyrightNotice;
    private String htmlFilenameFormat = null;
    private HtmlDocumentHandler documentHandler = new DefaultDocumentHandler();
    private final Stack<ElementInfo> blockState = new Stack();
    private List<UriProcessor> linkUriProcessors = this.defaultLinkUriProcessors();

    public HtmlDocumentBuilder(Writer out) {
        this(out, false);
    }

    public HtmlDocumentBuilder(Writer out, boolean formatting) {
        super(formatting ? HtmlDocumentBuilder.createFormattingXmlStreamWriter(out) : new DefaultXmlStreamWriter(out));
    }

    public HtmlDocumentBuilder(XmlStreamWriter writer) {
        super(writer);
    }

    public void copyConfiguration(HtmlDocumentBuilder other) {
        other.setBase(this.getBase());
        other.setBaseInHead(this.isBaseInHead());
        other.setDefaultAbsoluteLinkTarget(this.getDefaultAbsoluteLinkTarget());
        other.setEmitAsDocument(this.isEmitAsDocument());
        other.setEmitDtd(this.isEmitDtd());
        other.setHtmlDtd(this.getHtmlDtd());
        other.setHtmlNsUri(this.getHtmlNsUri());
        other.setLinkRel(this.getLinkRel());
        other.setTitle(this.getTitle());
        other.setUseInlineStyles(this.isUseInlineStyles());
        other.setSuppressBuiltInStyles(this.isSuppressBuiltInStyles());
        other.setXhtmlStrict(this.xhtmlStrict);
        other.setPrependImagePrefix(this.prependImagePrefix);
        other.setCopyrightNotice(this.getCopyrightNotice());
        other.setHtmlFilenameFormat(this.htmlFilenameFormat);
        other.spanTypeToElementName = this.spanTypeToElementName;
        this.copyLinkProcessors(other);
        if (this.stylesheets != null) {
            other.stylesheets = new ArrayList<Stylesheet>();
            other.stylesheets.addAll(this.stylesheets);
        }
    }

    public void addLinkUriProcessor(UriProcessor processor) {
        Objects.requireNonNull(processor, "Must provide processor");
        this.linkUriProcessors = Stream.concat(this.linkUriProcessors.stream(), Stream.of(processor)).collect(Collectors.toUnmodifiableList());
    }

    protected static XmlStreamWriter createFormattingXmlStreamWriter(Writer out) {
        return new FormattingXMLStreamWriter(new DefaultXmlStreamWriter(out)){

            @Override
            protected boolean preserveWhitespace(String elementName) {
                return elementName.equals("pre") || elementName.equals("code");
            }
        };
    }

    public void setElementNameOfSpanType(DocumentBuilder.SpanType spanType, String elementName) {
        Objects.requireNonNull(spanType, "Must provide spanType");
        Objects.requireNonNull(elementName, "Must provide elementName");
        HashMap<DocumentBuilder.SpanType, String> builder = new HashMap<DocumentBuilder.SpanType, String>();
        for (Map.Entry<DocumentBuilder.SpanType, String> entry : this.spanTypeToElementName.entrySet()) {
            if (entry.getKey().equals((Object)spanType)) continue;
            builder.put(entry.getKey(), entry.getValue());
        }
        builder.put(spanType, elementName);
        this.spanTypeToElementName = Map.copyOf(builder);
    }

    public String getHtmlNsUri() {
        return this.htmlNsUri;
    }

    public void setHtmlNsUri(String htmlNsUri) {
        this.htmlNsUri = htmlNsUri;
    }

    public String getHtmlDtd() {
        return this.htmlDtd;
    }

    public void setHtmlDtd(String htmlDtd) {
        this.htmlDtd = htmlDtd;
    }

    public boolean isEmitAsDocument() {
        return this.emitAsDocument;
    }

    public void setEmitAsDocument(boolean emitAsDocument) {
        this.emitAsDocument = emitAsDocument;
    }

    public boolean isEmitDtd() {
        return this.emitDtd;
    }

    public void setEmitDtd(boolean emitDtd) {
        this.emitDtd = emitDtd;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDefaultAbsoluteLinkTarget() {
        return this.defaultAbsoluteLinkTarget;
    }

    public void setDefaultAbsoluteLinkTarget(String defaultAbsoluteLinkTarget) {
        this.defaultAbsoluteLinkTarget = defaultAbsoluteLinkTarget;
    }

    public boolean isXhtmlStrict() {
        return this.xhtmlStrict;
    }

    public void setXhtmlStrict(boolean xhtmlStrict) {
        this.xhtmlStrict = xhtmlStrict;
    }

    @Deprecated
    public void addCssStylesheet(String url) {
        this.addCssStylesheet(new Stylesheet(url));
    }

    @Deprecated
    public void addCssStylesheet(File file) {
        this.addCssStylesheet(new Stylesheet(file));
    }

    public void addCssStylesheet(Stylesheet stylesheet) {
        if (stylesheet.file != null) {
            this.checkFileReadable(stylesheet.file);
        }
        if (this.stylesheets == null) {
            this.stylesheets = new ArrayList<Stylesheet>();
        }
        this.stylesheets.add(stylesheet);
    }

    protected void checkFileReadable(File file) {
        if (!file.exists()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.3"), file));
        }
        if (!file.isFile()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.1"), file));
        }
        if (!file.canRead()) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.2"), file));
        }
    }

    public boolean isUseInlineStyles() {
        return this.useInlineStyles;
    }

    public void setUseInlineStyles(boolean useInlineStyles) {
        this.useInlineStyles = useInlineStyles;
    }

    public boolean isSuppressBuiltInStyles() {
        return this.suppressBuiltInStyles;
    }

    public void setSuppressBuiltInStyles(boolean suppressBuiltInStyles) {
        this.suppressBuiltInStyles = suppressBuiltInStyles;
    }

    public String getLinkRel() {
        return this.linkRel;
    }

    public void setLinkRel(String linkRel) {
        this.linkRel = linkRel;
    }

    public void setDocumentHandler(HtmlDocumentHandler documentHandler) {
        this.documentHandler = Objects.requireNonNull(documentHandler, "Must provide a documentHandler");
    }

    @Override
    public void beginDocument() {
        this.writer.setDefaultNamespace(this.htmlNsUri);
        this.documentHandler.beginDocument(this, this.writer);
    }

    protected void emitHead() {
        this.writer.writeStartElement(this.htmlNsUri, "head");
        this.emitHeadContents();
        this.writer.writeEndElement();
    }

    protected void emitHeadContents() {
        if (this.encoding != null && this.encoding.length() > 0) {
            this.writer.writeEmptyElement(this.htmlNsUri, "meta");
            this.writer.writeAttribute("http-equiv", "Content-Type");
            this.writer.writeAttribute("content", String.format("text/html; charset=%s", this.encoding));
        }
        if (this.copyrightNotice != null) {
            this.writer.writeEmptyElement(this.htmlNsUri, "meta");
            this.writer.writeAttribute("name", "copyright");
            this.writer.writeAttribute("content", this.copyrightNotice);
        }
        if (this.base != null && this.baseInHead) {
            this.writer.writeEmptyElement(this.htmlNsUri, "base");
            this.writer.writeAttribute("href", this.base.toString());
        }
        if (this.title != null) {
            this.writer.writeStartElement(this.htmlNsUri, "title");
            this.writer.writeCharacters(this.title);
            this.writer.writeEndElement();
        }
        if (!this.useInlineStyles && !this.suppressBuiltInStyles) {
            this.writer.writeStartElement(this.htmlNsUri, "style");
            this.writer.writeAttribute("type", "text/css");
            this.writer.writeCharacters("\n");
            for (Map.Entry entry : blockTypeToElementInfo.entrySet()) {
                ElementInfo elementInfo = (ElementInfo)entry.getValue();
                while (elementInfo != null) {
                    if (elementInfo.cssStyles != null && elementInfo.cssClass != null) {
                        String[] classes;
                        String[] stringArray = classes = elementInfo.cssClass.split("\\s+");
                        int n = classes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String cssClass = stringArray[n2];
                            this.writer.writeCharacters(".");
                            this.writer.writeCharacters(cssClass);
                            this.writer.writeCharacters(" ");
                            ++n2;
                        }
                        this.writer.writeCharacters("{");
                        this.writer.writeCharacters(elementInfo.cssStyles);
                        this.writer.writeCharacters("}\n");
                    }
                    elementInfo = elementInfo.next;
                }
            }
            this.writer.writeEndElement();
        }
        if (this.stylesheets != null) {
            for (Stylesheet stylesheet : this.stylesheets) {
                this.emitStylesheet(stylesheet);
            }
        }
    }

    private void emitStylesheet(Stylesheet stylesheet) {
        if (stylesheet.url != null) {
            this.writer.writeEmptyElement(this.htmlNsUri, "link");
            this.writer.writeAttribute("type", "text/css");
            this.writer.writeAttribute("rel", "stylesheet");
            this.writer.writeAttribute("href", this.makeUrlAbsolute(stylesheet.url));
            for (Map.Entry<String, String> attr : stylesheet.attributes.entrySet()) {
                String attrName = attr.getKey();
                if ("type".equals(attrName) || "rel".equals(attrName) || "href".equals(attrName)) continue;
                this.writer.writeAttribute(attrName, attr.getValue());
            }
        } else {
            String css;
            this.writer.writeStartElement(this.htmlNsUri, "style");
            this.writer.writeAttribute("type", "text/css");
            for (Map.Entry<String, String> attr : stylesheet.attributes.entrySet()) {
                String attrName = attr.getKey();
                if ("type".equals(attrName)) continue;
                this.writer.writeAttribute(attrName, attr.getValue());
            }
            if (stylesheet.file != null) {
                try {
                    css = this.readFully(stylesheet.file);
                }
                catch (IOException e) {
                    throw new IllegalStateException(MessageFormat.format(Messages.getString("HtmlDocumentBuilder.4"), stylesheet.file), e);
                }
            }
            try {
                css = this.readFully(stylesheet.reader, 1024);
            }
            catch (IOException e) {
                throw new IllegalStateException(Messages.getString("HtmlDocumentBuilder.5"), e);
            }
            this.writer.writeCharacters(css);
            this.writer.writeEndElement();
        }
    }

    @Override
    public void endDocument() {
        this.documentHandler.endDocument(this, this.writer);
        this.writer.close();
    }

    protected void beginBody() {
        this.writer.writeStartElement(this.htmlNsUri, "body");
    }

    protected void endBody() {
        this.writer.writeEndElement();
    }

    @Override
    public void entityReference(String entity) {
        if (!this.filterEntityReferences || entity.isEmpty() || entity.charAt(0) == '#') {
            this.writer.writeEntityRef(entity);
        } else {
            List<String> emitEntity = HtmlEntities.instance().nameToEntityReferences(entity);
            if (emitEntity.isEmpty()) {
                this.writer.writeCharacters("&");
                this.writer.writeCharacters(entity);
                this.writer.writeCharacters(";");
            } else {
                for (String numericEntity : emitEntity) {
                    this.writer.writeEntityRef(numericEntity);
                }
            }
        }
    }

    @Override
    public void acronym(String text, String definition) {
        this.writer.writeStartElement(this.htmlNsUri, "acronym");
        this.writer.writeAttribute("title", definition);
        this.writer.writeCharacters(text);
        this.writer.writeEndElement();
    }

    @Override
    public void link(Attributes attributes, String hrefOrHashName, String text) {
        this.writer.writeStartElement(this.htmlNsUri, this.spanTypeToElementName.get((Object)DocumentBuilder.SpanType.LINK));
        this.emitAnchorHref(hrefOrHashName);
        this.applyLinkAttributes(attributes, hrefOrHashName);
        this.characters(text);
        this.writer.writeEndElement();
    }

    @Override
    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        ElementInfo elementInfo = blockTypeToElementInfo.get((Object)type);
        if (elementInfo == null) {
            throw new IllegalStateException(type.name());
        }
        this.writeBlockElements(attributes, elementInfo);
        this.blockState.push(elementInfo);
        if (type == DocumentBuilder.BlockType.TABLE) {
            this.applyTableAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.TABLE_ROW) {
            this.applyTableRowAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.TABLE_CELL_HEADER || type == DocumentBuilder.BlockType.TABLE_CELL_NORMAL) {
            this.applyCellAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.BULLETED_LIST || type == DocumentBuilder.BlockType.NUMERIC_LIST) {
            this.applyListAttributes(attributes);
        } else if (type == DocumentBuilder.BlockType.QUOTE) {
            this.applyQuoteAttributes(attributes);
        } else {
            this.applyAttributes(attributes);
            if (attributes.getTitle() != null) {
                this.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
                this.beginSpan(DocumentBuilder.SpanType.BOLD, new Attributes());
                this.characters(attributes.getTitle());
                this.endSpan();
                this.endBlock();
            }
        }
    }

    private void writeBlockElements(Attributes attributes, ElementInfo elementInfo) {
        this.writer.writeStartElement(this.htmlNsUri, elementInfo.name);
        String originalCssClasses = attributes.getCssClass();
        if (elementInfo.cssClass != null) {
            attributes.appendCssClass(elementInfo.cssClass);
        }
        if (this.useInlineStyles && !this.suppressBuiltInStyles && elementInfo.cssStyles != null) {
            attributes.appendCssStyle(elementInfo.cssStyles);
        }
        if (elementInfo.next != null) {
            if (originalCssClasses != null) {
                this.writer.writeAttribute("class", originalCssClasses);
            }
            Attributes childAttributes = new Attributes();
            childAttributes.setCssClass(originalCssClasses);
            this.writeBlockElements(childAttributes, elementInfo.next);
        }
    }

    @Override
    public void beginHeading(int level, Attributes attributes) {
        if (level > 6) {
            level = 6;
        }
        this.writer.writeStartElement(this.htmlNsUri, "h" + level);
        this.applyAttributes(attributes);
    }

    @Override
    public void beginSpan(DocumentBuilder.SpanType type, Attributes attributes) {
        String elementName = this.spanTypeToElementName.get((Object)type);
        if (elementName == null) {
            throw new IllegalStateException(type.name());
        }
        this.writer.writeStartElement(this.htmlNsUri, elementName);
        if (type == DocumentBuilder.SpanType.LINK && attributes instanceof LinkAttributes) {
            String href = ((LinkAttributes)attributes).getHref();
            this.emitAnchorHref(href);
            this.applyLinkAttributes(attributes, href);
        } else {
            this.applyAttributes(attributes);
        }
    }

    @Override
    public void endBlock() {
        ElementInfo elementInfo = this.blockState.pop();
        int x = 0;
        while (x < elementInfo.size()) {
            this.writer.writeEndElement();
            ++x;
        }
    }

    @Override
    public void endHeading() {
        this.writer.writeEndElement();
    }

    @Override
    public void endSpan() {
        this.writer.writeEndElement();
    }

    @Override
    public void image(Attributes attributes, String url) {
        this.writer.writeEmptyElement(this.htmlNsUri, "img");
        this.applyImageAttributes(attributes);
        url = this.prependImageUrl(url);
        this.writer.writeAttribute("src", this.makeUrlAbsolute(url));
    }

    private void applyListAttributes(Attributes attributes) {
        ListAttributes listAttributes;
        this.applyAttributes(attributes);
        if (attributes instanceof ListAttributes && (listAttributes = (ListAttributes)attributes).getStart() != null) {
            this.writer.writeAttribute("start", listAttributes.getStart());
        }
    }

    private void applyQuoteAttributes(Attributes attributes) {
        QuoteAttributes quoteAttributes;
        this.applyAttributes(attributes);
        if (attributes instanceof QuoteAttributes && (quoteAttributes = (QuoteAttributes)attributes).getCitation() != null) {
            this.writer.writeAttribute("cite", quoteAttributes.getCitation());
        }
    }

    private void applyTableAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableAttributes) {
            TableAttributes tableAttributes = (TableAttributes)attributes;
            if (tableAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableAttributes.getBgcolor());
            }
            if (tableAttributes.getBorder() != null) {
                this.writer.writeAttribute("border", tableAttributes.getBorder());
            }
            if (tableAttributes.getAlign() != null) {
                this.writer.writeAttribute("align", tableAttributes.getAlign());
            }
            if (tableAttributes.getCellpadding() != null) {
                this.writer.writeAttribute("cellpadding", tableAttributes.getCellpadding());
            }
            if (tableAttributes.getCellspacing() != null) {
                this.writer.writeAttribute("cellspacing", tableAttributes.getCellspacing());
            }
            if (tableAttributes.getFrame() != null) {
                this.writer.writeAttribute("frame", tableAttributes.getFrame());
            }
            if (tableAttributes.getRules() != null) {
                this.writer.writeAttribute("rules", tableAttributes.getRules());
            }
            if (tableAttributes.getSummary() != null) {
                this.writer.writeAttribute("summary", tableAttributes.getSummary());
            }
            if (tableAttributes.getWidth() != null) {
                this.writer.writeAttribute("width", tableAttributes.getWidth());
            }
        }
    }

    private void applyTableRowAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableRowAttributes) {
            TableRowAttributes tableRowAttributes = (TableRowAttributes)attributes;
            if (tableRowAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableRowAttributes.getBgcolor());
            }
            if (tableRowAttributes.getAlign() != null) {
                this.writer.writeAttribute("align", tableRowAttributes.getAlign());
            }
            if (tableRowAttributes.getValign() != null) {
                this.writer.writeAttribute("valign", tableRowAttributes.getValign());
            }
        }
    }

    private void applyCellAttributes(Attributes attributes) {
        this.applyAttributes(attributes);
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (attributes instanceof TableCellAttributes) {
            TableCellAttributes tableCellAttributes = (TableCellAttributes)attributes;
            if (tableCellAttributes.getScope() != null) {
                this.writer.writeAttribute("scope", tableCellAttributes.getScope());
            }
            if (tableCellAttributes.getBgcolor() != null) {
                this.writer.writeAttribute("bgcolor", tableCellAttributes.getBgcolor());
            }
            if (tableCellAttributes.getAlign() != null) {
                this.writer.writeAttribute("align", tableCellAttributes.getAlign());
            }
            if (tableCellAttributes.getValign() != null) {
                this.writer.writeAttribute("valign", tableCellAttributes.getValign());
            }
            if (tableCellAttributes.getRowspan() != null) {
                this.writer.writeAttribute("rowspan", tableCellAttributes.getRowspan());
            }
            if (tableCellAttributes.getColspan() != null) {
                this.writer.writeAttribute("colspan", tableCellAttributes.getColspan());
            }
        }
    }

    private void applyImageAttributes(Attributes attributes) {
        int border = 0;
        ImageAttributes.Align align = null;
        if (attributes instanceof ImageAttributes) {
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            border = imageAttributes.getBorder();
            align = imageAttributes.getAlign();
        }
        if (this.xhtmlStrict) {
            String borderStyle = String.format("border-width: %spx;", border);
            String alignStyle = null;
            if (align != null) {
                alignStyle = switch (align) {
                    case ImageAttributes.Align.Left, ImageAttributes.Align.Right, ImageAttributes.Align.Center -> "text-align: " + align.name().toLowerCase() + ";";
                    case ImageAttributes.Align.Top, ImageAttributes.Align.Middle, ImageAttributes.Align.Baseline, ImageAttributes.Align.Bottom -> "vertical-align: " + align.name().toLowerCase() + ";";
                    case ImageAttributes.Align.Texttop -> "vertical-align: text-top;";
                    case ImageAttributes.Align.Absmiddle -> "vertical-align: middle;";
                    case ImageAttributes.Align.Absbottom -> "vertical-align: bottom;";
                    default -> throw new IncompatibleClassChangeError();
                };
            }
            Object additionalStyles = borderStyle;
            if (alignStyle != null) {
                additionalStyles = (String)additionalStyles + alignStyle;
            }
            if (attributes.getCssStyle() == null || attributes.getCssStyle().length() == 0) {
                attributes.setCssStyle((String)additionalStyles);
            } else {
                attributes.setCssStyle((String)additionalStyles + attributes.getCssStyle());
            }
        }
        this.applyAttributes(attributes);
        boolean haveAlt = false;
        if (attributes instanceof ImageAttributes) {
            Object val;
            ImageAttributes imageAttributes = (ImageAttributes)attributes;
            if (imageAttributes.getHeight() != -1) {
                val = Integer.toString(imageAttributes.getHeight());
                if (imageAttributes.isHeightPercentage()) {
                    val = (String)val + "%";
                }
                this.writer.writeAttribute("height", (String)val);
            }
            if (imageAttributes.getWidth() != -1) {
                val = Integer.toString(imageAttributes.getWidth());
                if (imageAttributes.isWidthPercentage()) {
                    val = (String)val + "%";
                }
                this.writer.writeAttribute("width", (String)val);
            }
            if (!this.xhtmlStrict && align != null) {
                this.writer.writeAttribute("align", align.name().toLowerCase());
            }
            if (imageAttributes.getAlt() != null) {
                haveAlt = true;
                this.writer.writeAttribute("alt", imageAttributes.getAlt());
            }
        }
        if (attributes.getTitle() != null) {
            this.writer.writeAttribute("title", attributes.getTitle());
            if (!haveAlt) {
                haveAlt = true;
                this.writer.writeAttribute("alt", attributes.getTitle());
            }
        }
        if (this.xhtmlStrict) {
            if (!haveAlt) {
                this.writer.writeAttribute("alt", "");
            }
        } else {
            this.writer.writeAttribute("border", Integer.toString(border));
        }
    }

    private void applyLinkAttributes(Attributes attributes, String href) {
        this.applyAttributes(attributes);
        boolean hasTarget = false;
        String rel = this.linkRel;
        if (attributes instanceof LinkAttributes) {
            LinkAttributes linkAttributes = (LinkAttributes)attributes;
            if (linkAttributes.getTarget() != null) {
                hasTarget = true;
                this.writer.writeAttribute("target", linkAttributes.getTarget());
            }
            if (linkAttributes.getRel() != null) {
                String string = rel = rel == null ? linkAttributes.getRel() : linkAttributes.getRel() + " " + rel;
            }
        }
        if (attributes.getTitle() != null && attributes.getTitle().length() > 0) {
            this.writer.writeAttribute("title", attributes.getTitle());
        }
        if (!hasTarget && this.defaultAbsoluteLinkTarget != null && href != null && this.isExternalLink(href)) {
            this.writer.writeAttribute("target", this.defaultAbsoluteLinkTarget);
            hasTarget = true;
        }
        if (!hasTarget) {
            this.linkUriProcessors.stream().map(s -> s.target(href)).filter(Objects::nonNull).findFirst().ifPresent(target -> this.writer.writeAttribute("target", (String)target));
        }
        if (rel != null) {
            this.writer.writeAttribute("rel", rel);
        }
    }

    private void applyAttributes(Attributes attributes) {
        if (attributes.getId() != null) {
            this.writer.writeAttribute("id", attributes.getId());
        }
        if (attributes.getCssClass() != null) {
            this.writer.writeAttribute("class", attributes.getCssClass());
        }
        if (attributes.getCssStyle() != null) {
            this.writer.writeAttribute("style", attributes.getCssStyle());
        }
        if (attributes.getLanguage() != null) {
            this.writer.writeAttribute("lang", attributes.getLanguage());
        }
    }

    @Override
    public void imageLink(Attributes linkAttributes, Attributes imageAttributes, String href, String imageUrl) {
        this.writer.writeStartElement(this.htmlNsUri, "a");
        this.emitAnchorHref(href);
        this.applyLinkAttributes(linkAttributes, href);
        this.writer.writeEmptyElement(this.htmlNsUri, "img");
        this.applyImageAttributes(imageAttributes);
        imageUrl = this.prependImageUrl(imageUrl);
        this.writer.writeAttribute("src", this.makeUrlAbsolute(imageUrl));
        this.writer.writeEndElement();
    }

    protected void emitAnchorHref(String href) {
        if (href != null) {
            String newHref = href;
            for (UriProcessor processor : this.linkUriProcessors) {
                newHref = processor.process(newHref);
            }
            this.writer.writeAttribute("href", newHref);
        }
    }

    private String applyHtmlFilenameFormat(String href) {
        if (this.getHtmlFilenameFormat() != null && this.isMissingFilenameExtension((String)href) && !this.isAbsoluteUrl((String)href)) {
            int indexOfHash = ((String)href).indexOf(35);
            if (indexOfHash > 0) {
                href = this.getHtmlFilenameFormat().replace("$1", ((String)href).substring(0, indexOfHash)) + ((String)href).substring(indexOfHash);
            } else if (indexOfHash == -1) {
                href = this.getHtmlFilenameFormat().replace("$1", (CharSequence)href);
            }
        }
        return href;
    }

    private boolean isAbsoluteUrl(String href) {
        return ABSOLUTE_URL_PATTERN.matcher(href).matches();
    }

    private boolean isMissingFilenameExtension(String href) {
        int lasIndexOfSlash = href.lastIndexOf(47);
        return href.lastIndexOf(46) <= lasIndexOfSlash && lasIndexOfSlash < href.length() - 1;
    }

    public String getHtmlFilenameFormat() {
        return this.htmlFilenameFormat;
    }

    public void setHtmlFilenameFormat(String htmlFilenameFormat) {
        Preconditions.checkArgument(htmlFilenameFormat == null || htmlFilenameFormat.contains("$1"), "The HTML filename format must contain \"$1\"");
        this.htmlFilenameFormat = htmlFilenameFormat;
    }

    private String prependImageUrl(String imageUrl) {
        if (this.prependImagePrefix == null || this.prependImagePrefix.length() == 0 || this.isAbsoluteUrl(imageUrl) || imageUrl.contains("../")) {
            return imageUrl;
        }
        Object url = this.prependImagePrefix;
        if (!this.prependImagePrefix.endsWith("/")) {
            url = (String)url + "/";
        }
        url = (String)url + imageUrl;
        return url;
    }

    @Override
    public void lineBreak() {
        this.writer.writeEmptyElement(this.htmlNsUri, "br");
    }

    @Override
    public void horizontalRule() {
        this.writer.writeEmptyElement(this.htmlNsUri, "hr");
    }

    @Override
    public void charactersUnescaped(String literal) {
        this.writer.writeLiteral(literal);
    }

    private String readFully(File inputFile) throws IOException {
        int length = (int)inputFile.length();
        if (length <= 0) {
            length = 2048;
        }
        return this.readFully(this.getReader(inputFile), length);
    }

    private String readFully(Reader input, int bufferSize) throws IOException {
        StringBuilder buf = new StringBuilder(bufferSize);
        Throwable throwable = null;
        Object var5_6 = null;
        try (BufferedReader reader = new BufferedReader(input);){
            int c;
            while ((c = ((Reader)reader).read()) != -1) {
                buf.append((char)c);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return buf.toString();
    }

    protected Reader getReader(File inputFile) throws FileNotFoundException {
        return new FileReader(inputFile);
    }

    public void setPrependImagePrefix(String prependImagePrefix) {
        this.prependImagePrefix = prependImagePrefix;
    }

    public String getPrependImagePrefix() {
        return this.prependImagePrefix;
    }

    public boolean isFilterEntityReferences() {
        return this.filterEntityReferences;
    }

    public void setFilterEntityReferences(boolean filterEntityReferences) {
        this.filterEntityReferences = filterEntityReferences;
    }

    public String getCopyrightNotice() {
        return this.copyrightNotice;
    }

    public void setCopyrightNotice(String copyrightNotice) {
        this.copyrightNotice = copyrightNotice;
    }

    private void copyLinkProcessors(HtmlDocumentBuilder other) {
        List<UriProcessor> defaultProcessors = other.defaultLinkUriProcessors();
        ArrayList<UriProcessor> newProcs = new ArrayList<UriProcessor>(defaultProcessors);
        if (defaultProcessors.size() < this.linkUriProcessors.size()) {
            newProcs.addAll(this.linkUriProcessors.subList(defaultProcessors.size(), this.linkUriProcessors.size()));
        }
        other.linkUriProcessors = List.copyOf(newProcs);
    }

    private List<UriProcessor> defaultLinkUriProcessors() {
        return List.of(this::applyHtmlFilenameFormat, this::makeUrlAbsolute);
    }

    private class DefaultDocumentHandler
    implements HtmlDocumentHandler {
        private DefaultDocumentHandler() {
        }

        @Override
        public void beginDocument(HtmlDocumentBuilder builder, XmlStreamWriter writer) {
            if (HtmlDocumentBuilder.this.emitAsDocument) {
                if (HtmlDocumentBuilder.this.encoding != null && HtmlDocumentBuilder.this.encoding.length() > 0) {
                    writer.writeStartDocument(HtmlDocumentBuilder.this.encoding, "1.0");
                } else {
                    writer.writeStartDocument();
                }
                if (HtmlDocumentBuilder.this.emitDtd && HtmlDocumentBuilder.this.htmlDtd != null) {
                    writer.writeDTD(HtmlDocumentBuilder.this.htmlDtd);
                }
                if (HtmlDocumentBuilder.this.copyrightNotice != null) {
                    writer.writeComment(HtmlDocumentBuilder.this.copyrightNotice);
                }
                writer.writeStartElement(HtmlDocumentBuilder.this.htmlNsUri, "html");
                writer.writeDefaultNamespace(HtmlDocumentBuilder.this.htmlNsUri);
                HtmlDocumentBuilder.this.emitHead();
                HtmlDocumentBuilder.this.beginBody();
            } else if (HtmlDocumentBuilder.this.stylesheets != null && !HtmlDocumentBuilder.this.stylesheets.isEmpty()) {
                throw new IllegalStateException(Messages.getString("HtmlDocumentBuilder.0"));
            }
        }

        @Override
        public void endDocument(HtmlDocumentBuilder builder, XmlStreamWriter writer) {
            if (HtmlDocumentBuilder.this.emitAsDocument) {
                HtmlDocumentBuilder.this.endBody();
                writer.writeEndElement();
                writer.writeEndDocument();
            }
        }
    }

    private static final class ElementInfo {
        final String name;
        final String cssClass;
        final String cssStyles;
        final ElementInfo next;

        public ElementInfo(String name, String cssClass, String cssStyles) {
            this(name, cssClass, cssStyles, null);
        }

        public ElementInfo(String name, String cssClass, String cssStyles, ElementInfo next) {
            this.name = name;
            this.cssClass = cssClass;
            this.cssStyles = cssStyles != null && !cssStyles.endsWith(";") ? cssStyles + ";" : cssStyles;
            this.next = next;
        }

        public ElementInfo(String name) {
            this(name, null, null);
        }

        public int size() {
            return 1 + (this.next == null ? 0 : this.next.size());
        }
    }

    public static class Stylesheet {
        private final String url;
        private final File file;
        private final Reader reader;
        private final Map<String, String> attributes = new HashMap<String, String>();

        public Stylesheet(File file) {
            if (file == null) {
                throw new IllegalArgumentException();
            }
            this.file = file;
            this.url = null;
            this.reader = null;
        }

        public Stylesheet(String url) {
            if (url == null || url.length() == 0) {
                throw new IllegalArgumentException();
            }
            this.url = url;
            this.file = null;
            this.reader = null;
        }

        public Stylesheet(Reader reader) {
            if (reader == null) {
                throw new IllegalArgumentException();
            }
            this.reader = reader;
            this.file = null;
            this.url = null;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public File getFile() {
            return this.file;
        }

        public String getUrl() {
            return this.url;
        }

        public Reader getReader() {
            return this.reader;
        }
    }
}

