/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.aql.ide.evaluation.writer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Calendar;
import java.util.Collections;
import java.util.Map;
import org.eclipse.acceleo.aql.evaluation.writer.AcceleoURIWriter;
import org.eclipse.acceleo.aql.ide.AcceleoPlugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.codegen.merge.java.JControlModel;
import org.eclipse.emf.codegen.merge.java.JMerger;
import org.eclipse.emf.codegen.merge.java.facade.FacadeHelper;
import org.eclipse.emf.codegen.merge.java.facade.ast.ASTFacadeHelper;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.resource.URIConverter;

public class AcceleoWorkspaceURIWriter
extends AcceleoURIWriter {
    private static final int BUFFER_SIZE = 8192;
    private static final Map<String, Object> EMPTY_OPTION_MAP = Collections.emptyMap();

    public AcceleoWorkspaceURIWriter(URI targetURI, URIConverter uriConverter, Charset charset, String lineDelimiter, Map<URI, String> preview) {
        super(targetURI, uriConverter, charset, lineDelimiter, preview);
    }

    protected String getContent() throws IOException {
        String res = this.uriConverter.exists(this.getTargetURI(), EMPTY_OPTION_MAP) ? this.mergeURIContent(this.getTargetURI(), this.getBuilder(), this.getCharset()) : super.getContent();
        return res;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String mergeURIContent(URI targetURI, StringBuilder stringBuilder, Charset contentCharset) throws IOException {
        String jmergeFile = URI.createPlatformPluginURI((String)"org.eclipse.emf.codegen.ecore/templates/emf-merge.xml", (boolean)false).toString();
        JControlModel model = new JControlModel();
        model.initialize((FacadeHelper)new ASTFacadeHelper(), jmergeFile);
        if (model.canMerge()) {
            Throwable throwable = null;
            Object var7_8 = null;
            try (InputStream existingContent = this.uriConverter.createInputStream(targetURI);){
                String source = stringBuilder.toString();
                try {
                    JMerger jMerger = new JMerger(model);
                    jMerger.setSourceCompilationUnit(jMerger.createCompilationUnitForContents(source));
                    jMerger.setTargetCompilationUnit(jMerger.createCompilationUnitForInputStream(existingContent, contentCharset.toString()));
                    jMerger.merge();
                    return jMerger.getTargetCompilationUnit().getContents();
                }
                catch (WrappedException e) {
                    URI lostURI = targetURI.appendFileExtension("lost");
                    try {
                        this.createLostURI(targetURI, lostURI);
                    }
                    catch (IOException ee) {
                        AcceleoPlugin.getPlugin().log(new Status(2, "org.eclipse.acceleo.aql.ide", "Cannot createlost file " + String.valueOf(lostURI), (Throwable)e));
                    }
                    AcceleoPlugin.getPlugin().log(new Status(2, "org.eclipse.acceleo.aql.ide", "Cannot use JMerge on " + this.getTargetURI().toString(), (Throwable)e));
                    if (existingContent == null) return null;
                    existingContent.close();
                    return null;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                } else {
                    if (throwable == throwable2) throw throwable;
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        AcceleoPlugin.getPlugin().log(new Status(2, "org.eclipse.acceleo.aql.ide", "Cannot find JMerge configuration " + jmergeFile));
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void createLostURI(URI targetURI, URI lostURI) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try {
            InputStream source = this.uriConverter.createInputStream(targetURI);
            try {
                try (OutputStream destination = this.uriConverter.createOutputStream(lostURI);){
                    StringBuilder timestamp = new StringBuilder();
                    timestamp.append(this.getLineDelimiter()).append(Calendar.getInstance().getTime().toString()).append(this.getLineDelimiter());
                    timestamp.append("================================================================================");
                    timestamp.append(this.getLineDelimiter());
                    destination.write(timestamp.toString().getBytes(this.getCharset()));
                    AcceleoWorkspaceURIWriter.copy(source, destination);
                }
                if (source == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (source == null) throw throwable;
                source.close();
                throw throwable;
            }
            source.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    private static void copy(InputStream source, OutputStream sink) throws IOException {
        int n;
        byte[] buf = new byte[8192];
        while ((n = source.read(buf)) > 0) {
            sink.write(buf, 0, n);
        }
    }
}

