/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.query.runtime.impl.completion;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.acceleo.annotations.api.documentation.Documentation;
import org.eclipse.acceleo.annotations.api.documentation.Param;
import org.eclipse.acceleo.annotations.api.documentation.Throw;
import org.eclipse.acceleo.query.parser.AstBuilder;
import org.eclipse.acceleo.query.runtime.IService;
import org.eclipse.acceleo.query.runtime.IServiceCompletionProposal;
import org.eclipse.acceleo.query.runtime.impl.JavaMethodService;
import org.eclipse.acceleo.query.services.CollectionServices;
import org.eclipse.emf.ecore.EClass;

public class JavaMethodServiceCompletionProposal
implements IServiceCompletionProposal {
    private static final String LS = System.getProperty("line.separator");
    private static final String GAP = "        ";
    private final JavaMethodService service;

    public JavaMethodServiceCompletionProposal(JavaMethodService service) {
        this.service = service;
    }

    @Override
    public String getProposal() {
        String res = ((Method)this.service.getOrigin()).getDeclaringClass() == CollectionServices.class ? this.service.getName() + "()" : AstBuilder.protectWithUnderscore(this.service.getName()) + "()";
        return res;
    }

    @Override
    public int getCursorOffset() {
        int length = this.getProposal().length();
        if (this.service.getNumberOfParameters() == 1) {
            return length;
        }
        return length - 1;
    }

    @Override
    public IService<Method> getObject() {
        return this.service;
    }

    public String toString() {
        return this.getProposal();
    }

    @Override
    public String getDescription() {
        StringBuffer buffer = new StringBuffer();
        Method method = (Method)this.service.getOrigin();
        if (method.isAnnotationPresent(Documentation.class)) {
            Documentation documentation = method.getAnnotation(Documentation.class);
            this.appendServiceJavadoc(buffer, documentation);
            this.appendParametersJavadoc(buffer, documentation);
            this.appendResultJavadoc(buffer, documentation);
            this.appendExceptionsJavadoc(buffer, documentation);
        } else {
            buffer.append(this.getServiceSignature(new ArrayList<String>()));
            buffer.append(LS);
        }
        return buffer.toString();
    }

    private void appendServiceJavadoc(StringBuffer buffer, Documentation documentation) {
        ArrayList<String> parameterNames = new ArrayList<String>();
        Param[] params = documentation.params();
        if (params != null) {
            Param[] paramArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Param param = paramArray[n2];
                parameterNames.add(param.name());
                ++n2;
            }
        }
        buffer.append(this.getServiceSignature(parameterNames));
        buffer.append(LS);
        String value = documentation.value();
        buffer.append(LS);
        buffer.append(value).append(LS);
        buffer.append(LS);
    }

    private void appendParametersJavadoc(StringBuffer buffer, Documentation documentation) {
        Param[] params = documentation.params();
        if (params != null && params.length > 0) {
            Param[] paramArray = params;
            int n = params.length;
            int n2 = 0;
            while (n2 < n) {
                Param param = paramArray[n2];
                buffer.append("  @param ");
                buffer.append(param.name()).append(LS);
                buffer.append(GAP);
                buffer.append(param.value()).append(LS);
                ++n2;
            }
            buffer.append(LS);
        }
    }

    private void appendResultJavadoc(StringBuffer buffer, Documentation documentation) {
        String result = documentation.result();
        if (result.length() > 0) {
            buffer.append("  @return").append(LS);
            buffer.append(GAP).append(result).append(LS);
            buffer.append(LS);
        }
    }

    private void appendExceptionsJavadoc(StringBuffer buffer, Documentation documentation) {
        Throw[] exceptions = documentation.exceptions();
        if (exceptions != null && exceptions.length > 0) {
            Throw[] throwArray = exceptions;
            int n = exceptions.length;
            int n2 = 0;
            while (n2 < n) {
                Throw exception = throwArray[n2];
                buffer.append("  @throw ");
                buffer.append(exception.type().getCanonicalName()).append(LS);
                buffer.append(GAP).append(exception.value()).append(LS);
                ++n2;
            }
            buffer.append(LS);
        }
    }

    private StringBuffer getServiceSignature(List<String> parameterNames) {
        StringBuffer result = new StringBuffer();
        result.append(this.service.getName()).append('(');
        boolean first = true;
        Class<?>[] parameterTypes = ((Method)this.service.getOrigin()).getParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            String paramName;
            Class<?> argType = parameterTypes[i];
            if (!first) {
                result.append(", ");
            } else {
                first = false;
            }
            if (parameterNames.size() >= i + 1 && (paramName = parameterNames.get(i)).trim().length() > 0) {
                result.append(paramName);
                result.append(": ");
            }
            if (argType instanceof Class) {
                result.append(argType.getCanonicalName());
            } else if (argType instanceof EClass) {
                result.append("EClass=" + ((EClass)argType).getName());
            } else {
                result.append("Object=" + ((Object)argType).toString());
            }
            ++i;
        }
        result.append(')');
        Class<?> returnType = ((Method)this.service.getOrigin()).getReturnType();
        if (Void.class.equals(returnType)) {
            result.append(" = void");
        } else {
            result.append(" = ");
            result.append(returnType.getSimpleName());
        }
        return result;
    }
}

