/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.component.impl;

import org.eclipse.birt.chart.model.attribute.AttributeFactory;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.InsetsImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.TextImpl;
import org.eclipse.birt.chart.model.component.ComponentFactory;
import org.eclipse.birt.chart.model.component.ComponentPackage;
import org.eclipse.birt.chart.model.component.Label;
import org.eclipse.birt.chart.util.ChartUtil;
import org.eclipse.birt.chart.util.FillUtil;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

public class LabelImpl
extends EObjectImpl
implements Label {
    protected Text caption;
    protected Fill background;
    protected LineAttributes outline;
    protected ColorDefinition shadowColor;
    protected Insets insets;
    protected static final boolean VISIBLE_EDEFAULT = true;
    protected boolean visible = true;
    protected boolean visibleESet;
    protected static final int ELLIPSIS_EDEFAULT = 0;
    protected int ellipsis = 0;
    protected boolean ellipsisESet;

    protected LabelImpl() {
    }

    protected EClass eStaticClass() {
        return ComponentPackage.Literals.LABEL;
    }

    @Override
    public Text getCaption() {
        return this.caption;
    }

    public NotificationChain basicSetCaption(Text newCaption, NotificationChain msgs) {
        Text oldCaption = this.caption;
        this.caption = newCaption;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 0, (Object)oldCaption, (Object)newCaption);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setCaption(Text newCaption) {
        if (newCaption != this.caption) {
            NotificationChain msgs = null;
            if (this.caption != null) {
                msgs = ((InternalEObject)this.caption).eInverseRemove((InternalEObject)this, -1, null, msgs);
            }
            if (newCaption != null) {
                msgs = ((InternalEObject)newCaption).eInverseAdd((InternalEObject)this, -1, null, msgs);
            }
            if ((msgs = this.basicSetCaption(newCaption, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 0, (Object)newCaption, (Object)newCaption));
        }
    }

    @Override
    public Fill getBackground() {
        return this.background;
    }

    public NotificationChain basicSetBackground(Fill newBackground, NotificationChain msgs) {
        Fill oldBackground = this.background;
        this.background = newBackground;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldBackground, (Object)newBackground);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setBackground(Fill newBackground) {
        if (newBackground != this.background) {
            NotificationChain msgs = null;
            if (this.background != null) {
                msgs = ((InternalEObject)this.background).eInverseRemove((InternalEObject)this, -2, null, msgs);
            }
            if (newBackground != null) {
                msgs = ((InternalEObject)newBackground).eInverseAdd((InternalEObject)this, -2, null, msgs);
            }
            if ((msgs = this.basicSetBackground(newBackground, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)newBackground, (Object)newBackground));
        }
    }

    @Override
    public LineAttributes getOutline() {
        return this.outline;
    }

    public NotificationChain basicSetOutline(LineAttributes newOutline, NotificationChain msgs) {
        LineAttributes oldOutline = this.outline;
        this.outline = newOutline;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 2, (Object)oldOutline, (Object)newOutline);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setOutline(LineAttributes newOutline) {
        if (newOutline != this.outline) {
            NotificationChain msgs = null;
            if (this.outline != null) {
                msgs = ((InternalEObject)this.outline).eInverseRemove((InternalEObject)this, -3, null, msgs);
            }
            if (newOutline != null) {
                msgs = ((InternalEObject)newOutline).eInverseAdd((InternalEObject)this, -3, null, msgs);
            }
            if ((msgs = this.basicSetOutline(newOutline, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 2, (Object)newOutline, (Object)newOutline));
        }
    }

    @Override
    public ColorDefinition getShadowColor() {
        return this.shadowColor;
    }

    public NotificationChain basicSetShadowColor(ColorDefinition newShadowColor, NotificationChain msgs) {
        ColorDefinition oldShadowColor = this.shadowColor;
        this.shadowColor = newShadowColor;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 3, (Object)oldShadowColor, (Object)newShadowColor);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setShadowColor(ColorDefinition newShadowColor) {
        if (newShadowColor != this.shadowColor) {
            NotificationChain msgs = null;
            if (this.shadowColor != null) {
                msgs = ((InternalEObject)this.shadowColor).eInverseRemove((InternalEObject)this, -4, null, msgs);
            }
            if (newShadowColor != null) {
                msgs = ((InternalEObject)newShadowColor).eInverseAdd((InternalEObject)this, -4, null, msgs);
            }
            if ((msgs = this.basicSetShadowColor(newShadowColor, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 3, (Object)newShadowColor, (Object)newShadowColor));
        }
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    public NotificationChain basicSetInsets(Insets newInsets, NotificationChain msgs) {
        Insets oldInsets = this.insets;
        this.insets = newInsets;
        if (this.eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl((InternalEObject)this, 1, 4, (Object)oldInsets, (Object)newInsets);
            if (msgs == null) {
                msgs = notification;
            } else {
                msgs.add((Notification)notification);
            }
        }
        return msgs;
    }

    @Override
    public void setInsets(Insets newInsets) {
        if (newInsets != this.insets) {
            NotificationChain msgs = null;
            if (this.insets != null) {
                msgs = ((InternalEObject)this.insets).eInverseRemove((InternalEObject)this, -5, null, msgs);
            }
            if (newInsets != null) {
                msgs = ((InternalEObject)newInsets).eInverseAdd((InternalEObject)this, -5, null, msgs);
            }
            if ((msgs = this.basicSetInsets(newInsets, msgs)) != null) {
                msgs.dispatch();
            }
        } else if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 4, (Object)newInsets, (Object)newInsets));
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean newVisible) {
        boolean oldVisible = this.visible;
        this.visible = newVisible;
        boolean oldVisibleESet = this.visibleESet;
        this.visibleESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 5, oldVisible, this.visible, !oldVisibleESet));
        }
    }

    @Override
    public void unsetVisible() {
        boolean oldVisible = this.visible;
        boolean oldVisibleESet = this.visibleESet;
        this.visible = true;
        this.visibleESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 5, oldVisible, true, oldVisibleESet));
        }
    }

    @Override
    public boolean isSetVisible() {
        return this.visibleESet;
    }

    @Override
    public int getEllipsis() {
        return this.ellipsis;
    }

    @Override
    public void setEllipsis(int newEllipsis) {
        int oldEllipsis = this.ellipsis;
        this.ellipsis = newEllipsis;
        boolean oldEllipsisESet = this.ellipsisESet;
        this.ellipsisESet = true;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 6, oldEllipsis, this.ellipsis, !oldEllipsisESet));
        }
    }

    @Override
    public void unsetEllipsis() {
        int oldEllipsis = this.ellipsis;
        boolean oldEllipsisESet = this.ellipsisESet;
        this.ellipsis = 0;
        this.ellipsisESet = false;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 2, 6, oldEllipsis, 0, oldEllipsisESet));
        }
    }

    @Override
    public boolean isSetEllipsis() {
        return this.ellipsisESet;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 0: {
                return this.basicSetCaption(null, msgs);
            }
            case 1: {
                return this.basicSetBackground(null, msgs);
            }
            case 2: {
                return this.basicSetOutline(null, msgs);
            }
            case 3: {
                return this.basicSetShadowColor(null, msgs);
            }
            case 4: {
                return this.basicSetInsets(null, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 0: {
                return this.getCaption();
            }
            case 1: {
                return this.getBackground();
            }
            case 2: {
                return this.getOutline();
            }
            case 3: {
                return this.getShadowColor();
            }
            case 4: {
                return this.getInsets();
            }
            case 5: {
                return this.isVisible();
            }
            case 6: {
                return this.getEllipsis();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 0: {
                this.setCaption((Text)newValue);
                return;
            }
            case 1: {
                this.setBackground((Fill)newValue);
                return;
            }
            case 2: {
                this.setOutline((LineAttributes)newValue);
                return;
            }
            case 3: {
                this.setShadowColor((ColorDefinition)newValue);
                return;
            }
            case 4: {
                this.setInsets((Insets)newValue);
                return;
            }
            case 5: {
                this.setVisible((Boolean)newValue);
                return;
            }
            case 6: {
                this.setEllipsis((Integer)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 0: {
                this.setCaption(null);
                return;
            }
            case 1: {
                this.setBackground(null);
                return;
            }
            case 2: {
                this.setOutline(null);
                return;
            }
            case 3: {
                this.setShadowColor(null);
                return;
            }
            case 4: {
                this.setInsets(null);
                return;
            }
            case 5: {
                this.unsetVisible();
                return;
            }
            case 6: {
                this.unsetEllipsis();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 0: {
                return this.caption != null;
            }
            case 1: {
                return this.background != null;
            }
            case 2: {
                return this.outline != null;
            }
            case 3: {
                return this.shadowColor != null;
            }
            case 4: {
                return this.insets != null;
            }
            case 5: {
                return this.isSetVisible();
            }
            case 6: {
                return this.isSetEllipsis();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (visible: ");
        if (this.visibleESet) {
            result.append(this.visible);
        } else {
            result.append("<unset>");
        }
        result.append(", ellipsis: ");
        if (this.ellipsisESet) {
            result.append(this.ellipsis);
        } else {
            result.append("<unset>");
        }
        result.append(')');
        return result.toString();
    }

    public static final Label create() {
        Label la = ComponentFactory.eINSTANCE.createLabel();
        ((LabelImpl)la).initialize();
        return la;
    }

    protected final void initialize() {
        this.setCaption(TextImpl.create(null));
        this.setBackground(ColorDefinitionImpl.TRANSPARENT());
        Insets ins = AttributeFactory.eINSTANCE.createInsets();
        ((InsetsImpl)ins).set(0.0, 2.0, 0.0, 3.0);
        this.setInsets(ins);
        LineAttributes lia = AttributeFactory.eINSTANCE.createLineAttributes();
        ((LineAttributesImpl)lia).set(ColorDefinitionImpl.BLACK(), LineStyle.SOLID_LITERAL, 1);
        this.setOutline(lia);
        this.setVisible(true);
    }

    public static final Label createDefault() {
        Label la = ComponentFactory.eINSTANCE.createLabel();
        ((LabelImpl)la).initDefault(true);
        return la;
    }

    public static final Label createDefault(boolean visible) {
        Label la = ComponentFactory.eINSTANCE.createLabel();
        ((LabelImpl)la).initDefault(visible);
        return la;
    }

    protected final void initDefault(boolean visible) {
        this.setCaption(TextImpl.createDefault(null));
        Insets ins = InsetsImpl.createDefault(0.0, 2.0, 0.0, 3.0);
        this.setInsets(ins);
        LineAttributes lia = LineAttributesImpl.createDefault(null, LineStyle.SOLID_LITERAL, 1);
        this.setOutline(lia);
        this.visible = visible;
    }

    @Override
    public Label copyInstance() {
        Insets tInsets;
        ColorDefinition tShadowColor;
        LineAttributes tOutline;
        Fill tBackground;
        LabelImpl dest = new LabelImpl();
        Text tCaption = this.getCaption();
        if (tCaption != null) {
            dest.caption = tCaption.copyInstance();
        }
        if ((tBackground = this.getBackground()) != null) {
            dest.background = tBackground.copyInstance();
        }
        if ((tOutline = this.getOutline()) != null) {
            dest.outline = tOutline.copyInstance();
        }
        if ((tShadowColor = this.getShadowColor()) != null) {
            dest.shadowColor = tShadowColor.copyInstance();
        }
        if ((tInsets = this.getInsets()) != null) {
            dest.insets = tInsets.copyInstance();
        }
        dest.visible = this.isVisible();
        dest.visibleESet = this.isSetVisible();
        dest.ellipsis = this.getEllipsis();
        dest.ellipsisESet = this.isSetEllipsis();
        return dest;
    }

    protected void set(Label src) {
        if (src.getCaption() != null) {
            this.setCaption(src.getCaption().copyInstance());
        }
        if (src.getBackground() != null) {
            this.setBackground(src.getBackground().copyInstance());
        }
        if (src.getOutline() != null) {
            this.setOutline(src.getOutline().copyInstance());
        }
        if (src.getShadowColor() != null) {
            this.setShadowColor(src.getShadowColor().copyInstance());
        }
        if (src.getInsets() != null) {
            this.setInsets(src.getInsets().copyInstance());
        }
        this.visible = src.isVisible();
        this.visibleESet = src.isSetVisible();
        this.ellipsis = src.getEllipsis();
        this.ellipsisESet = src.isSetEllipsis();
    }

    public static Label copyCompactInstance(Label src) {
        if (src == null) {
            return null;
        }
        LabelImpl lb = new LabelImpl();
        lb.visible = src.isVisible();
        lb.visibleESet = src.isSetVisible();
        if (src.getBackground() != null) {
            lb.background = FillUtil.copyOf(src.getBackground());
        }
        lb.caption = src.getCaption().copyInstance();
        lb.insets = src.getInsets().copyInstance();
        if (src.getOutline() != null && src.getOutline().isVisible()) {
            lb.outline = src.getOutline().copyInstance();
        }
        if (ChartUtil.isShadowDefined(src)) {
            lb.shadowColor = src.getShadowColor().copyInstance();
        }
        return lb;
    }
}

