/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.core.namespace;

import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.NameSpace;
import org.eclipse.birt.report.model.core.namespace.AbstractNameHelper;
import org.eclipse.birt.report.model.core.namespace.INameContext;
import org.eclipse.birt.report.model.core.namespace.NameContextFactory;
import org.eclipse.birt.report.model.elements.olap.Dimension;
import org.eclipse.birt.report.model.metadata.ElementDefn;

public class DimensionNameHelper
extends AbstractNameHelper {
    protected Dimension dimension = null;

    public DimensionNameHelper(Dimension dimension) {
        this.dimension = dimension;
    }

    @Override
    protected INameContext createNameContext(String name) {
        return NameContextFactory.createDimensionNameContext(this.dimension, "dimension-level");
    }

    public void addElement(DesignElement element) {
        if (element == null || element.getName() == null) {
            return;
        }
        ElementDefn defn = (ElementDefn)element.getDefn();
        if (!this.dimension.getDefn().isKindOf(defn.getNameConfig().getNameContainer())) {
            return;
        }
        String id = defn.getNameSpaceID();
        NameSpace ns = this.getCachedNameSpace(id);
        if (!ns.contains(element.getName())) {
            ns.insert(element);
        }
    }

    @Override
    public void addContentName(String id, String name) {
    }

    @Override
    public DesignElement getElement() {
        return this.dimension;
    }
}

